/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.inspector;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListInput
extends JPanel
implements ListSelectionListener,
ActionListener {
    protected JLabel label;
    protected JTextField textfield;
    protected JList list;
    protected JScrollPane scrollPane;

    public ListInput(String[] data, String title) {
        this.setLayout(null);
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.label = new ListInputLabel(title, 2);
        this.add(this.label);
        this.textfield = new ListInputText();
        this.textfield.addActionListener(this);
        this.label.setLabelFor(this.textfield);
        this.add(this.textfield);
        this.list = new ListInputList(data);
        this.list.setVisibleRowCount(4);
        this.list.addListSelectionListener(this);
        this.scrollPane = new JScrollPane(this.list);
        this.scrollPane.setVisible(false);
        this.add(this.scrollPane);
        this.textfield.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
                ListInput.this.scrollPane.setVisible(true);
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 10: 
                    case 27: {
                        ListInput.this.scrollPane.setVisible(false);
                        break;
                    }
                }
            }
        });
    }

    public ListInput(String title, int numCols) {
        this.setLayout(null);
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.label = new ListInputLabel(title, 2);
        this.add(this.label);
        this.textfield = new ListInputText(numCols);
        this.textfield.addActionListener(this);
        this.label.setLabelFor(this.textfield);
        this.add(this.textfield);
        this.list = new ListInputList();
        this.list.setVisibleRowCount(4);
        this.list.addListSelectionListener(this);
        this.scrollPane = new JScrollPane(this.list);
        this.add(this.scrollPane);
    }

    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.label.setToolTipText(text);
        this.textfield.setToolTipText(text);
        this.list.setToolTipText(text);
    }

    public void setDisplayedMnemonic(char ch) {
        this.label.setDisplayedMnemonic(ch);
    }

    public void setSelected(String sel) {
        this.list.setSelectedValue(sel, true);
        this.textfield.setText(sel);
    }

    public String getSelected() {
        return this.textfield.getText();
    }

    public void setSelectedInt(int value) {
        this.setSelected(Integer.toString(value));
    }

    public int getSelectedInt() {
        try {
            return Integer.parseInt(this.getSelected());
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        Object obj = this.list.getSelectedValue();
        if (obj != null) {
            this.textfield.setText(obj.toString());
        }
    }

    public void actionPerformed(ActionEvent e) {
        ListModel model = this.list.getModel();
        String key = this.textfield.getText().toLowerCase();
        for (int i = 0; i < model.getSize(); ++i) {
            String data = (String)model.getElementAt(i);
            if (!data.toLowerCase().startsWith(key)) continue;
            this.list.setSelectedValue(data, true);
            break;
        }
    }

    public void addListSelectionListener(ListSelectionListener lst) {
        this.list.addListSelectionListener(lst);
    }

    public Dimension getPreferredSize() {
        Insets ins = this.getInsets();
        Dimension labelSize = this.label.getPreferredSize();
        Dimension textfieldSize = this.textfield.getPreferredSize();
        Dimension scrollPaneSize = this.scrollPane.getPreferredSize();
        int w = Math.max(Math.max(labelSize.width, textfieldSize.width), scrollPaneSize.width);
        int h = labelSize.height + textfieldSize.height + scrollPaneSize.height;
        return new Dimension(w + ins.left + ins.right, h + ins.top + ins.bottom);
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void doLayout() {
        Insets ins = this.getInsets();
        Dimension size = this.getSize();
        int x = ins.left;
        int y = ins.top;
        int w = size.width - ins.left - ins.right;
        int h = size.height - ins.top - ins.bottom;
        Dimension labelSize = this.label.getPreferredSize();
        this.label.setBounds(x, y, w, labelSize.height);
        Dimension textfieldSize = this.textfield.getPreferredSize();
        this.textfield.setBounds(x, y += labelSize.height, w, textfieldSize.height);
        this.scrollPane.setBounds(x, y += textfieldSize.height, w, h - y);
    }

    public void appendResultSet(ResultSet results, int index, boolean toTitleCase) {
        this.textfield.setText("");
        DefaultListModel<String> model = new DefaultListModel<String>();
        try {
            while (results.next()) {
                String str = results.getString(index);
                if (toTitleCase) {
                    str = Character.toUpperCase(str.charAt(0)) + str.substring(1);
                }
                model.addElement(str);
            }
        }
        catch (SQLException ex) {
            System.err.println("appendResultSet: " + ex.toString());
        }
        this.list.setModel(model);
        if (model.getSize() > 0) {
            this.list.setSelectedIndex(0);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleOpenList();
        }
        return this.accessibleContext;
    }

    public static void main(String[] a) {
        String[] fontNames = new String[]{"Roman", "Times Roman"};
        ListInput lstFontName = new ListInput(fontNames, "Name:");
        lstFontName.setDisplayedMnemonic('n');
        lstFontName.setToolTipText("Font name");
        JFrame f = new JFrame();
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.getContentPane().add(lstFontName);
        f.pack();
        f.setSize(new Dimension(300, 200));
        f.show();
    }

    protected class AccessibleOpenList
    extends JComponent.AccessibleJComponent {
        protected AccessibleOpenList() {
            super(ListInput.this);
        }

        public String getAccessibleName() {
            System.out.println("getAccessibleName: " + this.accessibleName);
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            return ListInput.this.label.getText();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST;
        }
    }

    class ListInputList
    extends JList {
        public ListInputList() {
        }

        public ListInputList(String[] data) {
            super(data);
        }

        public AccessibleContext getAccessibleContext() {
            return ListInput.this.getAccessibleContext();
        }
    }

    class ListInputText
    extends JTextField {
        public ListInputText() {
        }

        public ListInputText(int numCols) {
            super(numCols);
        }

        public AccessibleContext getAccessibleContext() {
            return ListInput.this.getAccessibleContext();
        }
    }

    class ListInputLabel
    extends JLabel {
        public ListInputLabel(String text, int alignment) {
            super(text, alignment);
        }

        public AccessibleContext getAccessibleContext() {
            return ListInput.this.getAccessibleContext();
        }
    }
}

