/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.inspector;

import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.apache.zookeeper.inspector.gui.ZooInspectorPanel;
import org.apache.zookeeper.inspector.logger.LoggerFactory;
import org.apache.zookeeper.inspector.manager.ZooInspectorManagerImpl;

public class ZooInspector {
    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            JFrame frame = new JFrame("ZooInspector");
            frame.setDefaultCloseOperation(3);
            final ZooInspectorPanel zooInspectorPanel = new ZooInspectorPanel(new ZooInspectorManagerImpl());
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent e) {
                    super.windowClosed(e);
                    zooInspectorPanel.disconnect(true);
                }
            });
            frame.setContentPane(zooInspectorPanel);
            frame.setSize(1024, 768);
            frame.setVisible(true);
        }
        catch (Exception e) {
            LoggerFactory.getLogger().error((Object)"Error occurred loading ZooInspector", (Throwable)e);
            JOptionPane.showMessageDialog(null, "ZooInspector failed to start: " + e.getMessage(), "Error", 0);
        }
    }

    private static Dimension getScreenResolution() {
        int i = 0;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] screenDevices = ge.getScreenDevices();
        if (i < screenDevices.length) {
            System.out.println(screenDevices[i].getIDstring());
            DisplayMode dm = screenDevices[i].getDisplayMode();
            int screenWidth = dm.getWidth();
            int screenHeight = dm.getHeight();
            System.out.println("Cake: " + screenWidth + " " + screenHeight);
            return new Dimension(screenWidth, screenHeight);
        }
        return null;
    }
}

