/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.inspector.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.zookeeper.inspector.gui.ZooInspectorPanel;
import org.apache.zookeeper.inspector.logger.LoggerFactory;
import org.apache.zookeeper.inspector.manager.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZooInspectorConnectionPropertiesDialog
extends JDialog {
    private final HashMap<String, JComponent> components;

    public ZooInspectorConnectionPropertiesDialog(Properties lastConnectionProps, Pair<Map<String, List<String>>, Map<String, String>> connectionPropertiesTemplateAndLabels, final ZooInspectorPanel zooInspectorPanel) {
        Map<String, List<String>> connectionPropertiesTemplate = connectionPropertiesTemplateAndLabels.getKey();
        Map<String, String> connectionPropertiesLabels = connectionPropertiesTemplateAndLabels.getValue();
        this.setLayout(new BorderLayout());
        this.setTitle("Connection Settings");
        this.setModal(true);
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        final JPanel options = new JPanel();
        final JFileChooser fileChooser = new JFileChooser();
        options.setLayout(new GridBagLayout());
        int i = 0;
        final JButton okButton = new JButton("OK");
        final JButton cancelButton = new JButton("Cancel");
        this.components = new HashMap();
        for (Map.Entry<String, List<String>> entry : connectionPropertiesTemplate.entrySet()) {
            GridBagConstraints c2;
            JTextField text;
            int rowPos = 2 * i + 1;
            JLabel label = new JLabel(connectionPropertiesLabels.get(entry.getKey()));
            GridBagConstraints c1 = new GridBagConstraints();
            c1.gridx = 0;
            c1.gridy = rowPos;
            c1.gridwidth = 1;
            c1.gridheight = 1;
            c1.weightx = 0.0;
            c1.weighty = 0.0;
            c1.anchor = 17;
            c1.fill = 2;
            c1.insets = new Insets(5, 5, 5, 5);
            c1.ipadx = 0;
            c1.ipady = 0;
            options.add((Component)label, c1);
            if (entry.getValue().size() == 0) {
                text = new JTextField();
                c2 = new GridBagConstraints();
                c2.gridx = 2;
                c2.gridy = rowPos;
                c2.gridwidth = 1;
                c2.gridheight = 1;
                c2.weightx = 0.0;
                c2.weighty = 0.0;
                c2.anchor = 17;
                c2.fill = 2;
                c2.insets = new Insets(5, 5, 5, 5);
                c2.ipadx = 0;
                c2.ipady = 0;
                options.add((Component)text, c2);
                this.components.put(entry.getKey(), text);
            } else if (entry.getValue().size() == 1) {
                text = new JTextField(entry.getValue().get(0));
                text.addKeyListener(new KeyListener(){

                    public void keyTyped(KeyEvent e) {
                    }

                    public void keyReleased(KeyEvent e) {
                    }

                    public void keyPressed(KeyEvent e) {
                        switch (e.getKeyCode()) {
                            case 10: {
                                okButton.doClick();
                                break;
                            }
                            case 27: {
                                cancelButton.doClick();
                                break;
                            }
                        }
                    }
                });
                c2 = new GridBagConstraints();
                c2.gridx = 2;
                c2.gridy = rowPos;
                c2.gridwidth = 1;
                c2.gridheight = 1;
                c2.weightx = 0.0;
                c2.weighty = 0.0;
                c2.anchor = 17;
                c2.fill = 2;
                c2.insets = new Insets(5, 5, 5, 5);
                c2.ipadx = 0;
                c2.ipady = 0;
                options.add((Component)text, c2);
                this.components.put(entry.getKey(), text);
            } else {
                List<String> list = entry.getValue();
                JComboBox<String> combo = new JComboBox<String>(list.toArray(new String[list.size()]));
                combo.setEditable(true);
                combo.setSelectedItem(list.get(0));
                combo.getEditor().getEditorComponent().addKeyListener(new KeyListener(){

                    public void keyTyped(KeyEvent e) {
                    }

                    public void keyReleased(KeyEvent e) {
                    }

                    public void keyPressed(KeyEvent e) {
                        switch (e.getKeyCode()) {
                            case 10: {
                                okButton.doClick();
                                break;
                            }
                            case 27: {
                                cancelButton.doClick();
                                break;
                            }
                        }
                    }
                });
                GridBagConstraints c22 = new GridBagConstraints();
                c22.gridx = 2;
                c22.gridy = rowPos;
                c22.gridwidth = 1;
                c22.gridheight = 1;
                c22.weightx = 0.0;
                c22.weighty = 0.0;
                c22.anchor = 17;
                c22.fill = 2;
                c22.insets = new Insets(5, 5, 5, 5);
                c22.ipadx = 0;
                c22.ipady = 0;
                options.add(combo, c22);
                this.components.put(entry.getKey(), combo);
            }
            ++i;
        }
        this.loadConnectionProps(lastConnectionProps);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new GridBagLayout());
        JButton loadPropsFileButton = new JButton("Load from file");
        loadPropsFileButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                int result = fileChooser.showOpenDialog(ZooInspectorConnectionPropertiesDialog.this);
                if (result == 0) {
                    File propsFilePath = fileChooser.getSelectedFile();
                    Properties props = new Properties();
                    try {
                        FileReader reader = new FileReader(propsFilePath);
                        try {
                            props.load(reader);
                            ZooInspectorConnectionPropertiesDialog.this.loadConnectionProps(props);
                        }
                        finally {
                            reader.close();
                        }
                    }
                    catch (IOException ex) {
                        LoggerFactory.getLogger().error((Object)"An Error occurred loading connection properties from file", (Throwable)ex);
                        JOptionPane.showMessageDialog(ZooInspectorConnectionPropertiesDialog.this, "An Error occurred loading connection properties from file", "Error", 0);
                    }
                    options.revalidate();
                    options.repaint();
                }
            }
        });
        GridBagConstraints c3 = new GridBagConstraints();
        c3.gridx = 0;
        c3.gridy = 0;
        c3.gridwidth = 1;
        c3.gridheight = 1;
        c3.weightx = 0.0;
        c3.weighty = 1.0;
        c3.anchor = 16;
        c3.fill = 0;
        c3.insets = new Insets(5, 5, 5, 5);
        c3.ipadx = 0;
        c3.ipady = 0;
        buttonsPanel.add((Component)loadPropsFileButton, c3);
        JButton saveDefaultPropsFileButton = new JButton("Set As Default");
        saveDefaultPropsFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Properties connectionProps = ZooInspectorConnectionPropertiesDialog.this.getConnectionProps();
                try {
                    zooInspectorPanel.setdefaultConnectionProps(connectionProps);
                }
                catch (IOException ex) {
                    LoggerFactory.getLogger().error((Object)"An Error occurred saving the default connection properties file", (Throwable)ex);
                    JOptionPane.showMessageDialog(ZooInspectorConnectionPropertiesDialog.this, "An Error occurred saving the default connection properties file", "Error", 0);
                }
            }
        });
        GridBagConstraints c6 = new GridBagConstraints();
        c6.gridx = 1;
        c6.gridy = 0;
        c6.gridwidth = 1;
        c6.gridheight = 1;
        c6.weightx = 1.0;
        c6.weighty = 1.0;
        c6.anchor = 16;
        c6.fill = 0;
        c6.insets = new Insets(5, 5, 5, 5);
        c6.ipadx = 0;
        c6.ipady = 0;
        buttonsPanel.add((Component)saveDefaultPropsFileButton, c6);
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZooInspectorConnectionPropertiesDialog.this.dispose();
                Properties connectionProps = ZooInspectorConnectionPropertiesDialog.this.getConnectionProps();
                zooInspectorPanel.connect(connectionProps);
            }
        });
        GridBagConstraints c4 = new GridBagConstraints();
        c4.gridx = 2;
        c4.gridy = 0;
        c4.gridwidth = 1;
        c4.gridheight = 1;
        c4.weightx = 0.0;
        c4.weighty = 1.0;
        c4.anchor = 15;
        c4.fill = 2;
        c4.insets = new Insets(5, 5, 5, 5);
        c4.ipadx = 0;
        c4.ipady = 0;
        buttonsPanel.add((Component)okButton, c4);
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZooInspectorConnectionPropertiesDialog.this.dispose();
            }
        });
        GridBagConstraints c5 = new GridBagConstraints();
        c5.gridx = 3;
        c5.gridy = 0;
        c5.gridwidth = 1;
        c5.gridheight = 1;
        c5.weightx = 0.0;
        c5.weighty = 1.0;
        c5.anchor = 15;
        c5.fill = 2;
        c5.insets = new Insets(5, 5, 5, 5);
        c5.ipadx = 0;
        c5.ipady = 0;
        buttonsPanel.add((Component)cancelButton, c5);
        this.add((Component)options, "Center");
        this.add((Component)buttonsPanel, "South");
        this.pack();
    }

    private void loadConnectionProps(Properties props) {
        if (props != null) {
            for (Object key : props.keySet()) {
                String propsKey = (String)key;
                if (!this.components.containsKey(propsKey)) continue;
                JComponent component = this.components.get(propsKey);
                String value = props.getProperty(propsKey);
                if (component instanceof JTextField) {
                    ((JTextField)component).setText(value);
                    continue;
                }
                if (!(component instanceof JComboBox)) continue;
                ((JComboBox)component).setSelectedItem(value);
            }
        }
    }

    private Properties getConnectionProps() {
        Properties connectionProps = new Properties();
        for (Map.Entry<String, JComponent> entry : this.components.entrySet()) {
            String value = null;
            JComponent component = entry.getValue();
            if (component instanceof JTextField) {
                value = ((JTextField)component).getText();
            } else if (component instanceof JComboBox) {
                value = ((JComboBox)component).getEditor().getItem().toString();
            }
            connectionProps.put(entry.getKey(), value);
        }
        return connectionProps;
    }
}

