/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.inspector.gui;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.ImageIcon;

public class ZooInspectorIconResources {
    public static ImageIcon getTreeLeafIcon() {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("icons/file_obj.gif");
        return new ImageIcon(ZooInspectorIconResources.readFully(in));
    }

    public static ImageIcon getTreeOpenIcon() {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("icons/fldr_obj.gif");
        return new ImageIcon(ZooInspectorIconResources.readFully(in));
    }

    public static ImageIcon getTreeClosedIcon() {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("icons/fldr_obj.gif");
        return new ImageIcon(ZooInspectorIconResources.readFully(in));
    }

    public static byte[] readFully(InputStream input) {
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            int bytesRead;
            while ((bytesRead = input.read(buffer)) != -1) {
                output.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return output.toByteArray();
    }

    public static ImageIcon getConnectIcon() {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("icons/launch_run.gif");
        ImageIcon icon = new ImageIcon(ZooInspectorIconResources.readFully(in));
        return icon;
    }

    public static ImageIcon getDisconnectIcon() {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("icons/launch_stop.gif");
        return new ImageIcon(ZooInspectorIconResources.readFully(in));
    }

    public static ImageIcon getSaveIcon() {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("icons/save_edit.gif");
        return new ImageIcon(ZooInspectorIconResources.readFully(in));
    }

    public static ImageIcon getAddNodeIcon() {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("icons/new_con.gif");
        return new ImageIcon(ZooInspectorIconResources.readFully(in));
    }

    public static ImageIcon getDeleteNodeIcon() {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("icons/trash.gif");
        return new ImageIcon(ZooInspectorIconResources.readFully(in));
    }

    public static ImageIcon getRefreshIcon() {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("icons/refresh.gif");
        return new ImageIcon(ZooInspectorIconResources.readFully(in));
    }

    public static ImageIcon getInformationIcon() {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("icons/info_obj.gif");
        return new ImageIcon(ZooInspectorIconResources.readFully(in));
    }

    public static ImageIcon getChangeNodeViewersIcon() {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("icons/edtsrclkup_co.gif");
        return new ImageIcon(ZooInspectorIconResources.readFully(in));
    }

    public static ImageIcon getUpIcon() {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("icons/search_prev.gif");
        return new ImageIcon(ZooInspectorIconResources.readFully(in));
    }

    public static ImageIcon getDownIcon() {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("icons/search_next.gif");
        return new ImageIcon(ZooInspectorIconResources.readFully(in));
    }

    public static ImageIcon getEditIcon() {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("icons/edit.gif");
        return new ImageIcon(ZooInspectorIconResources.readFully(in));
    }

    public static ImageIcon getSearchIcon() {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("icons/search.gif");
        return new ImageIcon(ZooInspectorIconResources.readFully(in));
    }
}

