/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.inspector.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.zookeeper.inspector.gui.NodeViewersChangeListener;
import org.apache.zookeeper.inspector.gui.ZooInspectorIconResources;
import org.apache.zookeeper.inspector.gui.nodeviewer.ZooInspectorNodeViewer;
import org.apache.zookeeper.inspector.logger.LoggerFactory;
import org.apache.zookeeper.inspector.manager.ZooInspectorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZooInspectorNodeViewersDialog
extends JDialog
implements ListSelectionListener {
    private final JButton upButton;
    private final JButton downButton;
    private final JButton removeButton;
    private final JButton addButton;
    private final JList viewersList;
    private final JButton saveFileButton;
    private final JButton loadFileButton;
    private final JButton setDefaultsButton;
    private final JFileChooser fileChooser = new JFileChooser(new File("."));

    public ZooInspectorNodeViewersDialog(Frame frame, final List<ZooInspectorNodeViewer> currentViewers, final Collection<NodeViewersChangeListener> listeners, final ZooInspectorManager manager) {
        super(frame);
        final ArrayList<ZooInspectorNodeViewer> newViewers = new ArrayList<ZooInspectorNodeViewer>(currentViewers);
        this.setLayout(new BorderLayout());
        this.setIconImage(ZooInspectorIconResources.getChangeNodeViewersIcon().getImage());
        this.setTitle("About ZooInspector");
        this.setModal(true);
        this.setAlwaysOnTop(true);
        this.setResizable(true);
        final JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this.viewersList = new JList();
        DefaultListModel<ZooInspectorNodeViewer> model = new DefaultListModel<ZooInspectorNodeViewer>();
        for (ZooInspectorNodeViewer viewer : newViewers) {
            model.addElement(viewer);
        }
        this.viewersList.setModel(model);
        this.viewersList.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                ZooInspectorNodeViewer viewer = (ZooInspectorNodeViewer)value;
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                label.setText(viewer.getTitle());
                return label;
            }
        });
        this.viewersList.setDropMode(DropMode.INSERT);
        this.viewersList.enableInputMethods(true);
        this.viewersList.setDragEnabled(true);
        this.viewersList.setSelectionMode(0);
        this.viewersList.getSelectionModel().addListSelectionListener(this);
        this.viewersList.setTransferHandler(new TransferHandler(){

            public boolean canImport(TransferHandler.TransferSupport info) {
                if (!info.isDataFlavorSupported(ZooInspectorNodeViewer.nodeViewerDataFlavor)) {
                    return false;
                }
                JList.DropLocation dl = (JList.DropLocation)info.getDropLocation();
                return dl.getIndex() != -1;
            }

            public boolean importData(TransferHandler.TransferSupport info) {
                String data;
                JList.DropLocation dl = (JList.DropLocation)info.getDropLocation();
                DefaultListModel listModel = (DefaultListModel)ZooInspectorNodeViewersDialog.this.viewersList.getModel();
                int index = dl.getIndex();
                boolean insert = dl.isInsert();
                Transferable t = info.getTransferable();
                try {
                    data = (String)t.getTransferData(ZooInspectorNodeViewer.nodeViewerDataFlavor);
                }
                catch (Exception e) {
                    return false;
                }
                try {
                    ZooInspectorNodeViewer viewer = (ZooInspectorNodeViewer)Class.forName(data).newInstance();
                    if (listModel.contains(viewer)) {
                        listModel.removeElement(viewer);
                    }
                    if (insert) {
                        listModel.add(index, viewer);
                    } else {
                        listModel.set(index, viewer);
                    }
                    return true;
                }
                catch (Exception e) {
                    LoggerFactory.getLogger().error((Object)("Error instantiating class: " + data), (Throwable)e);
                    return false;
                }
            }

            public int getSourceActions(JComponent c) {
                return 2;
            }

            protected Transferable createTransferable(JComponent c) {
                JList list = (JList)c;
                ZooInspectorNodeViewer value = (ZooInspectorNodeViewer)list.getSelectedValue();
                return value;
            }
        });
        JScrollPane scroller = new JScrollPane(this.viewersList);
        GridBagConstraints c1 = new GridBagConstraints();
        c1.gridx = 0;
        c1.gridy = 0;
        c1.gridwidth = 3;
        c1.gridheight = 3;
        c1.weightx = 0.0;
        c1.weighty = 1.0;
        c1.anchor = 10;
        c1.fill = 1;
        c1.insets = new Insets(5, 5, 5, 5);
        c1.ipadx = 0;
        c1.ipady = 0;
        panel.add((Component)scroller, c1);
        this.upButton = new JButton(ZooInspectorIconResources.getUpIcon());
        this.downButton = new JButton(ZooInspectorIconResources.getDownIcon());
        this.removeButton = new JButton(ZooInspectorIconResources.getDeleteNodeIcon());
        this.addButton = new JButton(ZooInspectorIconResources.getAddNodeIcon());
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.addButton.setEnabled(true);
        this.upButton.setToolTipText("Move currently selected node viewer up");
        this.downButton.setToolTipText("Move currently selected node viewer down");
        this.removeButton.setToolTipText("Remove currently selected node viewer");
        this.addButton.setToolTipText("Add node viewer");
        final JTextField newViewerTextField = new JTextField();
        GridBagConstraints c2 = new GridBagConstraints();
        c2.gridx = 3;
        c2.gridy = 0;
        c2.gridwidth = 1;
        c2.gridheight = 1;
        c2.weightx = 0.0;
        c2.weighty = 0.0;
        c2.anchor = 11;
        c2.fill = 2;
        c2.insets = new Insets(5, 5, 5, 5);
        c2.ipadx = 0;
        c2.ipady = 0;
        panel.add((Component)this.upButton, c2);
        GridBagConstraints c3 = new GridBagConstraints();
        c3.gridx = 3;
        c3.gridy = 2;
        c3.gridwidth = 1;
        c3.gridheight = 1;
        c3.weightx = 0.0;
        c3.weighty = 0.0;
        c3.anchor = 11;
        c3.fill = 2;
        c3.insets = new Insets(5, 5, 5, 5);
        c3.ipadx = 0;
        c3.ipady = 0;
        panel.add((Component)this.downButton, c3);
        GridBagConstraints c4 = new GridBagConstraints();
        c4.gridx = 3;
        c4.gridy = 1;
        c4.gridwidth = 1;
        c4.gridheight = 1;
        c4.weightx = 0.0;
        c4.weighty = 0.0;
        c4.anchor = 11;
        c4.fill = 2;
        c4.insets = new Insets(5, 5, 5, 5);
        c4.ipadx = 0;
        c4.ipady = 0;
        panel.add((Component)this.removeButton, c4);
        GridBagConstraints c5 = new GridBagConstraints();
        c5.gridx = 0;
        c5.gridy = 3;
        c5.gridwidth = 3;
        c5.gridheight = 1;
        c5.weightx = 0.0;
        c5.weighty = 0.0;
        c5.anchor = 10;
        c5.fill = 1;
        c5.insets = new Insets(5, 5, 5, 5);
        c5.ipadx = 0;
        c5.ipady = 0;
        panel.add((Component)newViewerTextField, c5);
        GridBagConstraints c6 = new GridBagConstraints();
        c6.gridx = 3;
        c6.gridy = 3;
        c6.gridwidth = 1;
        c6.gridheight = 1;
        c6.weightx = 0.0;
        c6.weighty = 0.0;
        c6.anchor = 10;
        c6.fill = 1;
        c6.insets = new Insets(5, 5, 5, 5);
        c6.ipadx = 0;
        c6.ipady = 0;
        panel.add((Component)this.addButton, c6);
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefaultListModel listModel = (DefaultListModel)ZooInspectorNodeViewersDialog.this.viewersList.getModel();
                ZooInspectorNodeViewer viewer = (ZooInspectorNodeViewer)ZooInspectorNodeViewersDialog.this.viewersList.getSelectedValue();
                int index = ZooInspectorNodeViewersDialog.this.viewersList.getSelectedIndex();
                if (listModel.contains(viewer)) {
                    listModel.removeElementAt(index);
                    listModel.insertElementAt(viewer, index - 1);
                    ZooInspectorNodeViewersDialog.this.viewersList.setSelectedValue(viewer, true);
                }
            }
        });
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefaultListModel listModel = (DefaultListModel)ZooInspectorNodeViewersDialog.this.viewersList.getModel();
                ZooInspectorNodeViewer viewer = (ZooInspectorNodeViewer)ZooInspectorNodeViewersDialog.this.viewersList.getSelectedValue();
                int index = ZooInspectorNodeViewersDialog.this.viewersList.getSelectedIndex();
                if (listModel.contains(viewer)) {
                    listModel.removeElementAt(index);
                    listModel.insertElementAt(viewer, index + 1);
                    ZooInspectorNodeViewersDialog.this.viewersList.setSelectedValue(viewer, true);
                }
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefaultListModel listModel = (DefaultListModel)ZooInspectorNodeViewersDialog.this.viewersList.getModel();
                ZooInspectorNodeViewer viewer = (ZooInspectorNodeViewer)ZooInspectorNodeViewersDialog.this.viewersList.getSelectedValue();
                int index = ZooInspectorNodeViewersDialog.this.viewersList.getSelectedIndex();
                if (listModel.contains(viewer)) {
                    listModel.removeElement(viewer);
                    ZooInspectorNodeViewersDialog.this.viewersList.setSelectedIndex(index == listModel.size() ? index - 1 : index);
                }
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String className = newViewerTextField.getText();
                if (className == null || className.length() == 0) {
                    JOptionPane.showMessageDialog(ZooInspectorNodeViewersDialog.this, "Please enter the full class name for a Node Viewer and click the add button", "Input Error", 0);
                } else {
                    try {
                        DefaultListModel listModel = (DefaultListModel)ZooInspectorNodeViewersDialog.this.viewersList.getModel();
                        ZooInspectorNodeViewer viewer = (ZooInspectorNodeViewer)Class.forName(className).newInstance();
                        if (listModel.contains(viewer)) {
                            JOptionPane.showMessageDialog(ZooInspectorNodeViewersDialog.this, "Node viewer already exists.  Each node viewer can only be added once.", "Input Error", 0);
                        } else {
                            listModel.addElement(viewer);
                        }
                    }
                    catch (Exception ex) {
                        LoggerFactory.getLogger().error((Object)"An error occurred while instaniating the node viewer. ", (Throwable)ex);
                        JOptionPane.showMessageDialog(ZooInspectorNodeViewersDialog.this, "An error occurred while instaniating the node viewer: " + ex.getMessage(), "Error", 0);
                    }
                }
            }
        });
        this.saveFileButton = new JButton("Save");
        this.loadFileButton = new JButton("Load");
        this.setDefaultsButton = new JButton("Set As Defaults");
        this.saveFileButton.setToolTipText("Save current node viewer configuration to file");
        this.loadFileButton.setToolTipText("Load node viewer configuration frm file");
        this.setDefaultsButton.setToolTipText("Set current configuration asd defaults");
        GridBagConstraints c7 = new GridBagConstraints();
        c7.gridx = 0;
        c7.gridy = 4;
        c7.gridwidth = 1;
        c7.gridheight = 1;
        c7.weightx = 1.0;
        c7.weighty = 0.0;
        c7.anchor = 17;
        c7.fill = 3;
        c7.insets = new Insets(5, 5, 5, 5);
        c7.ipadx = 0;
        c7.ipady = 0;
        panel.add((Component)this.saveFileButton, c7);
        GridBagConstraints c8 = new GridBagConstraints();
        c8.gridx = 1;
        c8.gridy = 4;
        c8.gridwidth = 1;
        c8.gridheight = 1;
        c8.weightx = 0.0;
        c8.weighty = 0.0;
        c8.anchor = 17;
        c8.fill = 3;
        c8.insets = new Insets(5, 5, 5, 5);
        c8.ipadx = 0;
        c8.ipady = 0;
        panel.add((Component)this.loadFileButton, c8);
        GridBagConstraints c9 = new GridBagConstraints();
        c9.gridx = 2;
        c9.gridy = 4;
        c9.gridwidth = 1;
        c9.gridheight = 1;
        c9.weightx = 0.0;
        c9.weighty = 0.0;
        c9.anchor = 17;
        c9.fill = 3;
        c9.insets = new Insets(5, 5, 5, 5);
        c9.ipadx = 0;
        c9.ipady = 0;
        panel.add((Component)this.setDefaultsButton, c9);
        this.saveFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int result = ZooInspectorNodeViewersDialog.this.fileChooser.showSaveDialog(ZooInspectorNodeViewersDialog.this);
                if (result == 0) {
                    File selectedFile = ZooInspectorNodeViewersDialog.this.fileChooser.getSelectedFile();
                    int answer = 0;
                    if (selectedFile.exists()) {
                        answer = JOptionPane.showConfirmDialog(ZooInspectorNodeViewersDialog.this, "The specified file already exists.  do you want to overwrite it?", "Confirm Overwrite", 0, 2);
                    }
                    if (answer == 0) {
                        Object[] modelContents;
                        DefaultListModel listModel = (DefaultListModel)ZooInspectorNodeViewersDialog.this.viewersList.getModel();
                        ArrayList<String> nodeViewersClassNames = new ArrayList<String>();
                        for (Object o : modelContents = listModel.toArray()) {
                            nodeViewersClassNames.add(((ZooInspectorNodeViewer)o).getClass().getCanonicalName());
                        }
                        try {
                            manager.saveNodeViewersFile(selectedFile, nodeViewersClassNames);
                        }
                        catch (IOException ex) {
                            LoggerFactory.getLogger().error((Object)"Error saving node veiwer configuration from file.", (Throwable)ex);
                            JOptionPane.showMessageDialog(ZooInspectorNodeViewersDialog.this, "Error saving node veiwer configuration from file: " + ex.getMessage(), "Error", 0);
                        }
                    }
                }
            }
        });
        this.loadFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int result = ZooInspectorNodeViewersDialog.this.fileChooser.showOpenDialog(ZooInspectorNodeViewersDialog.this);
                if (result == 0) {
                    try {
                        List<String> nodeViewersClassNames = manager.loadNodeViewersFile(ZooInspectorNodeViewersDialog.this.fileChooser.getSelectedFile());
                        ArrayList<ZooInspectorNodeViewer> nodeViewers = new ArrayList<ZooInspectorNodeViewer>();
                        for (String nodeViewersClassName : nodeViewersClassNames) {
                            ZooInspectorNodeViewer viewer = (ZooInspectorNodeViewer)Class.forName(nodeViewersClassName).newInstance();
                            nodeViewers.add(viewer);
                        }
                        DefaultListModel<ZooInspectorNodeViewer> model = new DefaultListModel<ZooInspectorNodeViewer>();
                        for (ZooInspectorNodeViewer viewer : nodeViewers) {
                            model.addElement(viewer);
                        }
                        ZooInspectorNodeViewersDialog.this.viewersList.setModel(model);
                        panel.revalidate();
                        panel.repaint();
                    }
                    catch (Exception ex) {
                        LoggerFactory.getLogger().error((Object)"Error loading node veiwer configuration from file.", (Throwable)ex);
                        JOptionPane.showMessageDialog(ZooInspectorNodeViewersDialog.this, "Error loading node veiwer configuration from file: " + ex.getMessage(), "Error", 0);
                    }
                }
            }
        });
        this.setDefaultsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int answer = JOptionPane.showConfirmDialog(ZooInspectorNodeViewersDialog.this, "Are you sure you want to save this configuration as the default?", "Confirm Set Defaults", 0, 2);
                if (answer == 0) {
                    Object[] modelContents;
                    DefaultListModel listModel = (DefaultListModel)ZooInspectorNodeViewersDialog.this.viewersList.getModel();
                    ArrayList<String> nodeViewersClassNames = new ArrayList<String>();
                    for (Object o : modelContents = listModel.toArray()) {
                        nodeViewersClassNames.add(((ZooInspectorNodeViewer)o).getClass().getCanonicalName());
                    }
                    try {
                        manager.setDefaultNodeViewerConfiguration(nodeViewersClassNames);
                    }
                    catch (IOException ex) {
                        LoggerFactory.getLogger().error((Object)"Error setting default node veiwer configuration.", (Throwable)ex);
                        JOptionPane.showMessageDialog(ZooInspectorNodeViewersDialog.this, "Error setting default node veiwer configuration: " + ex.getMessage(), "Error", 0);
                    }
                }
            }
        });
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout(1, 10, 10));
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZooInspectorNodeViewersDialog.this.dispose();
                DefaultListModel listModel = (DefaultListModel)ZooInspectorNodeViewersDialog.this.viewersList.getModel();
                newViewers.clear();
                Object[] modelContents = listModel.toArray();
                for (Object o : modelContents) {
                    newViewers.add((ZooInspectorNodeViewer)o);
                }
                currentViewers.clear();
                currentViewers.addAll(newViewers);
                for (NodeViewersChangeListener listener : listeners) {
                    listener.nodeViewersChanged(currentViewers);
                }
            }
        });
        buttonsPanel.add(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZooInspectorNodeViewersDialog.this.dispose();
            }
        });
        buttonsPanel.add(cancelButton);
        this.add((Component)panel, "Center");
        this.add((Component)buttonsPanel, "South");
        this.pack();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int index = this.viewersList.getSelectedIndex();
        if (index == -1) {
            this.removeButton.setEnabled(false);
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
            if (index == 0) {
                this.upButton.setEnabled(false);
            } else {
                this.upButton.setEnabled(true);
            }
            if (index == ((DefaultListModel)this.viewersList.getModel()).getSize()) {
                this.downButton.setEnabled(false);
            } else {
                this.downButton.setEnabled(true);
            }
        }
    }
}

