/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.inspector.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingWorker;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.inspector.gui.NodeViewersChangeListener;
import org.apache.zookeeper.inspector.gui.ZooInspectorAboutDialog;
import org.apache.zookeeper.inspector.gui.ZooInspectorConnectionPropertiesDialog;
import org.apache.zookeeper.inspector.gui.ZooInspectorIconResources;
import org.apache.zookeeper.inspector.gui.ZooInspectorNodeViewersDialog;
import org.apache.zookeeper.inspector.gui.ZooInspectorNodeViewersPanel;
import org.apache.zookeeper.inspector.gui.ZooInspectorTreeViewer;
import org.apache.zookeeper.inspector.gui.nodeviewer.ZooInspectorNodeViewer;
import org.apache.zookeeper.inspector.logger.LoggerFactory;
import org.apache.zookeeper.inspector.manager.ZooInspectorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZooInspectorPanel
extends JPanel
implements NodeViewersChangeListener {
    private final JButton refreshButton;
    private final JButton disconnectButton;
    private final JButton connectButton;
    private final ZooInspectorNodeViewersPanel nodeViewersPanel;
    private final ZooInspectorTreeViewer treeViewer;
    private final ZooInspectorManager zooInspectorManager;
    private final JButton addNodeButton;
    private final JButton deleteNodeButton;
    private final JButton nodeViewersButton;
    private final JButton aboutButton;
    private final List<NodeViewersChangeListener> listeners = new ArrayList<NodeViewersChangeListener>();

    public boolean checkZookeeperStates(String info) {
        if (this.zooInspectorManager == null || this.zooInspectorManager.getZookeeperStates() != ZooKeeper.States.CONNECTED) {
            this.refreshButton.setEnabled(false);
            this.addNodeButton.setEnabled(false);
            this.deleteNodeButton.setEnabled(false);
            JOptionPane.showMessageDialog(this, info, "Error", 0);
            return false;
        }
        return true;
    }

    public ZooInspectorPanel(final ZooInspectorManager zooInspectorManager) {
        this.listeners.add(this);
        this.zooInspectorManager = zooInspectorManager;
        final ArrayList<ZooInspectorNodeViewer> nodeViewers = new ArrayList<ZooInspectorNodeViewer>();
        try {
            List<String> defaultNodeViewersClassNames = this.zooInspectorManager.getDefaultNodeViewerConfiguration();
            for (String className : defaultNodeViewersClassNames) {
                nodeViewers.add((ZooInspectorNodeViewer)Class.forName(className).newInstance());
            }
        }
        catch (Exception ex) {
            LoggerFactory.getLogger().error((Object)"Error loading default node viewers.", (Throwable)ex);
            JOptionPane.showMessageDialog(this, "Error loading default node viewers: " + ex.getMessage(), "Error", 0);
        }
        this.nodeViewersPanel = new ZooInspectorNodeViewersPanel(zooInspectorManager, nodeViewers);
        this.treeViewer = new ZooInspectorTreeViewer(this, zooInspectorManager, this.nodeViewersPanel);
        this.setLayout(new BorderLayout());
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        this.connectButton = new JButton(ZooInspectorIconResources.getConnectIcon());
        this.disconnectButton = new JButton(ZooInspectorIconResources.getDisconnectIcon());
        this.refreshButton = new JButton(ZooInspectorIconResources.getRefreshIcon());
        this.addNodeButton = new JButton(ZooInspectorIconResources.getAddNodeIcon());
        this.deleteNodeButton = new JButton(ZooInspectorIconResources.getDeleteNodeIcon());
        this.nodeViewersButton = new JButton(ZooInspectorIconResources.getChangeNodeViewersIcon());
        this.aboutButton = new JButton(ZooInspectorIconResources.getInformationIcon());
        toolbar.add(this.connectButton);
        toolbar.add(this.disconnectButton);
        toolbar.add(this.refreshButton);
        toolbar.add(this.addNodeButton);
        toolbar.add(this.deleteNodeButton);
        toolbar.add(this.nodeViewersButton);
        toolbar.add(this.aboutButton);
        this.aboutButton.setEnabled(true);
        this.connectButton.setEnabled(true);
        this.disconnectButton.setEnabled(false);
        this.refreshButton.setEnabled(false);
        this.addNodeButton.setEnabled(false);
        this.deleteNodeButton.setEnabled(false);
        this.nodeViewersButton.setEnabled(true);
        this.nodeViewersButton.setToolTipText("Change Node Viewers");
        this.aboutButton.setToolTipText("About ZooInspector");
        this.connectButton.setToolTipText("Connect");
        this.disconnectButton.setToolTipText("Disconnect");
        this.refreshButton.setToolTipText("Refresh");
        this.addNodeButton.setToolTipText("Add Node");
        this.deleteNodeButton.setToolTipText("Delete Node");
        this.connectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZooInspectorConnectionPropertiesDialog zicpd = new ZooInspectorConnectionPropertiesDialog(zooInspectorManager.getLastConnectionProps(), zooInspectorManager.getConnectionPropertiesTemplate(), ZooInspectorPanel.this);
                zicpd.setVisible(true);
            }
        });
        this.disconnectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZooInspectorPanel.this.disconnect();
            }
        });
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZooInspectorPanel.this.treeViewer.refreshView();
            }
        });
        this.addNodeButton.addActionListener(new ActionListener(){
            String nodeName;

            public void actionPerformed(ActionEvent e) {
                final List<String> selectedNodes = ZooInspectorPanel.this.treeViewer.getSelectedNodes();
                if (selectedNodes.size() == 1) {
                    this.nodeName = JOptionPane.showInputDialog(ZooInspectorPanel.this, "Please Enter a name for the new node", "Create Node", 1);
                    if (this.nodeName != null && this.nodeName.length() > 0) {
                        SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

                            @Override
                            protected Boolean doInBackground() throws Exception {
                                return ZooInspectorPanel.this.zooInspectorManager.createNode((String)selectedNodes.get(0), nodeName);
                            }

                            @Override
                            protected void done() {
                                ZooInspectorPanel.this.treeViewer.refreshViewAfterAdd((String)selectedNodes.get(0), nodeName);
                            }
                        };
                        worker.execute();
                    }
                } else {
                    JOptionPane.showMessageDialog(ZooInspectorPanel.this, "Please select 1 parent node for the new node.");
                }
            }
        });
        this.deleteNodeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                final List<String> selectedNodes = ZooInspectorPanel.this.treeViewer.getSelectedNodes();
                if (selectedNodes.size() == 0) {
                    JOptionPane.showMessageDialog(ZooInspectorPanel.this, "Please select at least 1 node to be deleted");
                } else {
                    int answer = JOptionPane.showConfirmDialog(ZooInspectorPanel.this, "Are you sure you want to delete the selected nodes?(This action cannot be reverted)", "Confirm Delete", 0, 2);
                    if (answer == 0) {
                        SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

                            @Override
                            protected Boolean doInBackground() throws Exception {
                                for (String nodePath : selectedNodes) {
                                    boolean result = ZooInspectorPanel.this.zooInspectorManager.deleteNode(nodePath);
                                    if (result) continue;
                                    return false;
                                }
                                return true;
                            }

                            @Override
                            protected void done() {
                                ZooInspectorPanel.this.treeViewer.refreshViewAfterDelete(selectedNodes);
                            }
                        };
                        worker.execute();
                    }
                }
            }
        });
        this.nodeViewersButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZooInspectorNodeViewersDialog nvd = new ZooInspectorNodeViewersDialog(JOptionPane.getRootFrame(), nodeViewers, ZooInspectorPanel.this.listeners, zooInspectorManager);
                nvd.setVisible(true);
            }
        });
        this.aboutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ZooInspectorAboutDialog zicpd = new ZooInspectorAboutDialog(JOptionPane.getRootFrame());
                zicpd.setVisible(true);
            }
        });
        JScrollPane treeScroller = new JScrollPane(this.treeViewer);
        JSplitPane splitPane = new JSplitPane(1, treeScroller, this.nodeViewersPanel);
        splitPane.setResizeWeight(0.25);
        this.add((Component)splitPane, "Center");
        this.add((Component)toolbar, "North");
    }

    public void connect(final Properties connectionProps) {
        SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                ZooInspectorPanel.this.zooInspectorManager.setLastConnectionProps(connectionProps);
                return ZooInspectorPanel.this.zooInspectorManager.connect(connectionProps);
            }

            @Override
            protected void done() {
                try {
                    if (((Boolean)this.get()).booleanValue()) {
                        ZooInspectorPanel.this.treeViewer.refreshView();
                        ZooInspectorPanel.this.connectButton.setEnabled(false);
                        ZooInspectorPanel.this.disconnectButton.setEnabled(true);
                        ZooInspectorPanel.this.refreshButton.setEnabled(true);
                        ZooInspectorPanel.this.addNodeButton.setEnabled(true);
                        ZooInspectorPanel.this.deleteNodeButton.setEnabled(true);
                        ZooInspectorPanel.this.zooInspectorManager.updateDefaultConnectionFile(connectionProps);
                    } else {
                        JOptionPane.showMessageDialog(ZooInspectorPanel.this, "Unable to connect to zookeeper", "Error", 0);
                    }
                }
                catch (InterruptedException e) {
                    LoggerFactory.getLogger().error((Object)"Error occurred while connecting to ZooKeeper server", (Throwable)e);
                }
                catch (ExecutionException e) {
                    LoggerFactory.getLogger().error((Object)"Error occurred while connecting to ZooKeeper server", (Throwable)e);
                }
                catch (IOException e) {
                    LoggerFactory.getLogger().error((Object)"Error occurred while update default connections", (Throwable)e);
                }
            }
        };
        worker.execute();
    }

    public void disconnect() {
        this.disconnect(false);
    }

    public void disconnect(boolean wait) {
        SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                return ZooInspectorPanel.this.zooInspectorManager.disconnect();
            }

            @Override
            protected void done() {
                try {
                    if (((Boolean)this.get()).booleanValue()) {
                        ZooInspectorPanel.this.treeViewer.clearView();
                        ZooInspectorPanel.this.connectButton.setEnabled(true);
                        ZooInspectorPanel.this.disconnectButton.setEnabled(false);
                        ZooInspectorPanel.this.refreshButton.setEnabled(false);
                        ZooInspectorPanel.this.addNodeButton.setEnabled(false);
                        ZooInspectorPanel.this.deleteNodeButton.setEnabled(false);
                    }
                }
                catch (InterruptedException e) {
                    LoggerFactory.getLogger().error((Object)"Error occurred while disconnecting from ZooKeeper server", (Throwable)e);
                }
                catch (ExecutionException e) {
                    LoggerFactory.getLogger().error((Object)"Error occurred while disconnecting from ZooKeeper server", (Throwable)e);
                }
            }
        };
        worker.execute();
        if (wait) {
            while (!worker.isDone()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    LoggerFactory.getLogger().error((Object)"Error occurred while disconnecting from ZooKeeper server", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void nodeViewersChanged(List<ZooInspectorNodeViewer> newViewers) {
        this.nodeViewersPanel.setNodeViewers(newViewers);
    }

    public void setdefaultConnectionProps(Properties connectionProps) throws IOException {
        this.zooInspectorManager.saveDefaultConnectionFile(connectionProps);
    }
}

