/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.inspector.gui.nodeviewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import org.apache.zookeeper.inspector.gui.nodeviewer.ZooInspectorNodeViewer;
import org.apache.zookeeper.inspector.logger.LoggerFactory;
import org.apache.zookeeper.inspector.manager.ZooInspectorNodeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeViewerACL
extends ZooInspectorNodeViewer {
    private ZooInspectorNodeManager zooInspectorManager;
    private final JPanel aclDataPanel;
    private String selectedNode;

    public NodeViewerACL() {
        this.setLayout(new BorderLayout());
        this.aclDataPanel = new JPanel();
        this.aclDataPanel.setBackground(Color.WHITE);
        JScrollPane scroller = new JScrollPane(this.aclDataPanel);
        this.add((Component)scroller, "Center");
    }

    @Override
    public String getTitle() {
        return "Node ACLs";
    }

    @Override
    public void nodeSelectionChanged(List<String> selectedNodes) {
        if (selectedNodes.size() > 0) {
            this.selectedNode = selectedNodes.get(0);
            SwingWorker<List<Map<String, String>>, Void> worker = new SwingWorker<List<Map<String, String>>, Void>(){

                @Override
                protected List<Map<String, String>> doInBackground() throws Exception {
                    return NodeViewerACL.this.zooInspectorManager.getACLs(NodeViewerACL.this.selectedNode);
                }

                @Override
                protected void done() {
                    ArrayList acls = null;
                    try {
                        acls = (ArrayList)this.get();
                    }
                    catch (InterruptedException e) {
                        acls = new ArrayList();
                        LoggerFactory.getLogger().error((Object)("Error retrieving ACL Information for node: " + NodeViewerACL.this.selectedNode), (Throwable)e);
                    }
                    catch (ExecutionException e) {
                        acls = new ArrayList();
                        LoggerFactory.getLogger().error((Object)("Error retrieving ACL Information for node: " + NodeViewerACL.this.selectedNode), (Throwable)e);
                    }
                    NodeViewerACL.this.aclDataPanel.removeAll();
                    NodeViewerACL.this.aclDataPanel.setLayout(new GridBagLayout());
                    int j = 0;
                    for (Map data : acls) {
                        int rowPos = 2 * j + 1;
                        JPanel aclPanel = new JPanel();
                        aclPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
                        aclPanel.setBackground(Color.WHITE);
                        aclPanel.setLayout(new GridBagLayout());
                        int i = 0;
                        for (Map.Entry entry : data.entrySet()) {
                            int rowPosACL = 2 * i + 1;
                            JLabel label = new JLabel((String)entry.getKey());
                            JTextField text = new JTextField((String)entry.getValue());
                            text.setEditable(false);
                            GridBagConstraints c1 = new GridBagConstraints();
                            c1.gridx = 1;
                            c1.gridy = rowPosACL;
                            c1.gridwidth = 1;
                            c1.gridheight = 1;
                            c1.weightx = 0.0;
                            c1.weighty = 0.0;
                            c1.anchor = 18;
                            c1.fill = 1;
                            c1.insets = new Insets(5, 5, 5, 5);
                            c1.ipadx = 0;
                            c1.ipady = 0;
                            aclPanel.add((Component)label, c1);
                            GridBagConstraints c2 = new GridBagConstraints();
                            c2.gridx = 3;
                            c2.gridy = rowPosACL;
                            c2.gridwidth = 1;
                            c2.gridheight = 1;
                            c2.weightx = 0.0;
                            c2.weighty = 0.0;
                            c2.anchor = 18;
                            c2.fill = 1;
                            c2.insets = new Insets(5, 5, 5, 5);
                            c2.ipadx = 0;
                            c2.ipady = 0;
                            aclPanel.add((Component)text, c2);
                            ++i;
                        }
                        GridBagConstraints c = new GridBagConstraints();
                        c.gridx = 1;
                        c.gridy = rowPos;
                        c.gridwidth = 1;
                        c.gridheight = 1;
                        c.weightx = 1.0;
                        c.weighty = 1.0;
                        c.anchor = 18;
                        c.fill = 0;
                        c.insets = new Insets(5, 5, 5, 5);
                        c.ipadx = 0;
                        c.ipady = 0;
                        NodeViewerACL.this.aclDataPanel.add((Component)aclPanel, c);
                    }
                    NodeViewerACL.this.aclDataPanel.revalidate();
                    NodeViewerACL.this.aclDataPanel.repaint();
                }
            };
            worker.execute();
        }
    }

    @Override
    public void setZooInspectorManager(ZooInspectorNodeManager zooInspectorManager) {
        this.zooInspectorManager = zooInspectorManager;
    }
}

