/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.inspector.gui.nodeviewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.SwingWorker;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.DefaultStyledDocument;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.inspector.gui.NodeDataViewerFindDialog;
import org.apache.zookeeper.inspector.gui.ZooInspectorIconResources;
import org.apache.zookeeper.inspector.gui.nodeviewer.ZooInspectorNodeViewer;
import org.apache.zookeeper.inspector.logger.LoggerFactory;
import org.apache.zookeeper.inspector.manager.ZooInspectorNodeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeViewerData
extends ZooInspectorNodeViewer {
    private ZooInspectorNodeManager zooInspectorManager;
    private final JTextPane dataArea;
    private final DefaultHighlighter highlighter;
    private final JScrollPane scroller;
    private final JToolBar toolbar;
    private String selectedNode;

    public void highlight(String selText) {
        this.highlighter.removeAllHighlights();
        if (selText == null || selText.isEmpty()) {
            return;
        }
        selText = selText.toLowerCase();
        DefaultHighlighter.DefaultHighlightPainter hPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.YELLOW);
        String contText = "";
        DefaultStyledDocument document = (DefaultStyledDocument)this.dataArea.getDocument();
        try {
            contText = document.getText(0, document.getLength());
            contText = contText.toLowerCase();
        }
        catch (BadLocationException ex) {
            LoggerFactory.getLogger().error(null, (Throwable)ex);
        }
        int index = -1;
        int firstPos = 0;
        while ((index = contText.indexOf(selText, index)) > -1) {
            if (firstPos == 0) {
                firstPos = index;
            }
            try {
                this.highlighter.addHighlight(index, selText.length() + index, hPainter);
                index += selText.length();
            }
            catch (BadLocationException ex) {
                LoggerFactory.getLogger().error(null, (Throwable)ex);
            }
        }
        try {
            Rectangle viewRect = this.dataArea.modelToView(firstPos);
            this.dataArea.scrollRectToVisible(viewRect);
            this.dataArea.setCaretPosition(firstPos);
        }
        catch (BadLocationException e) {
            // empty catch block
        }
    }

    public NodeViewerData() {
        this.setLayout(new BorderLayout());
        this.dataArea = new JTextPane();
        this.highlighter = (DefaultHighlighter)this.dataArea.getHighlighter();
        this.dataArea.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 70 && (e.getModifiers() & 6) != 0) {
                    NodeDataViewerFindDialog dialog = new NodeDataViewerFindDialog(NodeViewerData.this);
                    dialog.setVisible(true);
                } else if (e.getKeyCode() == 27) {
                    NodeViewerData.this.highlighter.removeAllHighlights();
                }
            }
        });
        this.dataArea.setEditable(false);
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.scroller = new JScrollPane(this.dataArea);
        this.scroller.setHorizontalScrollBarPolicy(31);
        this.add((Component)this.scroller, "Center");
        this.add((Component)this.toolbar, "North");
        final JButton saveButton = new JButton(ZooInspectorIconResources.getSaveIcon());
        saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (NodeViewerData.this.selectedNode != null && JOptionPane.showConfirmDialog(NodeViewerData.this, "Are you sure you want to save this node? (this action cannot be reverted)", "Confirm Save", 0, 2) == 0) {
                    NodeViewerData.this.zooInspectorManager.setData(NodeViewerData.this.selectedNode, NodeViewerData.this.dataArea.getText());
                }
            }
        });
        saveButton.setEnabled(false);
        this.toolbar.add(saveButton);
        JButton editButton = new JButton(ZooInspectorIconResources.getEditIcon());
        editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (NodeViewerData.this.zooInspectorManager != null && NodeViewerData.this.zooInspectorManager.getZookeeperStates() == ZooKeeper.States.CONNECTED) {
                    saveButton.setEnabled(!saveButton.isEnabled());
                    NodeViewerData.this.dataArea.setEditable(saveButton.isEnabled());
                }
            }
        });
        this.toolbar.add(editButton);
        JButton searchButton = new JButton(ZooInspectorIconResources.getSearchIcon());
        String osName = System.getProperty("os.name").toLowerCase();
        String tipText = "Find (^F)";
        if (osName != null && osName.indexOf("mac") > -1) {
            tipText = "Find (^/\u00e2\u0152\u02dcF)";
        }
        searchButton.setToolTipText(tipText);
        searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NodeDataViewerFindDialog dialog = new NodeDataViewerFindDialog(NodeViewerData.this);
                dialog.setVisible(true);
            }
        });
        this.toolbar.add(searchButton);
    }

    @Override
    public String getTitle() {
        return "Node Data";
    }

    @Override
    public void nodeSelectionChanged(List<String> selectedNodes) {
        if (selectedNodes.size() > 0) {
            this.selectedNode = selectedNodes.get(0);
            SwingWorker<String, Void> worker = new SwingWorker<String, Void>(){

                @Override
                protected String doInBackground() throws Exception {
                    return NodeViewerData.this.zooInspectorManager.getData(NodeViewerData.this.selectedNode);
                }

                @Override
                protected void done() {
                    String data = "";
                    try {
                        data = (String)this.get();
                    }
                    catch (InterruptedException e) {
                        LoggerFactory.getLogger().error((Object)("Error retrieving data for node: " + NodeViewerData.this.selectedNode), (Throwable)e);
                    }
                    catch (ExecutionException e) {
                        LoggerFactory.getLogger().error((Object)("Error retrieving data for node: " + NodeViewerData.this.selectedNode), (Throwable)e);
                    }
                    NodeViewerData.this.dataArea.setText(data);
                    NodeViewerData.this.dataArea.setCaretPosition(0);
                }
            };
            worker.execute();
        }
    }

    @Override
    public void setZooInspectorManager(ZooInspectorNodeManager zooInspectorManager) {
        this.zooInspectorManager = zooInspectorManager;
    }
}

