/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.inspector.gui.nodeviewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import org.apache.zookeeper.inspector.gui.nodeviewer.ZooInspectorNodeViewer;
import org.apache.zookeeper.inspector.logger.LoggerFactory;
import org.apache.zookeeper.inspector.manager.ZooInspectorNodeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeViewerMetaData
extends ZooInspectorNodeViewer {
    private ZooInspectorNodeManager zooInspectorManager;
    private final JPanel metaDataPanel;

    public NodeViewerMetaData() {
        this.setLayout(new BorderLayout());
        this.metaDataPanel = new JPanel();
        this.metaDataPanel.setBackground(Color.WHITE);
        JScrollPane scroller = new JScrollPane(this.metaDataPanel);
        this.add((Component)scroller, "Center");
    }

    @Override
    public String getTitle() {
        return "Node Metadata";
    }

    @Override
    public void nodeSelectionChanged(List<String> selectedNodes) {
        this.metaDataPanel.removeAll();
        this.metaDataPanel.setLayout(new GridBagLayout());
        if (selectedNodes.size() > 0) {
            final String selectedNode = selectedNodes.get(0);
            SwingWorker<Map<String, String>, Void> worker = new SwingWorker<Map<String, String>, Void>(){

                @Override
                protected Map<String, String> doInBackground() throws Exception {
                    return NodeViewerMetaData.this.zooInspectorManager.getNodeMeta(selectedNode);
                }

                @Override
                protected void done() {
                    HashMap data = null;
                    try {
                        data = (HashMap)this.get();
                    }
                    catch (InterruptedException e) {
                        data = new HashMap();
                        LoggerFactory.getLogger().error((Object)("Error retrieving meta data for node: " + selectedNode), (Throwable)e);
                    }
                    catch (ExecutionException e) {
                        data = new HashMap();
                        LoggerFactory.getLogger().error((Object)("Error retrieving meta data for node: " + selectedNode), (Throwable)e);
                    }
                    JPanel infoPanel = new JPanel();
                    infoPanel.setBackground(Color.WHITE);
                    infoPanel.setLayout(new GridBagLayout());
                    int i = 0;
                    int rowPos = 0;
                    for (Map.Entry entry : data.entrySet()) {
                        rowPos = 2 * i + 1;
                        JLabel label = new JLabel((String)entry.getKey());
                        JTextField text = new JTextField((String)entry.getValue());
                        text.setEditable(false);
                        GridBagConstraints c1 = new GridBagConstraints();
                        c1.gridx = 0;
                        c1.gridy = rowPos;
                        c1.gridwidth = 1;
                        c1.gridheight = 1;
                        c1.weightx = 0.0;
                        c1.weighty = 0.0;
                        c1.anchor = 17;
                        c1.fill = 2;
                        c1.insets = new Insets(5, 5, 5, 5);
                        c1.ipadx = 0;
                        c1.ipady = 0;
                        infoPanel.add((Component)label, c1);
                        GridBagConstraints c2 = new GridBagConstraints();
                        c2.gridx = 2;
                        c2.gridy = rowPos;
                        c2.gridwidth = 1;
                        c2.gridheight = 1;
                        c2.weightx = 0.0;
                        c2.weighty = 0.0;
                        c2.anchor = 17;
                        c2.fill = 2;
                        c2.insets = new Insets(5, 5, 5, 5);
                        c2.ipadx = 0;
                        c2.ipady = 0;
                        infoPanel.add((Component)text, c2);
                        ++i;
                    }
                    GridBagConstraints c = new GridBagConstraints();
                    c.gridx = 1;
                    c.gridy = rowPos;
                    c.gridwidth = 1;
                    c.gridheight = 1;
                    c.weightx = 1.0;
                    c.weighty = 1.0;
                    c.anchor = 18;
                    c.fill = 0;
                    c.insets = new Insets(5, 5, 5, 5);
                    c.ipadx = 0;
                    c.ipady = 0;
                    NodeViewerMetaData.this.metaDataPanel.add((Component)infoPanel, c);
                    NodeViewerMetaData.this.metaDataPanel.revalidate();
                    NodeViewerMetaData.this.metaDataPanel.repaint();
                }
            };
            worker.execute();
        }
    }

    @Override
    public void setZooInspectorManager(ZooInspectorNodeManager zooInspectorManager) {
        this.zooInspectorManager = zooInspectorManager;
    }
}

