/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.inspector.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.inspector.logger.LoggerFactory;
import org.apache.zookeeper.inspector.manager.ZooInspectorManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZooInspectorManagerCache {
    final Map<String, Item> cache;
    ZooInspectorManagerImpl manager;

    public ZooInspectorManagerCache(ZooInspectorManagerImpl manager) {
        this.manager = manager;
        this.cache = new ConcurrentHashMap<String, Item>();
    }

    public void refresh(List<String> paths, int depth) throws KeeperException {
        if (depth < 0) {
            return;
        }
        if (paths == null || paths.size() == 0) {
            return;
        }
        Map<String, Item> childItems = this.manager.getChildren(paths);
        ArrayList<String> childPaths = new ArrayList<String>();
        for (int i = 0; i < paths.size(); ++i) {
            String path = paths.get(i);
            Item item = childItems.get(path);
            if (item == null || item.childs == null) {
                this.cache.remove(path);
                continue;
            }
            this.cache.put(path, item);
            if (depth <= 0) continue;
            for (String child : item.childs) {
                String childPath = path.equals("/") ? path + child : path + "/" + child;
                childPaths.add(childPath);
            }
        }
        if (childPaths.size() > 0) {
            this.refresh(childPaths, depth - 1);
        }
    }

    public String getNodeChild(String nodePath, int childIndex) {
        if (!this.cache.containsKey(nodePath)) {
            LoggerFactory.getLogger().error((Object)("CACHE MISS! getNodeChild(). path: " + nodePath));
            return null;
        }
        List<String> childs = this.getChildren(nodePath);
        if (childs == null || childIndex >= childs.size()) {
            return null;
        }
        return childs.get(childIndex);
    }

    public int getNumChildren(String nodePath) {
        if (!this.cache.containsKey(nodePath)) {
            LoggerFactory.getLogger().error((Object)("CACHE MISS! getNumChildren(). path: " + nodePath));
            return 0;
        }
        Item item = this.cache.get(nodePath);
        if (item == null || item.childs == null) {
            return 0;
        }
        return item.childs.size();
    }

    public List<String> getChildren(String nodePath) {
        if (!this.cache.containsKey(nodePath)) {
            LoggerFactory.getLogger().error((Object)("CACHE MISS! getChildren(). path: " + nodePath));
            return Collections.emptyList();
        }
        List<String> childs = this.cache.get((Object)nodePath).childs;
        Collections.sort(childs);
        return childs;
    }

    public void removePrefix(String prefix) {
        Iterator<Map.Entry<String, Item>> iter = this.cache.entrySet().iterator();
        while (iter.hasNext()) {
            String path = iter.next().getKey();
            if (!path.startsWith(prefix)) continue;
            iter.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Item {
        List<String> childs;
        Stat zkStat;

        public Item(List<String> childs, Stat zkStat) {
            this.childs = childs;
            this.zkStat = zkStat;
        }
    }
}

