/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.inspector.manager;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.inspector.encryption.BasicDataEncryptionManager;
import org.apache.zookeeper.inspector.encryption.DataEncryptionManager;
import org.apache.zookeeper.inspector.logger.LoggerFactory;
import org.apache.zookeeper.inspector.manager.NodeListener;
import org.apache.zookeeper.inspector.manager.Pair;
import org.apache.zookeeper.inspector.manager.ZooInspectorManager;
import org.apache.zookeeper.inspector.manager.ZooInspectorManagerCache;
import org.apache.zookeeper.retry.ZooKeeperRetry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZooInspectorManagerImpl
implements ZooInspectorManager {
    private static final String A_VERSION = "ACL Version";
    private static final String C_TIME = "Creation Time";
    private static final String C_VERSION = "Children Version";
    private static final String CZXID = "Creation ID";
    private static final String DATA_LENGTH = "Data Length";
    private static final String EPHEMERAL_OWNER = "Ephemeral Owner";
    private static final String M_TIME = "Last Modified Time";
    private static final String MZXID = "Modified ID";
    private static final String NUM_CHILDREN = "Number of Children";
    private static final String PZXID = "Node ID";
    private static final String VERSION = "Data Version";
    private static final String ACL_PERMS = "Permissions";
    private static final String ACL_SCHEME = "Scheme";
    private static final String ACL_ID = "Id";
    private static final String SESSION_STATE = "Session State";
    private static final String SESSION_ID = "Session ID";
    public static final String CONNECT_STRING = "hosts";
    public static final String SESSION_TIMEOUT = "timeout";
    public static final String DATA_ENCRYPTION_MANAGER = "encryptionManager";
    private static final String homeDir = System.getProperty("user.home");
    private static final File defaultNodeViewersFile = new File(homeDir + "/.zooinspector/defaultNodeVeiwers.cfg");
    private static final File defaultConnectionFile = new File(homeDir + "/.zooinspector/defaultConnectionSettings.cfg");
    private DataEncryptionManager encryptionManager;
    private String connectString;
    private int sessionTimeout;
    private ZooKeeper zooKeeper;
    final Map<String, NodeWatcher> watchers = new HashMap<String, NodeWatcher>();
    protected boolean connected = true;
    private Properties lastConnectionProps;
    private String defaultEncryptionManager;
    private String defaultTimeout;
    private String defaultHosts;
    private List<String> defaultHostsList;
    private final int defaultHostsListSize = 10;
    ZooInspectorManagerCache cache;
    ExecutorService service = Executors.newFixedThreadPool(40);

    public ZooInspectorManagerImpl() throws IOException {
        this.loadDefaultConnectionFile();
    }

    @Override
    public boolean connect(Properties connectionProps) {
        this.connected = false;
        try {
            if (this.zooKeeper == null) {
                String connectString = connectionProps.getProperty(CONNECT_STRING);
                String sessionTimeout = connectionProps.getProperty(SESSION_TIMEOUT);
                String encryptionManager = connectionProps.getProperty(DATA_ENCRYPTION_MANAGER);
                if (connectString == null || sessionTimeout == null) {
                    throw new IllegalArgumentException("Both connect string and session timeout are required.");
                }
                if (encryptionManager == null) {
                    this.encryptionManager = new BasicDataEncryptionManager();
                } else {
                    Class<?> clazz = Class.forName(encryptionManager);
                    if (Arrays.asList(clazz.getInterfaces()).contains(DataEncryptionManager.class)) {
                        this.encryptionManager = (DataEncryptionManager)Class.forName(encryptionManager).newInstance();
                    } else {
                        throw new IllegalArgumentException("Data encryption manager must implement DataEncryptionManager interface");
                    }
                }
                this.connectString = connectString;
                this.sessionTimeout = Integer.valueOf(sessionTimeout);
                this.zooKeeper = new ZooKeeperRetry(connectString, Integer.valueOf(sessionTimeout), new Watcher(){

                    public void process(WatchedEvent event) {
                        if (event.getState() == Watcher.Event.KeeperState.Expired) {
                            ZooInspectorManagerImpl.this.connected = false;
                        }
                    }
                });
                ((ZooKeeperRetry)this.zooKeeper).setRetryLimit(10);
                this.connected = ((ZooKeeperRetry)this.zooKeeper).testConnection();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.connected) {
            this.cache = new ZooInspectorManagerCache(this);
            try {
                this.cache.refresh(Arrays.asList("/"), 1);
            }
            catch (KeeperException e) {
                this.disconnect();
                e.printStackTrace();
            }
        } else {
            this.disconnect();
        }
        return this.connected;
    }

    @Override
    public boolean disconnect() {
        try {
            if (this.zooKeeper != null) {
                this.zooKeeper.close();
                this.zooKeeper = null;
                this.connected = false;
                this.removeWatchers(this.watchers.keySet());
                return true;
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger().error((Object)"Error occurred while disconnecting from ZooKeeper server", (Throwable)e);
        }
        return false;
    }

    @Override
    public List<String> getChildren(String nodePath) {
        if (this.connected) {
            return this.cache.getChildren(nodePath);
        }
        return null;
    }

    ZooInspectorManagerCache.Item getChildrenAndStat(String nodePath) throws KeeperException {
        if (this.zooKeeper.getState() != ZooKeeper.States.CONNECTED) {
            throw KeeperException.create((KeeperException.Code)KeeperException.Code.CONNECTIONLOSS, (String)nodePath);
        }
        try {
            Stat stat = new Stat();
            List childs = this.zooKeeper.getChildren(nodePath, false, stat);
            return new ZooInspectorManagerCache.Item(childs, stat);
        }
        catch (KeeperException.NoNodeException e) {
        }
        catch (KeeperException e) {
            throw e;
        }
        catch (Exception e) {
            LoggerFactory.getLogger().error((Object)("Error occurred retrieving children of node: " + nodePath), (Throwable)e);
        }
        return null;
    }

    Map<String, ZooInspectorManagerCache.Item> getChildren(List<String> paths) {
        int n = paths.size();
        if (n > 0) {
            final ConcurrentHashMap<String, ZooInspectorManagerCache.Item> ret = new ConcurrentHashMap<String, ZooInspectorManagerCache.Item>();
            final CountDownLatch cntDown = new CountDownLatch(n);
            for (final String path : paths) {
                this.service.submit(new Callable<String>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public String call() throws Exception {
                        Stat stat = null;
                        List childs = null;
                        try {
                            stat = new Stat();
                            childs = ZooInspectorManagerImpl.this.zooKeeper.getChildren(path, false, stat);
                            ret.put(path, new ZooInspectorManagerCache.Item(childs, stat));
                        }
                        catch (Exception exception) {
                            ret.put(path, new ZooInspectorManagerCache.Item(childs, stat));
                            cntDown.countDown();
                        }
                        catch (Throwable throwable) {
                            ret.put(path, new ZooInspectorManagerCache.Item(childs, stat));
                            cntDown.countDown();
                            throw throwable;
                        }
                        cntDown.countDown();
                        return null;
                    }
                });
            }
            try {
                cntDown.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return ret;
        }
        return Collections.emptyMap();
    }

    @Override
    public String getData(String nodePath) {
        if (this.connected) {
            try {
                Stat s;
                if (nodePath.length() == 0) {
                    nodePath = "/";
                }
                if ((s = this.zooKeeper.exists(nodePath, false)) != null) {
                    return this.encryptionManager.decryptData(this.zooKeeper.getData(nodePath, false, s));
                }
            }
            catch (Exception e) {
                LoggerFactory.getLogger().error((Object)("Error occurred getting data for node: " + nodePath), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public String getNodeChild(String nodePath, int childIndex) {
        long start = System.currentTimeMillis();
        if (this.connected) {
            String child = this.cache.getNodeChild(nodePath, childIndex);
            long end = System.currentTimeMillis();
            return child;
        }
        return null;
    }

    @Override
    public int getNodeIndex(String nodePath) {
        if (this.connected) {
            List<String> children;
            int index = nodePath.lastIndexOf("/");
            if (index == -1 || !nodePath.equals("/") && nodePath.charAt(nodePath.length() - 1) == '/') {
                throw new IllegalArgumentException("Invalid node path: " + nodePath);
            }
            String parentPath = nodePath.substring(0, index);
            String child = nodePath.substring(index + 1);
            if (parentPath != null && parentPath.length() > 0 && (children = this.getChildren(parentPath)) != null) {
                return children.indexOf(child);
            }
        }
        return -1;
    }

    @Override
    public List<Map<String, String>> getACLs(String nodePath) {
        ArrayList<Map<String, String>> returnACLs = new ArrayList<Map<String, String>>();
        if (this.connected) {
            try {
                Stat s;
                if (nodePath.length() == 0) {
                    nodePath = "/";
                }
                if ((s = this.zooKeeper.exists(nodePath, false)) != null) {
                    List acls = this.zooKeeper.getACL(nodePath, s);
                    for (ACL acl : acls) {
                        LinkedHashMap<String, String> aclMap = new LinkedHashMap<String, String>();
                        aclMap.put(ACL_SCHEME, acl.getId().getScheme());
                        aclMap.put(ACL_ID, acl.getId().getId());
                        StringBuilder sb = new StringBuilder();
                        int perms = acl.getPerms();
                        boolean addedPerm = false;
                        if ((perms & 1) == 1) {
                            sb.append("Read");
                            addedPerm = true;
                        }
                        if (addedPerm) {
                            sb.append(", ");
                        }
                        if ((perms & 2) == 2) {
                            sb.append("Write");
                            addedPerm = true;
                        }
                        if (addedPerm) {
                            sb.append(", ");
                        }
                        if ((perms & 4) == 4) {
                            sb.append("Create");
                            addedPerm = true;
                        }
                        if (addedPerm) {
                            sb.append(", ");
                        }
                        if ((perms & 8) == 8) {
                            sb.append("Delete");
                            addedPerm = true;
                        }
                        if (addedPerm) {
                            sb.append(", ");
                        }
                        if ((perms & 0x10) == 16) {
                            sb.append("Admin");
                            addedPerm = true;
                        }
                        aclMap.put(ACL_PERMS, sb.toString());
                        returnACLs.add(aclMap);
                    }
                }
            }
            catch (InterruptedException e) {
                LoggerFactory.getLogger().error((Object)("Error occurred retrieving ACLs of node: " + nodePath), (Throwable)e);
            }
            catch (KeeperException e) {
                LoggerFactory.getLogger().error((Object)("Error occurred retrieving ACLs of node: " + nodePath), (Throwable)e);
            }
        }
        return returnACLs;
    }

    @Override
    public Map<String, String> getNodeMeta(String nodePath) {
        LinkedHashMap<String, String> nodeMeta = new LinkedHashMap<String, String>();
        if (this.connected) {
            try {
                Stat s;
                if (nodePath.length() == 0) {
                    nodePath = "/";
                }
                if ((s = this.zooKeeper.exists(nodePath, false)) != null) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS z");
                    nodeMeta.put(A_VERSION, String.valueOf(s.getAversion()));
                    nodeMeta.put(C_TIME, format.format(new Date(s.getCtime())));
                    nodeMeta.put(C_VERSION, String.valueOf(s.getCversion()));
                    nodeMeta.put(CZXID, "0x" + Long.toHexString(s.getCzxid()));
                    nodeMeta.put(DATA_LENGTH, String.valueOf(s.getDataLength()));
                    nodeMeta.put(EPHEMERAL_OWNER, "0x" + Long.toHexString(s.getEphemeralOwner()));
                    nodeMeta.put(M_TIME, format.format(new Date(s.getMtime())));
                    nodeMeta.put(MZXID, "0x" + Long.toHexString(s.getMzxid()));
                    nodeMeta.put(NUM_CHILDREN, String.valueOf(s.getNumChildren()));
                    nodeMeta.put(PZXID, "0x" + Long.toHexString(s.getPzxid()));
                    nodeMeta.put(VERSION, String.valueOf(s.getVersion()));
                }
            }
            catch (Exception e) {
                LoggerFactory.getLogger().error((Object)("Error occurred retrieving meta data for node: " + nodePath), (Throwable)e);
            }
        }
        return nodeMeta;
    }

    @Override
    public int getNumChildren(String nodePath) {
        long start = System.currentTimeMillis();
        if (this.connected) {
            int numChildren = this.cache.getNumChildren(nodePath);
            long end = System.currentTimeMillis();
            return numChildren;
        }
        return -1;
    }

    @Override
    public boolean hasChildren(String nodePath) {
        return this.getNumChildren(nodePath) > 0;
    }

    @Override
    public boolean isAllowsChildren(String nodePath) {
        if (this.connected) {
            try {
                Stat s = this.zooKeeper.exists(nodePath, false);
                if (s != null) {
                    return s.getEphemeralOwner() == 0L;
                }
            }
            catch (Exception e) {
                LoggerFactory.getLogger().error((Object)("Error occurred determining whether node is allowed children: " + nodePath), (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public Map<String, String> getSessionMeta() {
        LinkedHashMap<String, String> sessionMeta = new LinkedHashMap<String, String>();
        try {
            if (this.zooKeeper != null) {
                sessionMeta.put(SESSION_ID, String.valueOf(this.zooKeeper.getSessionId()));
                sessionMeta.put(SESSION_STATE, String.valueOf(this.zooKeeper.getState().toString()));
                sessionMeta.put(CONNECT_STRING, this.connectString);
                sessionMeta.put(SESSION_TIMEOUT, String.valueOf(this.sessionTimeout));
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger().error((Object)"Error occurred retrieving session meta data.", (Throwable)e);
        }
        return sessionMeta;
    }

    @Override
    public boolean createNode(String parent, String nodeName) {
        if (this.zooKeeper.getState() == ZooKeeper.States.CONNECTED) {
            try {
                String[] nodeElements;
                for (String nodeElement : nodeElements = nodeName.split("/")) {
                    String node = parent + "/" + nodeElement;
                    Stat s = this.zooKeeper.exists(node, false);
                    if (s != null) continue;
                    this.zooKeeper.create(node, this.encryptionManager.encryptData(null), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    parent = node;
                }
                return true;
            }
            catch (Exception e) {
                LoggerFactory.getLogger().error((Object)("Error occurred creating node: " + parent + "/" + nodeName), (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public boolean deleteNode(String nodePath) {
        if (this.zooKeeper.getState() == ZooKeeper.States.CONNECTED) {
            try {
                List children = this.zooKeeper.getChildren(nodePath, false);
                if (children != null) {
                    for (String child : children) {
                        String node = nodePath + "/" + child;
                        this.deleteNode(node);
                    }
                }
                this.zooKeeper.delete(nodePath, -1);
                return true;
            }
            catch (Exception e) {
                LoggerFactory.getLogger().error((Object)("Error occurred deleting node: " + nodePath), (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public boolean setData(String nodePath, String data) {
        if (this.connected) {
            try {
                this.zooKeeper.setData(nodePath, this.encryptionManager.encryptData(data), -1);
                return true;
            }
            catch (Exception e) {
                LoggerFactory.getLogger().error((Object)("Error occurred setting data for node: " + nodePath), (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public Pair<Map<String, List<String>>, Map<String, String>> getConnectionPropertiesTemplate() {
        LinkedHashMap<String, List<String>> template = new LinkedHashMap<String, List<String>>();
        template.put(CONNECT_STRING, this.defaultHostsList);
        template.put(SESSION_TIMEOUT, Arrays.asList(this.defaultTimeout));
        template.put(DATA_ENCRYPTION_MANAGER, Arrays.asList(this.defaultEncryptionManager));
        LinkedHashMap<String, String> labels = new LinkedHashMap<String, String>();
        labels.put(CONNECT_STRING, "Connect String");
        labels.put(SESSION_TIMEOUT, "Session Timeout");
        labels.put(DATA_ENCRYPTION_MANAGER, "Data Encryption Manager");
        return new Pair<Map<String, List<String>>, Map<String, String>>(template, labels);
    }

    @Override
    public void addWatchers(Collection<String> selectedNodes, NodeListener nodeListener) {
        if (this.connected) {
            for (String node : selectedNodes) {
                if (this.watchers.containsKey(node)) continue;
                try {
                    this.watchers.put(node, new NodeWatcher(node, nodeListener, this.zooKeeper));
                }
                catch (Exception e) {
                    LoggerFactory.getLogger().error((Object)("Error occured adding node watcher for node: " + node), (Throwable)e);
                }
            }
        }
    }

    @Override
    public void removeWatchers(Collection<String> selectedNodes) {
        if (this.connected) {
            for (String node : selectedNodes) {
                NodeWatcher watcher;
                if (!this.watchers.containsKey(node) || (watcher = this.watchers.remove(node)) == null) continue;
                watcher.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> loadNodeViewersFile(File selectedFile) throws IOException {
        ArrayList<String> result;
        block8: {
            result = new ArrayList<String>();
            if (defaultNodeViewersFile.exists()) {
                FileReader reader = new FileReader(selectedFile);
                try {
                    BufferedReader buff = new BufferedReader(reader);
                    try {
                        while (buff.ready()) {
                            String line = buff.readLine();
                            if (line == null || line.length() <= 0) continue;
                            result.add(line);
                        }
                        break block8;
                    }
                    finally {
                        buff.close();
                    }
                }
                finally {
                    reader.close();
                }
            }
            result.add("org.apache.zookeeper.inspector.gui.nodeviewer.NodeViewerData");
            result.add("org.apache.zookeeper.inspector.gui.nodeviewer.NodeViewerMetaData");
            result.add("org.apache.zookeeper.inspector.gui.nodeviewer.NodeViewerACL");
        }
        return result;
    }

    private void loadDefaultConnectionFile() throws IOException {
        if (defaultConnectionFile.exists()) {
            Properties props = new Properties();
            FileReader reader = new FileReader(defaultConnectionFile);
            try {
                props.load(reader);
            }
            finally {
                reader.close();
            }
            this.defaultEncryptionManager = props.getProperty(DATA_ENCRYPTION_MANAGER) == null ? "org.apache.zookeeper.inspector.encryption.BasicDataEncryptionManager" : props.getProperty(DATA_ENCRYPTION_MANAGER);
            this.defaultTimeout = props.getProperty(SESSION_TIMEOUT) == null ? "30000" : props.getProperty(SESSION_TIMEOUT);
            this.defaultHosts = props.getProperty(CONNECT_STRING) == null ? "localhost:2181" : props.getProperty(CONNECT_STRING);
        } else {
            this.defaultEncryptionManager = "org.apache.zookeeper.inspector.encryption.BasicDataEncryptionManager";
            this.defaultTimeout = "30000";
            this.defaultHosts = "localhost:2181";
        }
        this.defaultHostsList = new ArrayList<String>(Arrays.asList(this.defaultHosts.trim().split("\\s+")));
        System.out.println("defaultHostsList: " + this.defaultHostsList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveDefaultConnectionFile(Properties props) throws IOException {
        File defaultDir = defaultConnectionFile.getParentFile();
        if (!defaultDir.exists() && !defaultDir.mkdirs()) {
            throw new IOException("Failed to create configuration directory: " + defaultDir.getAbsolutePath());
        }
        if (!defaultConnectionFile.exists() && !defaultConnectionFile.createNewFile()) {
            throw new IOException("Failed to create default connection file: " + defaultConnectionFile.getAbsolutePath());
        }
        FileWriter writer = new FileWriter(defaultConnectionFile);
        try {
            props.store(writer, "Default connection for ZooInspector");
        }
        finally {
            writer.close();
        }
    }

    @Override
    public void updateDefaultConnectionFile(Properties connectionProps) throws IOException {
        Properties properties = new Properties();
        String connStr = connectionProps.getProperty(CONNECT_STRING);
        this.defaultHostsList.remove(connStr);
        while (this.defaultHostsList.size() > 10) {
            this.defaultHostsList.remove(this.defaultHostsList.size() - 1);
        }
        this.defaultHostsList.add(0, connStr);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.defaultHostsList.size(); ++i) {
            String str = this.defaultHostsList.get(i);
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(str);
        }
        System.out.println("updateDefaultConnectionFile#connectString: " + sb.toString());
        properties.setProperty(CONNECT_STRING, sb.toString());
        properties.setProperty(SESSION_TIMEOUT, this.defaultTimeout);
        properties.getProperty(DATA_ENCRYPTION_MANAGER, this.defaultEncryptionManager);
        this.saveDefaultConnectionFile(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveNodeViewersFile(File selectedFile, List<String> nodeViewersClassNames) throws IOException {
        if (!selectedFile.exists() && !selectedFile.createNewFile()) {
            throw new IOException("Failed to create node viewers configuration file: " + selectedFile.getAbsolutePath());
        }
        FileWriter writer = new FileWriter(selectedFile);
        try {
            BufferedWriter buff = new BufferedWriter(writer);
            try {
                for (String nodeViewersClassName : nodeViewersClassNames) {
                    buff.append(nodeViewersClassName);
                    buff.append("\n");
                }
            }
            finally {
                buff.flush();
                buff.close();
            }
        }
        finally {
            writer.close();
        }
    }

    @Override
    public void setDefaultNodeViewerConfiguration(List<String> nodeViewersClassNames) throws IOException {
        File defaultDir = defaultNodeViewersFile.getParentFile();
        if (!defaultDir.exists() && !defaultDir.mkdirs()) {
            throw new IOException("Failed to create configuration directory: " + defaultDir.getAbsolutePath());
        }
        this.saveNodeViewersFile(defaultNodeViewersFile, nodeViewersClassNames);
    }

    @Override
    public List<String> getDefaultNodeViewerConfiguration() throws IOException {
        return this.loadNodeViewersFile(defaultNodeViewersFile);
    }

    @Override
    public Properties getLastConnectionProps() {
        return this.lastConnectionProps;
    }

    @Override
    public void setLastConnectionProps(Properties connectionProps) {
        this.lastConnectionProps = connectionProps;
    }

    @Override
    public ZooInspectorManagerCache getCache() {
        return this.cache;
    }

    @Override
    public ZooKeeper.States getZookeeperStates() {
        if (this.zooKeeper == null) {
            return null;
        }
        return this.zooKeeper.getState();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NodeWatcher
    implements Watcher {
        private final String nodePath;
        private final NodeListener nodeListener;
        private final ZooKeeper zookeeper;
        private boolean closed = false;
        private final Stat stat = new Stat();
        private List<String> childs;

        public NodeWatcher(String nodePath, NodeListener nodeListener, ZooKeeper zookeeper) throws KeeperException, InterruptedException {
            this.nodePath = nodePath;
            this.nodeListener = nodeListener;
            this.zookeeper = zookeeper;
            Stat s = ZooInspectorManagerImpl.this.zooKeeper.exists(nodePath, (Watcher)this);
            if (s != null) {
                this.childs = zookeeper.getChildren(nodePath, (Watcher)this, this.stat);
            }
        }

        public void process(WatchedEvent event) {
            if (!this.closed) {
                try {
                    Stat s;
                    if (event.getType() != Watcher.Event.EventType.NodeDeleted && (s = ZooInspectorManagerImpl.this.zooKeeper.exists(this.nodePath, (Watcher)this)) != null) {
                        this.childs = this.zookeeper.getChildren(this.nodePath, (Watcher)this, s);
                    }
                }
                catch (Exception e) {
                    LoggerFactory.getLogger().error((Object)("Error occured re-adding node watcherfor node " + this.nodePath), (Throwable)e);
                }
                if (this.nodeListener != null) {
                    this.nodeListener.processEvent(event.getPath(), event.getType().name(), null);
                }
            }
        }

        public void stop() {
            this.closed = true;
        }

        public List<String> getChilds() {
            return this.childs;
        }
    }
}

