/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.retry;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.inspector.logger.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZooKeeperRetry
extends ZooKeeper {
    private boolean closed = false;
    private final Watcher watcher;
    private int limit = -1;

    public ZooKeeperRetry(String connectString, int sessionTimeout, Watcher watcher) throws IOException {
        super(connectString, sessionTimeout, watcher);
        this.watcher = watcher;
    }

    public ZooKeeperRetry(String connectString, int sessionTimeout, Watcher watcher, long sessionId, byte[] sessionPasswd) throws IOException {
        super(connectString, sessionTimeout, watcher, sessionId, sessionPasswd);
        this.watcher = watcher;
    }

    public synchronized void close() throws InterruptedException {
        this.closed = true;
        super.close();
    }

    public String create(String path, byte[] data, List<ACL> acl, CreateMode createMode) throws KeeperException, InterruptedException {
        int count = 0;
        do {
            try {
                return super.create(path, data, acl, createMode);
            }
            catch (KeeperException.ConnectionLossException e) {
                LoggerFactory.getLogger().warn((Object)"ZooKeeper connection lost.  Trying to reconnect.");
                if (this.exists(path, false) == null) continue;
                return path;
            }
            catch (KeeperException.NodeExistsException e) {
                return path;
            }
        } while (!this.closed && (this.limit == -1 || count++ < this.limit));
        return null;
    }

    public void delete(String path, int version) throws InterruptedException, KeeperException {
        int count = 0;
        do {
            try {
                super.delete(path, version);
            }
            catch (KeeperException.ConnectionLossException e) {
                LoggerFactory.getLogger().warn((Object)"ZooKeeper connection lost.  Trying to reconnect.");
                if (this.exists(path, false) != null) continue;
                return;
            }
            catch (KeeperException.NoNodeException e) {
                break;
            }
        } while (!this.closed && (this.limit == -1 || count++ < this.limit));
    }

    public Stat exists(String path, boolean watch) throws KeeperException, InterruptedException {
        int count = 0;
        while (true) {
            try {
                return super.exists(path, watch ? this.watcher : null);
            }
            catch (KeeperException.ConnectionLossException e) {
                LoggerFactory.getLogger().warn((Object)"ZooKeeper connection lost.  Trying to reconnect.");
                if (!this.closed && (this.limit == -1 || count++ < this.limit)) continue;
                return null;
            }
            break;
        }
    }

    public Stat exists(String path, Watcher watcher) throws KeeperException, InterruptedException {
        int count = 0;
        while (true) {
            try {
                return super.exists(path, watcher);
            }
            catch (KeeperException.ConnectionLossException e) {
                LoggerFactory.getLogger().warn((Object)"ZooKeeper connection lost.  Trying to reconnect.");
                if (!this.closed && (this.limit == -1 || count++ < this.limit)) continue;
                return null;
            }
            break;
        }
    }

    public List<ACL> getACL(String path, Stat stat) throws KeeperException, InterruptedException {
        int count = 0;
        while (true) {
            try {
                return super.getACL(path, stat);
            }
            catch (KeeperException.ConnectionLossException e) {
                LoggerFactory.getLogger().warn((Object)"ZooKeeper connection lost.  Trying to reconnect.");
                if (!this.closed && (this.limit == -1 || count++ < this.limit)) continue;
                return null;
            }
            break;
        }
    }

    public List<String> getChildren(String path, boolean watch) throws KeeperException, InterruptedException {
        int count = 0;
        while (true) {
            try {
                return super.getChildren(path, watch ? this.watcher : null);
            }
            catch (KeeperException.ConnectionLossException e) {
                LoggerFactory.getLogger().warn((Object)"ZooKeeper connection lost.  Trying to reconnect.");
                if (!this.closed && (this.limit == -1 || count++ < this.limit)) continue;
                return new ArrayList<String>();
            }
            break;
        }
    }

    public List<String> getChildren(String path, Watcher watcher) throws KeeperException, InterruptedException {
        int count = 0;
        while (true) {
            try {
                return super.getChildren(path, watcher);
            }
            catch (KeeperException.ConnectionLossException e) {
                LoggerFactory.getLogger().warn((Object)"ZooKeeper connection lost.  Trying to reconnect.");
                if (!this.closed && (this.limit == -1 || count++ < this.limit)) continue;
                return new ArrayList<String>();
            }
            break;
        }
    }

    public byte[] getData(String path, boolean watch, Stat stat) throws KeeperException, InterruptedException {
        int count = 0;
        while (true) {
            try {
                return super.getData(path, watch ? this.watcher : null, stat);
            }
            catch (KeeperException.ConnectionLossException e) {
                LoggerFactory.getLogger().warn((Object)"ZooKeeper connection lost.  Trying to reconnect.");
                if (!this.closed && (this.limit == -1 || count++ < this.limit)) continue;
                return null;
            }
            break;
        }
    }

    public byte[] getData(String path, Watcher watcher, Stat stat) throws KeeperException, InterruptedException {
        int count = 0;
        while (true) {
            try {
                return super.getData(path, watcher, stat);
            }
            catch (KeeperException.ConnectionLossException e) {
                LoggerFactory.getLogger().warn((Object)"ZooKeeper connection lost.  Trying to reconnect.");
                if (!this.closed && (this.limit == -1 || count++ < this.limit)) continue;
                return null;
            }
            break;
        }
    }

    public Stat setACL(String path, List<ACL> acl, int version) throws KeeperException, InterruptedException {
        int count = 0;
        while (true) {
            try {
                return super.setACL(path, acl, version);
            }
            catch (KeeperException.ConnectionLossException e) {
                LoggerFactory.getLogger().warn((Object)"ZooKeeper connection lost.  Trying to reconnect.");
                Stat s = this.exists(path, false);
                if (s != null) {
                    if (!this.getACL(path, s).equals(acl)) continue;
                    return s;
                }
                return null;
                if (!this.closed && (this.limit == -1 || count++ < this.limit)) continue;
                return null;
            }
            break;
        }
    }

    public Stat setData(String path, byte[] data, int version) throws KeeperException, InterruptedException {
        int count = 0;
        while (true) {
            try {
                return super.setData(path, data, version);
            }
            catch (KeeperException.ConnectionLossException e) {
                LoggerFactory.getLogger().warn((Object)"ZooKeeper connection lost.  Trying to reconnect.");
                Stat s = this.exists(path, false);
                if (s != null) {
                    if (this.getData(path, false, s) != data) continue;
                    return s;
                }
                return null;
                if (!this.closed && (this.limit == -1 || count++ < this.limit)) continue;
                return null;
            }
            break;
        }
    }

    public void setRetryLimit(int limit) {
        this.limit = limit;
    }

    public boolean testConnection() {
        int count = 0;
        while (true) {
            try {
                return super.exists("/", null) != null;
            }
            catch (Exception e) {
                LoggerFactory.getLogger().warn((Object)"ZooKeeper connection lost.  Trying to reconnect.");
                if (count++ < 3) continue;
                return false;
            }
            break;
        }
    }
}

