/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.BinaryOutputArchive;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.server.DataTree;
import org.apache.zookeeper.server.SerializationPerfTest;
import org.junit.Test;

public class DeserializationPerfTest
extends TestCase {
    protected static final Logger LOG = Logger.getLogger(DeserializationPerfTest.class);

    private static void deserializeTree(int depth, int width, int len) throws InterruptedException, IOException, KeeperException.NodeExistsException, KeeperException.NoNodeException {
        DataTree tree = new DataTree();
        SerializationPerfTest.createNodes(tree, "/", depth, width, new byte[len]);
        int count = tree.getNodeCount();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive oa = BinaryOutputArchive.getArchive(baos);
        tree.serialize(oa, "test");
        baos.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        BinaryInputArchive ia = BinaryInputArchive.getArchive(bais);
        DataTree dserTree = new DataTree();
        System.gc();
        long start = System.nanoTime();
        dserTree.deserialize(ia, "test");
        long end = System.nanoTime();
        long durationms = (end - start) / 1000000L;
        long pernodeus = (end - start) / 1000L / (long)count;
        DeserializationPerfTest.assertEquals((int)count, (int)dserTree.getNodeCount());
        LOG.info("Deserialized " + count + " nodes in " + durationms + " ms (" + pernodeus + "us/node), depth=" + depth + " width=" + width + " datalen=" + len);
    }

    @Test
    public void testSingleDeserialize() throws InterruptedException, IOException, KeeperException.NodeExistsException, KeeperException.NoNodeException {
        DeserializationPerfTest.deserializeTree(1, 0, 20);
    }

    @Test
    public void testWideDeserialize() throws InterruptedException, IOException, KeeperException.NodeExistsException, KeeperException.NoNodeException {
        DeserializationPerfTest.deserializeTree(2, 10000, 20);
    }

    @Test
    public void testDeepDeserialize() throws InterruptedException, IOException, KeeperException.NodeExistsException, KeeperException.NoNodeException {
        DeserializationPerfTest.deserializeTree(400, 1, 20);
    }

    @Test
    public void test10Wide5DeepDeserialize() throws InterruptedException, IOException, KeeperException.NodeExistsException, KeeperException.NoNodeException {
        DeserializationPerfTest.deserializeTree(5, 10, 20);
    }

    @Test
    public void test15Wide5DeepDeserialize() throws InterruptedException, IOException, KeeperException.NodeExistsException, KeeperException.NoNodeException {
        DeserializationPerfTest.deserializeTree(5, 15, 20);
    }

    @Test
    public void test25Wide4DeepDeserialize() throws InterruptedException, IOException, KeeperException.NodeExistsException, KeeperException.NoNodeException {
        DeserializationPerfTest.deserializeTree(4, 25, 20);
    }

    @Test
    public void test40Wide4DeepDeserialize() throws InterruptedException, IOException, KeeperException.NodeExistsException, KeeperException.NoNodeException {
        DeserializationPerfTest.deserializeTree(4, 40, 20);
    }

    @Test
    public void test300Wide3DeepDeserialize() throws InterruptedException, IOException, KeeperException.NodeExistsException, KeeperException.NoNodeException {
        DeserializationPerfTest.deserializeTree(3, 300, 20);
    }
}

