/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.Record;
import org.apache.log4j.Logger;
import org.apache.zookeeper.Environment;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Version;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.jmx.MBeanRegistry;
import org.apache.zookeeper.proto.AuthPacket;
import org.apache.zookeeper.proto.ConnectRequest;
import org.apache.zookeeper.proto.ConnectResponse;
import org.apache.zookeeper.proto.ReplyHeader;
import org.apache.zookeeper.proto.RequestHeader;
import org.apache.zookeeper.proto.WatcherEvent;
import org.apache.zookeeper.server.ByteBufferInputStream;
import org.apache.zookeeper.server.ConnectionBean;
import org.apache.zookeeper.server.DataTree;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.ZooTrace;
import org.apache.zookeeper.server.auth.AuthenticationProvider;
import org.apache.zookeeper.server.auth.ProviderRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NIOServerCnxn
implements Watcher,
ServerCnxn {
    private static final Logger LOG = Logger.getLogger(NIOServerCnxn.class);
    private ConnectionBean jmxConnectionBean;
    static final ByteBuffer closeConn = ByteBuffer.allocate(0);
    final Factory factory;
    private final ZooKeeperServer zk;
    private SocketChannel sock;
    private SelectionKey sk;
    boolean initialized;
    ByteBuffer lenBuffer;
    ByteBuffer incomingBuffer;
    LinkedBlockingQueue<ByteBuffer> outgoingBuffers;
    int sessionTimeout;
    ArrayList<Id> authInfo;
    private static final int confCmd = ByteBuffer.wrap("conf".getBytes()).getInt();
    private static final int consCmd = ByteBuffer.wrap("cons".getBytes()).getInt();
    private static final int crstCmd = ByteBuffer.wrap("crst".getBytes()).getInt();
    private static final int dumpCmd = ByteBuffer.wrap("dump".getBytes()).getInt();
    private static final int enviCmd = ByteBuffer.wrap("envi".getBytes()).getInt();
    private static final int getTraceMaskCmd = ByteBuffer.wrap("gtmk".getBytes()).getInt();
    private static final int ruokCmd = ByteBuffer.wrap("ruok".getBytes()).getInt();
    private static final int setTraceMaskCmd = ByteBuffer.wrap("stmk".getBytes()).getInt();
    private static final int srvrCmd = ByteBuffer.wrap("srvr".getBytes()).getInt();
    private static final int srstCmd = ByteBuffer.wrap("srst".getBytes()).getInt();
    private static final int statCmd = ByteBuffer.wrap("stat".getBytes()).getInt();
    private static final int wchcCmd = ByteBuffer.wrap("wchc".getBytes()).getInt();
    private static final int wchpCmd = ByteBuffer.wrap("wchp".getBytes()).getInt();
    private static final int wchsCmd = ByteBuffer.wrap("wchs".getBytes()).getInt();
    private static final HashMap<Integer, String> cmd2String = new HashMap();
    private static final String ZK_NOT_SERVING = "This ZooKeeper instance is not currently serving requests";
    int outstandingRequests;
    long sessionId;
    static long nextSessionId;
    private static final byte[] fourBytes;
    private final CnxnStats stats;

    @Override
    public void sendCloseSession() {
        this.sendBuffer(closeConn);
    }

    void sendBufferSync(ByteBuffer bb) {
        try {
            this.sock.configureBlocking(true);
            if (bb != closeConn) {
                if (this.sock != null) {
                    this.sock.write(bb);
                }
                this.packetSent();
            }
        }
        catch (IOException ie) {
            LOG.error("Error sending data synchronously ", ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendBuffer(ByteBuffer bb) {
        try {
            if (bb != closeConn) {
                if ((this.sk.interestOps() & 4) == 0) {
                    try {
                        this.sock.write(bb);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (bb.remaining() == 0) {
                    this.packetSent();
                    return;
                }
            }
            Factory e = this.factory;
            synchronized (e) {
                this.sk.selector().wakeup();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Add a buffer to outgoingBuffers, sk " + this.sk + " is valid: " + this.sk.isValid());
                }
                this.outgoingBuffers.add(bb);
                if (this.sk.isValid()) {
                    this.sk.interestOps(this.sk.interestOps() | 4);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Unexpected Exception: ", e);
        }
    }

    private void readPayload() throws IOException, InterruptedException {
        int rc;
        if (this.incomingBuffer.remaining() != 0 && (rc = this.sock.read(this.incomingBuffer)) < 0) {
            throw new EndOfStreamException("Unable to read additional data from client sessionid 0x" + Long.toHexString(this.sessionId) + ", likely client has closed socket");
        }
        if (this.incomingBuffer.remaining() == 0) {
            this.packetReceived();
            this.incomingBuffer.flip();
            if (!this.initialized) {
                this.readConnectRequest();
            } else {
                this.readRequest();
            }
            this.lenBuffer.clear();
            this.incomingBuffer = this.lenBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doIO(SelectionKey k) throws InterruptedException {
        block27: {
            try {
                if (this.sock == null) {
                    LOG.warn("trying to do i/o on a null socket for session:0x" + Long.toHexString(this.sessionId));
                    return;
                }
                if (k.isReadable()) {
                    int rc = this.sock.read(this.incomingBuffer);
                    if (rc < 0) {
                        throw new EndOfStreamException("Unable to read additional data from client sessionid 0x" + Long.toHexString(this.sessionId) + ", likely client has closed socket");
                    }
                    if (this.incomingBuffer.remaining() == 0) {
                        boolean isPayload;
                        if (this.incomingBuffer == this.lenBuffer) {
                            this.incomingBuffer.flip();
                            isPayload = this.readLength(k);
                            this.incomingBuffer.clear();
                        } else {
                            isPayload = true;
                        }
                        if (isPayload) {
                            this.readPayload();
                        } else {
                            return;
                        }
                    }
                }
                if (!k.isWritable()) break block27;
                if (this.outgoingBuffers.size() > 0) {
                    ByteBuffer directBuffer = this.factory.directBuffer;
                    directBuffer.clear();
                    for (ByteBuffer b : this.outgoingBuffers) {
                        if (directBuffer.remaining() < b.remaining()) {
                            b = (ByteBuffer)b.slice().limit(directBuffer.remaining());
                        }
                        int p = b.position();
                        directBuffer.put(b);
                        b.position(p);
                        if (directBuffer.remaining() != 0) continue;
                        break;
                    }
                    directBuffer.flip();
                    int sent = this.sock.write(directBuffer);
                    while (this.outgoingBuffers.size() > 0) {
                        ByteBuffer bb = this.outgoingBuffers.peek();
                        if (bb == closeConn) {
                            throw new CloseRequestException("close requested");
                        }
                        int left = bb.remaining() - sent;
                        if (left > 0) {
                            bb.position(bb.position() + sent);
                            break;
                        }
                        this.packetSent();
                        sent -= bb.remaining();
                        this.outgoingBuffers.remove();
                    }
                }
                Factory directBuffer = this.factory;
                synchronized (directBuffer) {
                    if (this.outgoingBuffers.size() == 0) {
                        if (!this.initialized && (this.sk.interestOps() & 1) == 0) {
                            throw new CloseRequestException("responded to info probe");
                        }
                        this.sk.interestOps(this.sk.interestOps() & 0xFFFFFFFB);
                    } else {
                        this.sk.interestOps(this.sk.interestOps() | 4);
                    }
                }
            }
            catch (CancelledKeyException e) {
                LOG.warn("Exception causing close of session 0x" + Long.toHexString(this.sessionId) + " due to " + e);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("CancelledKeyException stack trace", e);
                }
                this.close();
            }
            catch (CloseRequestException e) {
                this.close();
            }
            catch (EndOfStreamException e) {
                LOG.warn(e);
                this.close();
            }
            catch (IOException e) {
                LOG.warn("Exception causing close of session 0x" + Long.toHexString(this.sessionId) + " due to " + e);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("IOException stack trace", e);
                }
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readRequest() throws IOException {
        ByteBufferInputStream bais = new ByteBufferInputStream(this.incomingBuffer);
        BinaryInputArchive bia = BinaryInputArchive.getArchive(bais);
        RequestHeader h = new RequestHeader();
        h.deserialize(bia, "header");
        this.incomingBuffer = this.incomingBuffer.slice();
        if (h.getType() == 100) {
            AuthPacket authPacket = new AuthPacket();
            ZooKeeperServer.byteBuffer2Record(this.incomingBuffer, authPacket);
            String scheme = authPacket.getScheme();
            AuthenticationProvider ap = ProviderRegistry.getProvider(scheme);
            if (ap == null || ap.handleAuthentication(this, authPacket.getAuth()) != KeeperException.Code.OK) {
                if (ap == null) {
                    LOG.warn("No authentication provider for scheme: " + scheme + " has " + ProviderRegistry.listProviders());
                } else {
                    LOG.warn("Authentication failed for scheme: " + scheme);
                }
                ReplyHeader rh = new ReplyHeader(h.getXid(), 0L, KeeperException.Code.AUTHFAILED.intValue());
                this.sendResponse(rh, null, null);
                this.sendCloseSession();
                this.disableRecv();
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Authentication succeeded for scheme: " + scheme);
                }
                ReplyHeader rh = new ReplyHeader(h.getXid(), 0L, KeeperException.Code.OK.intValue());
                this.sendResponse(rh, null, null);
            }
            return;
        }
        Request si = new Request(this, this.sessionId, h.getXid(), h.getType(), this.incomingBuffer, this.authInfo);
        si.setOwner(ServerCnxn.me);
        this.zk.submitRequest(si);
        if (h.getXid() >= 0) {
            Object object = this;
            synchronized (object) {
                ++this.outstandingRequests;
            }
            object = this.factory;
            synchronized (object) {
                if (this.zk.getInProcess() > this.factory.outstandingLimit) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Throttling recv " + this.zk.getInProcess());
                    }
                    this.disableRecv();
                }
            }
        }
    }

    public void disableRecv() {
        this.sk.interestOps(this.sk.interestOps() & 0xFFFFFFFE);
    }

    public void enableRecv() {
        int interest;
        if (this.sk.isValid() && ((interest = this.sk.interestOps()) & 1) == 0) {
            this.sk.interestOps(interest | 1);
        }
    }

    private void readConnectRequest() throws IOException, InterruptedException {
        int maxSessionTimeout;
        BinaryInputArchive bia = BinaryInputArchive.getArchive(new ByteBufferInputStream(this.incomingBuffer));
        ConnectRequest connReq = new ConnectRequest();
        connReq.deserialize(bia, "connect");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Session establishment request from client " + this.sock.socket().getRemoteSocketAddress() + " client's lastZxid is 0x" + Long.toHexString(connReq.getLastZxidSeen()));
        }
        if (this.zk == null) {
            throw new IOException("ZooKeeperServer not running");
        }
        if (connReq.getLastZxidSeen() > this.zk.getZKDatabase().getDataTreeLastProcessedZxid()) {
            String msg = "Refusing session request for client " + this.sock.socket().getRemoteSocketAddress() + " as it has seen zxid 0x" + Long.toHexString(connReq.getLastZxidSeen()) + " our last zxid is 0x" + Long.toHexString(this.zk.getZKDatabase().getDataTreeLastProcessedZxid()) + " client must try another server";
            LOG.info(msg);
            throw new CloseRequestException(msg);
        }
        this.sessionTimeout = connReq.getTimeOut();
        byte[] passwd = connReq.getPasswd();
        int minSessionTimeout = this.zk.getMinSessionTimeout();
        if (this.sessionTimeout < minSessionTimeout) {
            this.sessionTimeout = minSessionTimeout;
        }
        if (this.sessionTimeout > (maxSessionTimeout = this.zk.getMaxSessionTimeout())) {
            this.sessionTimeout = maxSessionTimeout;
        }
        this.disableRecv();
        if (connReq.getSessionId() != 0L) {
            long clientSessionId = connReq.getSessionId();
            LOG.info("Client attempting to renew session 0x" + Long.toHexString(clientSessionId) + " at " + this.sock.socket().getRemoteSocketAddress());
            this.factory.closeSessionWithoutWakeup(clientSessionId);
            this.setSessionId(clientSessionId);
            this.zk.reopenSession(this, this.sessionId, passwd, this.sessionTimeout);
        } else {
            LOG.info("Client attempting to establish new session at " + this.sock.socket().getRemoteSocketAddress());
            this.zk.createSession(this, passwd, this.sessionTimeout);
        }
        this.initialized = true;
    }

    private void packetReceived() {
        this.stats.incrPacketsReceived();
        if (this.zk != null) {
            this.zk.serverStats().incrementPacketsReceived();
        }
    }

    private void packetSent() {
        this.stats.incrPacketsSent();
        if (this.zk != null) {
            this.zk.serverStats().incrementPacketsSent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupWriterSocket(PrintWriter pwriter) {
        try {
            if (pwriter != null) {
                pwriter.flush();
                pwriter.close();
            }
        }
        catch (Exception e) {
            LOG.info("Error closing PrintWriter ", e);
        }
        finally {
            try {
                this.close();
            }
            catch (Exception e) {
                LOG.error("Error closing a command socket ", e);
            }
        }
    }

    private boolean checkFourLetterWord(SelectionKey k, int len) throws IOException {
        String cmd = cmd2String.get(len);
        if (cmd == null) {
            return false;
        }
        LOG.info("Processing " + cmd + " command from " + this.sock.socket().getRemoteSocketAddress());
        this.packetReceived();
        if (k != null) {
            try {
                k.cancel();
            }
            catch (Exception e) {
                LOG.error("Error cancelling command selection key ", e);
            }
        }
        PrintWriter pwriter = new PrintWriter(new BufferedWriter(new SendBufferWriter()));
        if (len == ruokCmd) {
            RuokCommand ruok = new RuokCommand(pwriter);
            ruok.start();
            return true;
        }
        if (len == getTraceMaskCmd) {
            TraceMaskCommand tmask = new TraceMaskCommand(pwriter);
            tmask.start();
            return true;
        }
        if (len == setTraceMaskCmd) {
            int rc = this.sock.read(this.incomingBuffer);
            if (rc < 0) {
                throw new IOException("Read error");
            }
            this.incomingBuffer.flip();
            long traceMask = this.incomingBuffer.getLong();
            ZooTrace.setTextTraceLevel(traceMask);
            SetTraceMaskCommand setMask = new SetTraceMaskCommand(pwriter, traceMask);
            setMask.start();
            return true;
        }
        if (len == enviCmd) {
            EnvCommand env = new EnvCommand(pwriter);
            env.start();
            return true;
        }
        if (len == confCmd) {
            ConfCommand ccmd = new ConfCommand(pwriter);
            ccmd.start();
            return true;
        }
        if (len == srstCmd) {
            StatResetCommand strst = new StatResetCommand(pwriter);
            strst.start();
            return true;
        }
        if (len == crstCmd) {
            CnxnStatResetCommand crst = new CnxnStatResetCommand(pwriter);
            crst.start();
            return true;
        }
        if (len == dumpCmd) {
            DumpCommand dump = new DumpCommand(pwriter);
            dump.start();
            return true;
        }
        if (len == statCmd || len == srvrCmd) {
            StatCommand stat = new StatCommand(pwriter, len);
            stat.start();
            return true;
        }
        if (len == consCmd) {
            ConsCommand cons = new ConsCommand(pwriter);
            cons.start();
            return true;
        }
        if (len == wchpCmd || len == wchcCmd || len == wchsCmd) {
            WatchCommand wcmd = new WatchCommand(pwriter, len);
            wcmd.start();
            return true;
        }
        return false;
    }

    private boolean readLength(SelectionKey k) throws IOException {
        int len = this.lenBuffer.getInt();
        if (!this.initialized && this.checkFourLetterWord(k, len)) {
            return false;
        }
        if (len < 0 || len > BinaryInputArchive.maxBuffer) {
            throw new IOException("Len error " + len);
        }
        if (this.zk == null) {
            throw new IOException("ZooKeeperServer not running");
        }
        this.incomingBuffer = ByteBuffer.allocate(len);
        return true;
    }

    @Override
    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public NIOServerCnxn(ZooKeeperServer zk, SocketChannel sock, SelectionKey sk, Factory factory) throws IOException {
        this.incomingBuffer = this.lenBuffer = ByteBuffer.allocate(4);
        this.outgoingBuffers = new LinkedBlockingQueue();
        this.authInfo = new ArrayList();
        this.stats = new CnxnStats();
        this.zk = zk;
        this.sock = sock;
        this.sk = sk;
        this.factory = factory;
        sock.socket().setTcpNoDelay(true);
        sock.socket().setSoLinger(true, 2);
        InetAddress addr = ((InetSocketAddress)sock.socket().getRemoteSocketAddress()).getAddress();
        this.authInfo.add(new Id("ip", addr.getHostAddress()));
        sk.interestOps(1);
    }

    public String toString() {
        return "NIOServerCnxn object with sock = " + this.sock + " and sk = " + this.sk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        HashSet<NIOServerCnxn> hashSet = this.factory.cnxns;
        synchronized (hashSet) {
            block14: {
                if (!this.factory.cnxns.remove(this)) {
                    return;
                }
                HashMap<InetAddress, Set<NIOServerCnxn>> hashMap = this.factory.ipMap;
                synchronized (hashMap) {
                    Set<NIOServerCnxn> s = this.factory.ipMap.get(this.sock.socket().getInetAddress());
                    s.remove(this);
                }
                try {
                    if (this.jmxConnectionBean != null) {
                        MBeanRegistry.getInstance().unregister(this.jmxConnectionBean);
                    }
                }
                catch (Exception e) {
                    LOG.warn("Failed to unregister with JMX", e);
                }
                this.jmxConnectionBean = null;
                if (this.zk != null) {
                    this.zk.removeCnxn(this);
                }
                this.closeSock();
                if (this.sk != null) {
                    try {
                        this.sk.cancel();
                    }
                    catch (Exception e) {
                        if (!LOG.isDebugEnabled()) break block14;
                        LOG.debug("ignoring exception during selectionkey cancel", e);
                    }
                }
            }
        }
    }

    private void closeSock() {
        block12: {
            block11: {
                block10: {
                    block9: {
                        if (this.sock == null) {
                            return;
                        }
                        LOG.info("Closed socket connection for client " + this.sock.socket().getRemoteSocketAddress() + (this.sessionId != 0L ? " which had sessionid 0x" + Long.toHexString(this.sessionId) : " (no session established for client)"));
                        try {
                            this.sock.socket().shutdownOutput();
                        }
                        catch (IOException e) {
                            if (!LOG.isDebugEnabled()) break block9;
                            LOG.debug("ignoring exception during output shutdown", e);
                        }
                    }
                    try {
                        this.sock.socket().shutdownInput();
                    }
                    catch (IOException e) {
                        if (!LOG.isDebugEnabled()) break block10;
                        LOG.debug("ignoring exception during input shutdown", e);
                    }
                }
                try {
                    this.sock.socket().close();
                }
                catch (IOException e) {
                    if (!LOG.isDebugEnabled()) break block11;
                    LOG.debug("ignoring exception during socket close", e);
                }
            }
            try {
                this.sock.close();
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) break block12;
                LOG.debug("ignoring exception during socketchannel close", e);
            }
        }
        this.sock = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void sendResponse(ReplyHeader h, Record r, String tag) {
        block12: {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                BinaryOutputArchive bos = BinaryOutputArchive.getArchive(baos);
                try {
                    baos.write(fourBytes);
                    bos.writeRecord(h, "header");
                    if (r != null) {
                        bos.writeRecord(r, tag);
                    }
                    baos.close();
                }
                catch (IOException e) {
                    LOG.error("Error serializing response");
                }
                byte[] b = baos.toByteArray();
                ByteBuffer bb = ByteBuffer.wrap(b);
                bb.putInt(b.length - 4).rewind();
                this.sendBuffer(bb);
                if (h.getXid() <= 0) break block12;
                Object object = this;
                synchronized (object) {
                    --this.outstandingRequests;
                }
                object = this.factory;
                synchronized (object) {
                    if (this.zk.getInProcess() < this.factory.outstandingLimit || this.outstandingRequests < 1) {
                        this.sk.selector().wakeup();
                        this.enableRecv();
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("Unexpected exception. Destruction averted.", e);
            }
        }
    }

    @Override
    public synchronized void process(WatchedEvent event) {
        ReplyHeader h = new ReplyHeader(-1, -1L, 0);
        if (LOG.isTraceEnabled()) {
            ZooTrace.logTraceMessage(LOG, 64L, "Deliver event " + event + " to 0x" + Long.toHexString(this.sessionId) + " through " + this);
        }
        WatcherEvent e = event.getWrapper();
        this.sendResponse(h, e, "notification");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishSessionInit(boolean valid) {
        try {
            this.jmxConnectionBean = new ConnectionBean(this, this.zk);
            MBeanRegistry.getInstance().register(this.jmxConnectionBean, this.zk.jmxServerBean);
        }
        catch (Exception e) {
            LOG.warn("Failed to register with JMX", e);
            this.jmxConnectionBean = null;
        }
        try {
            ConnectResponse rsp = new ConnectResponse(0, valid ? this.sessionTimeout : 0, valid ? this.sessionId : 0L, valid ? this.zk.generatePasswd(this.sessionId) : new byte[16]);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BinaryOutputArchive bos = BinaryOutputArchive.getArchive(baos);
            bos.writeInt(-1, "len");
            rsp.serialize(bos, "connect");
            baos.close();
            ByteBuffer bb = ByteBuffer.wrap(baos.toByteArray());
            bb.putInt(bb.remaining() - 4).rewind();
            this.sendBuffer(bb);
            if (!valid) {
                LOG.info("Invalid session 0x" + Long.toHexString(this.sessionId) + " for client " + this.sock.socket().getRemoteSocketAddress() + ", probably expired");
                this.sendCloseSession();
            } else {
                LOG.info("Established session 0x" + Long.toHexString(this.sessionId) + " with negotiated timeout " + this.sessionTimeout + " for client " + this.sock.socket().getRemoteSocketAddress());
            }
            Factory factory = this.factory;
            synchronized (factory) {
                this.sk.selector().wakeup();
                this.enableRecv();
            }
        }
        catch (Exception e) {
            LOG.warn("Exception while establishing session, closing", e);
            this.close();
        }
    }

    @Override
    public long getSessionId() {
        return this.sessionId;
    }

    @Override
    public void setSessionId(long sessionId) {
        this.sessionId = sessionId;
    }

    @Override
    public ArrayList<Id> getAuthInfo() {
        return this.authInfo;
    }

    @Override
    public synchronized InetSocketAddress getRemoteAddress() {
        if (this.sock == null) {
            return null;
        }
        return (InetSocketAddress)this.sock.socket().getRemoteSocketAddress();
    }

    @Override
    public ServerCnxn.Stats getStats() {
        return this.stats;
    }

    static {
        cmd2String.put(confCmd, "conf");
        cmd2String.put(consCmd, "cons");
        cmd2String.put(crstCmd, "crst");
        cmd2String.put(dumpCmd, "dump");
        cmd2String.put(enviCmd, "envi");
        cmd2String.put(getTraceMaskCmd, "gtmk");
        cmd2String.put(ruokCmd, "ruok");
        cmd2String.put(setTraceMaskCmd, "stmk");
        cmd2String.put(srstCmd, "srst");
        cmd2String.put(srvrCmd, "srvr");
        cmd2String.put(statCmd, "stat");
        cmd2String.put(wchcCmd, "wchc");
        cmd2String.put(wchpCmd, "wchp");
        cmd2String.put(wchsCmd, "wchs");
        nextSessionId = 1L;
        fourBytes = new byte[4];
    }

    class CnxnStats
    implements ServerCnxn.Stats {
        private final Date established = new Date();
        private final AtomicLong packetsReceived = new AtomicLong();
        private final AtomicLong packetsSent = new AtomicLong();
        private long minLatency;
        private long maxLatency;
        private String lastOp;
        private long lastCxid;
        private long lastZxid;
        private long lastResponseTime;
        private long lastLatency;
        private long count;
        private long totalLatency;

        CnxnStats() {
            this.reset();
        }

        public synchronized void reset() {
            this.packetsReceived.set(0L);
            this.packetsSent.set(0L);
            this.minLatency = Long.MAX_VALUE;
            this.maxLatency = 0L;
            this.lastOp = "NA";
            this.lastCxid = -1L;
            this.lastZxid = -1L;
            this.lastResponseTime = 0L;
            this.lastLatency = 0L;
            this.count = 0L;
            this.totalLatency = 0L;
        }

        long incrPacketsReceived() {
            return this.packetsReceived.incrementAndGet();
        }

        long incrPacketsSent() {
            return this.packetsSent.incrementAndGet();
        }

        synchronized void updateForResponse(long cxid, long zxid, String op, long start, long end) {
            long elapsed;
            if (cxid >= 0L) {
                this.lastCxid = cxid;
            }
            this.lastZxid = zxid;
            this.lastOp = op;
            this.lastResponseTime = end;
            this.lastLatency = elapsed = end - start;
            if (elapsed < this.minLatency) {
                this.minLatency = elapsed;
            }
            if (elapsed > this.maxLatency) {
                this.maxLatency = elapsed;
            }
            ++this.count;
            this.totalLatency += elapsed;
        }

        public Date getEstablished() {
            return this.established;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getOutstandingRequests() {
            NIOServerCnxn nIOServerCnxn = NIOServerCnxn.this;
            synchronized (nIOServerCnxn) {
                Factory factory = NIOServerCnxn.this.factory;
                synchronized (factory) {
                    return NIOServerCnxn.this.outstandingRequests;
                }
            }
        }

        public long getPacketsReceived() {
            return this.packetsReceived.longValue();
        }

        public long getPacketsSent() {
            return this.packetsSent.longValue();
        }

        public synchronized long getMinLatency() {
            return this.minLatency == Long.MAX_VALUE ? 0L : this.minLatency;
        }

        public synchronized long getAvgLatency() {
            return this.count == 0L ? 0L : this.totalLatency / this.count;
        }

        public synchronized long getMaxLatency() {
            return this.maxLatency;
        }

        public synchronized String getLastOperation() {
            return this.lastOp;
        }

        public synchronized long getLastCxid() {
            return this.lastCxid;
        }

        public synchronized long getLastZxid() {
            return this.lastZxid;
        }

        public synchronized long getLastResponseTime() {
            return this.lastResponseTime;
        }

        public synchronized long getLastLatency() {
            return this.lastLatency;
        }

        public String toString() {
            StringWriter sw = new StringWriter();
            PrintWriter pwriter = new PrintWriter(sw);
            this.dumpConnectionInfo(pwriter, false);
            pwriter.flush();
            pwriter.close();
            return sw.toString();
        }

        public synchronized void dumpConnectionInfo(PrintWriter pwriter, boolean brief) {
            SelectableChannel channel = NIOServerCnxn.this.sk.channel();
            if (channel instanceof SocketChannel) {
                long sessionId;
                pwriter.print(" ");
                pwriter.print(((SocketChannel)channel).socket().getRemoteSocketAddress());
                pwriter.print("[");
                pwriter.print(NIOServerCnxn.this.sk.isValid() ? Integer.toHexString(NIOServerCnxn.this.sk.interestOps()) : "0");
                pwriter.print("](queued=");
                pwriter.print(this.getOutstandingRequests());
                pwriter.print(",recved=");
                pwriter.print(this.getPacketsReceived());
                pwriter.print(",sent=");
                pwriter.print(this.getPacketsSent());
                if (!brief && (sessionId = NIOServerCnxn.this.getSessionId()) != 0L) {
                    pwriter.print(",sid=0x");
                    pwriter.print(Long.toHexString(sessionId));
                    pwriter.print(",lop=");
                    pwriter.print(this.getLastOperation());
                    pwriter.print(",est=");
                    pwriter.print(this.getEstablished().getTime());
                    pwriter.print(",to=");
                    pwriter.print(NIOServerCnxn.this.getSessionTimeout());
                    long lastCxid = this.getLastCxid();
                    if (lastCxid >= 0L) {
                        pwriter.print(",lcxid=0x");
                        pwriter.print(Long.toHexString(lastCxid));
                    }
                    pwriter.print(",lzxid=0x");
                    pwriter.print(Long.toHexString(this.getLastZxid()));
                    pwriter.print(",lresp=");
                    pwriter.print(this.getLastResponseTime());
                    pwriter.print(",llat=");
                    pwriter.print(this.getLastLatency());
                    pwriter.print(",minlat=");
                    pwriter.print(this.getMinLatency());
                    pwriter.print(",avglat=");
                    pwriter.print(this.getAvgLatency());
                    pwriter.print(",maxlat=");
                    pwriter.print(this.getMaxLatency());
                }
                pwriter.println(")");
            }
        }
    }

    private class WatchCommand
    extends CommandThread {
        int len;

        public WatchCommand(PrintWriter pw, int len) {
            super(pw);
            this.len = 0;
            this.len = len;
        }

        public void commandRun() {
            if (NIOServerCnxn.this.zk == null) {
                this.pw.println(NIOServerCnxn.ZK_NOT_SERVING);
            } else {
                DataTree dt = NIOServerCnxn.this.zk.getZKDatabase().getDataTree();
                if (this.len == wchsCmd) {
                    dt.dumpWatchesSummary(this.pw);
                } else if (this.len == wchpCmd) {
                    dt.dumpWatches(this.pw, true);
                } else {
                    dt.dumpWatches(this.pw, false);
                }
                this.pw.println();
            }
        }
    }

    private class ConsCommand
    extends CommandThread {
        public ConsCommand(PrintWriter pw) {
            super(pw);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commandRun() {
            if (NIOServerCnxn.this.zk == null) {
                this.pw.println(NIOServerCnxn.ZK_NOT_SERVING);
            } else {
                HashSet cnxns;
                HashSet<NIOServerCnxn> hashSet = NIOServerCnxn.this.factory.cnxns;
                synchronized (hashSet) {
                    cnxns = (HashSet)NIOServerCnxn.this.factory.cnxns.clone();
                }
                for (NIOServerCnxn c : cnxns) {
                    ((CnxnStats)c.getStats()).dumpConnectionInfo(this.pw, false);
                }
                this.pw.println();
            }
        }
    }

    private class StatCommand
    extends CommandThread {
        int len;

        public StatCommand(PrintWriter pw, int len) {
            super(pw);
            this.len = len;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commandRun() {
            if (NIOServerCnxn.this.zk == null) {
                this.pw.println(NIOServerCnxn.ZK_NOT_SERVING);
            } else {
                this.pw.print("Zookeeper version: ");
                this.pw.println(Version.getFullVersion());
                if (this.len == statCmd) {
                    HashSet cnxnset;
                    LOG.info("Stat command output");
                    this.pw.println("Clients:");
                    HashSet<NIOServerCnxn> hashSet = NIOServerCnxn.this.factory.cnxns;
                    synchronized (hashSet) {
                        cnxnset = (HashSet)NIOServerCnxn.this.factory.cnxns.clone();
                    }
                    for (NIOServerCnxn c : cnxnset) {
                        ((CnxnStats)c.getStats()).dumpConnectionInfo(this.pw, true);
                    }
                    this.pw.println();
                }
                this.pw.print(NIOServerCnxn.this.zk.serverStats().toString());
                this.pw.print("Node count: ");
                this.pw.println(NIOServerCnxn.this.zk.getZKDatabase().getNodeCount());
            }
        }
    }

    private class DumpCommand
    extends CommandThread {
        public DumpCommand(PrintWriter pw) {
            super(pw);
        }

        public void commandRun() {
            if (NIOServerCnxn.this.zk == null) {
                this.pw.println(NIOServerCnxn.ZK_NOT_SERVING);
            } else {
                this.pw.println("SessionTracker dump:");
                ((NIOServerCnxn)NIOServerCnxn.this).zk.sessionTracker.dumpSessions(this.pw);
                this.pw.println("ephemeral nodes dump:");
                NIOServerCnxn.this.zk.dumpEphemerals(this.pw);
            }
        }
    }

    private class CnxnStatResetCommand
    extends CommandThread {
        public CnxnStatResetCommand(PrintWriter pw) {
            super(pw);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commandRun() {
            if (NIOServerCnxn.this.zk == null) {
                this.pw.println(NIOServerCnxn.ZK_NOT_SERVING);
            } else {
                HashSet<NIOServerCnxn> hashSet = NIOServerCnxn.this.factory.cnxns;
                synchronized (hashSet) {
                    for (NIOServerCnxn c : NIOServerCnxn.this.factory.cnxns) {
                        c.getStats().reset();
                    }
                }
                this.pw.println("Connection stats reset.");
            }
        }
    }

    private class StatResetCommand
    extends CommandThread {
        public StatResetCommand(PrintWriter pw) {
            super(pw);
        }

        public void commandRun() {
            if (NIOServerCnxn.this.zk == null) {
                this.pw.println(NIOServerCnxn.ZK_NOT_SERVING);
            } else {
                NIOServerCnxn.this.zk.serverStats().reset();
                this.pw.println("Server stats reset.");
            }
        }
    }

    private class ConfCommand
    extends CommandThread {
        ConfCommand(PrintWriter pw) {
            super(pw);
        }

        public void commandRun() {
            if (NIOServerCnxn.this.zk == null) {
                this.pw.println(NIOServerCnxn.ZK_NOT_SERVING);
            } else {
                NIOServerCnxn.this.zk.dumpConf(this.pw);
            }
        }
    }

    private class EnvCommand
    extends CommandThread {
        EnvCommand(PrintWriter pw) {
            super(pw);
        }

        public void commandRun() {
            List<Environment.Entry> env = Environment.list();
            this.pw.println("Environment:");
            for (Environment.Entry e : env) {
                this.pw.print(e.getKey());
                this.pw.print("=");
                this.pw.println(e.getValue());
            }
        }
    }

    private class SetTraceMaskCommand
    extends CommandThread {
        long trace;

        SetTraceMaskCommand(PrintWriter pw, long trace) {
            super(pw);
            this.trace = 0L;
            this.trace = trace;
        }

        public void commandRun() {
            this.pw.print(this.trace);
        }
    }

    private class TraceMaskCommand
    extends CommandThread {
        TraceMaskCommand(PrintWriter pw) {
            super(pw);
        }

        public void commandRun() {
            long traceMask = ZooTrace.getTextTraceLevel();
            this.pw.print(traceMask);
        }
    }

    private class RuokCommand
    extends CommandThread {
        public RuokCommand(PrintWriter pw) {
            super(pw);
        }

        public void commandRun() {
            this.pw.print("imok");
        }
    }

    private abstract class CommandThread
    extends Thread {
        PrintWriter pw;

        CommandThread(PrintWriter pw) {
            this.pw = pw;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.commandRun();
            }
            catch (IOException ie) {
                LOG.error("Error in running command ", ie);
            }
            finally {
                NIOServerCnxn.this.cleanupWriterSocket(this.pw);
            }
        }

        public abstract void commandRun() throws IOException;
    }

    private class SendBufferWriter
    extends Writer {
        private StringBuffer sb = new StringBuffer();

        private SendBufferWriter() {
        }

        private void checkFlush(boolean force) {
            if (force && this.sb.length() > 0 || this.sb.length() > 2048) {
                NIOServerCnxn.this.sendBufferSync(ByteBuffer.wrap(this.sb.toString().getBytes()));
                this.sb.setLength(0);
            }
        }

        public void close() throws IOException {
            if (this.sb == null) {
                return;
            }
            this.checkFlush(true);
            this.sb = null;
        }

        public void flush() throws IOException {
            this.checkFlush(true);
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            this.sb.append(cbuf, off, len);
            this.checkFlush(false);
        }
    }

    private static class EndOfStreamException
    extends IOException {
        private static final long serialVersionUID = -8255690282104294178L;

        public EndOfStreamException(String msg) {
            super(msg);
        }

        public String toString() {
            return "EndOfStreamException: " + this.getMessage();
        }
    }

    private static class CloseRequestException
    extends IOException {
        private static final long serialVersionUID = -7854505709816442681L;

        public CloseRequestException(String msg) {
            super(msg);
        }
    }

    public static class Factory
    extends Thread {
        ZooKeeperServer zks;
        final ServerSocketChannel ss;
        final Selector selector = Selector.open();
        final ByteBuffer directBuffer = ByteBuffer.allocateDirect(65536);
        final HashSet<NIOServerCnxn> cnxns = new HashSet();
        final HashMap<InetAddress, Set<NIOServerCnxn>> ipMap = new HashMap();
        int outstandingLimit = 1;
        int maxClientCnxns = 10;

        public Factory(InetSocketAddress addr) throws IOException {
            this(addr, 0);
        }

        public Factory(InetSocketAddress addr, int maxcc) throws IOException {
            super("NIOServerCxn.Factory:" + addr);
            this.setDaemon(true);
            this.maxClientCnxns = maxcc;
            this.ss = ServerSocketChannel.open();
            this.ss.socket().setReuseAddress(true);
            LOG.info("binding to port " + addr);
            this.ss.socket().bind(addr);
            this.ss.configureBlocking(false);
            this.ss.register(this.selector, 16);
        }

        public void start() {
            if (this.getState() == Thread.State.NEW) {
                super.start();
            }
        }

        public void startup(ZooKeeperServer zks) throws IOException, InterruptedException {
            this.start();
            zks.startdata();
            zks.startup();
            this.setZooKeeperServer(zks);
        }

        public void setZooKeeperServer(ZooKeeperServer zks) {
            this.zks = zks;
            if (zks != null) {
                this.outstandingLimit = zks.getGlobalOutstandingLimit();
                zks.setServerCnxnFactory(this);
            } else {
                this.outstandingLimit = 1;
            }
        }

        public ZooKeeperServer getZooKeeperServer() {
            return this.zks;
        }

        public InetSocketAddress getLocalAddress() {
            return (InetSocketAddress)this.ss.socket().getLocalSocketAddress();
        }

        public int getLocalPort() {
            return this.ss.socket().getLocalPort();
        }

        public int getMaxClientCnxns() {
            return this.maxClientCnxns;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addCnxn(NIOServerCnxn cnxn) {
            HashSet<NIOServerCnxn> hashSet = this.cnxns;
            synchronized (hashSet) {
                this.cnxns.add(cnxn);
                HashMap<InetAddress, Set<NIOServerCnxn>> hashMap = this.ipMap;
                synchronized (hashMap) {
                    InetAddress addr = cnxn.sock.socket().getInetAddress();
                    Set<NIOServerCnxn> s = this.ipMap.get(addr);
                    if (s == null) {
                        s = new HashSet<NIOServerCnxn>(2);
                        s.add(cnxn);
                        this.ipMap.put(addr, s);
                    } else {
                        s.add(cnxn);
                    }
                }
            }
        }

        protected NIOServerCnxn createConnection(SocketChannel sock, SelectionKey sk) throws IOException {
            return new NIOServerCnxn(this.zks, sock, sk, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getClientCnxnCount(InetAddress cl) {
            HashMap<InetAddress, Set<NIOServerCnxn>> hashMap = this.ipMap;
            synchronized (hashMap) {
                Set<NIOServerCnxn> s = this.ipMap.get(cl);
                if (s == null) {
                    return 0;
                }
                return s.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.ss.socket().isClosed()) {
                try {
                    Set<SelectionKey> selected;
                    this.selector.select(1000L);
                    Factory factory = this;
                    synchronized (factory) {
                        selected = this.selector.selectedKeys();
                    }
                    ArrayList<SelectionKey> selectedList = new ArrayList<SelectionKey>(selected);
                    Collections.shuffle(selectedList);
                    for (SelectionKey k : selectedList) {
                        if ((k.readyOps() & 0x10) != 0) {
                            SocketChannel sc = ((ServerSocketChannel)k.channel()).accept();
                            InetAddress ia = sc.socket().getInetAddress();
                            int cnxncount = this.getClientCnxnCount(ia);
                            if (this.maxClientCnxns > 0 && cnxncount >= this.maxClientCnxns) {
                                LOG.warn("Too many connections from " + ia + " - max is " + this.maxClientCnxns);
                                sc.close();
                                continue;
                            }
                            LOG.info("Accepted socket connection from " + sc.socket().getRemoteSocketAddress());
                            sc.configureBlocking(false);
                            SelectionKey sk = sc.register(this.selector, 1);
                            NIOServerCnxn cnxn = this.createConnection(sc, sk);
                            sk.attach(cnxn);
                            this.addCnxn(cnxn);
                            continue;
                        }
                        if ((k.readyOps() & 5) != 0) {
                            NIOServerCnxn c = (NIOServerCnxn)k.attachment();
                            c.doIO(k);
                            continue;
                        }
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Unexpected ops in select " + k.readyOps());
                    }
                    selected.clear();
                }
                catch (RuntimeException e) {
                    LOG.warn("Ignoring unexpected runtime exception", e);
                }
                catch (Exception e) {
                    LOG.warn("Ignoring exception", e);
                }
            }
            this.clear();
            LOG.info("NIOServerCnxn factory exited run method");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void clear() {
            HashSet cnxns;
            this.selector.wakeup();
            HashSet<NIOServerCnxn> hashSet = this.cnxns;
            synchronized (hashSet) {
                cnxns = (HashSet)this.cnxns.clone();
            }
            for (NIOServerCnxn cnxn : cnxns) {
                try {
                    cnxn.close();
                }
                catch (Exception e) {
                    LOG.warn("Ignoring exception closing cnxn sessionid 0x" + Long.toHexString(cnxn.sessionId), e);
                }
            }
        }

        public void shutdown() {
            try {
                this.ss.close();
                this.clear();
                this.interrupt();
                this.join();
            }
            catch (InterruptedException e) {
                LOG.warn("Ignoring interrupted exception during shutdown", e);
            }
            catch (Exception e) {
                LOG.warn("Ignoring unexpected exception during shutdown", e);
            }
            try {
                this.selector.close();
            }
            catch (IOException e) {
                LOG.warn("Selector closing", e);
            }
            if (this.zks != null) {
                this.zks.shutdown();
            }
        }

        synchronized void closeSession(long sessionId) {
            this.selector.wakeup();
            this.closeSessionWithoutWakeup(sessionId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeSessionWithoutWakeup(long sessionId) {
            HashSet cnxns;
            HashSet<NIOServerCnxn> hashSet = this.cnxns;
            synchronized (hashSet) {
                cnxns = (HashSet)this.cnxns.clone();
            }
            for (NIOServerCnxn cnxn : cnxns) {
                if (cnxn.sessionId != sessionId) continue;
                try {
                    cnxn.close();
                }
                catch (Exception e) {
                    LOG.warn("exception during session close", e);
                }
                break;
            }
        }

        static {
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                public void uncaughtException(Thread t, Throwable e) {
                    LOG.error("Thread " + t + " died", e);
                }
            });
            try {
                Selector.open().close();
            }
            catch (IOException ie) {
                LOG.error("Selector failed to open", ie);
            }
        }
    }
}

