/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.jute.Record;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.common.PathUtils;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.data.StatPersisted;
import org.apache.zookeeper.proto.CreateRequest;
import org.apache.zookeeper.proto.DeleteRequest;
import org.apache.zookeeper.proto.SetACLRequest;
import org.apache.zookeeper.proto.SetDataRequest;
import org.apache.zookeeper.server.DataNode;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.ZooTrace;
import org.apache.zookeeper.server.auth.AuthenticationProvider;
import org.apache.zookeeper.server.auth.ProviderRegistry;
import org.apache.zookeeper.txn.CreateSessionTxn;
import org.apache.zookeeper.txn.CreateTxn;
import org.apache.zookeeper.txn.DeleteTxn;
import org.apache.zookeeper.txn.ErrorTxn;
import org.apache.zookeeper.txn.SetACLTxn;
import org.apache.zookeeper.txn.SetDataTxn;
import org.apache.zookeeper.txn.TxnHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrepRequestProcessor
extends Thread
implements RequestProcessor {
    private static final Logger LOG = Logger.getLogger(PrepRequestProcessor.class);
    static boolean skipACL = System.getProperty("zookeeper.skipACL", "no").equals("yes");
    private static boolean failCreate;
    LinkedBlockingQueue<Request> submittedRequests = new LinkedBlockingQueue();
    RequestProcessor nextProcessor;
    ZooKeeperServer zks;

    public PrepRequestProcessor(ZooKeeperServer zks, RequestProcessor nextProcessor) {
        super("ProcessThread:" + zks.getClientPort());
        this.nextProcessor = nextProcessor;
        this.zks = zks;
    }

    public static void setFailCreate(boolean b) {
        failCreate = b;
    }

    @Override
    public void run() {
        try {
            while (true) {
                Request request = this.submittedRequests.take();
                long traceMask = 2L;
                if (request.type == 11) {
                    traceMask = 8L;
                }
                if (LOG.isTraceEnabled()) {
                    ZooTrace.logRequest(LOG, traceMask, 'P', request, "");
                }
                if (Request.requestOfDeath != request) {
                    this.pRequest(request);
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            LOG.error("Unexpected interruption", e);
        }
        LOG.info("PrepRequestProcessor exited loop!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ZooKeeperServer.ChangeRecord getRecordForPath(String path) throws KeeperException.NoNodeException {
        ZooKeeperServer.ChangeRecord lastChange = null;
        List<ZooKeeperServer.ChangeRecord> list = this.zks.outstandingChanges;
        synchronized (list) {
            DataNode n;
            lastChange = this.zks.outstandingChangesForPath.get(path);
            if (lastChange == null && (n = this.zks.getZKDatabase().getNode(path)) != null) {
                Set<String> children;
                Long acl;
                DataNode dataNode = n;
                synchronized (dataNode) {
                    acl = n.acl;
                    children = n.getChildren();
                }
                lastChange = new ZooKeeperServer.ChangeRecord(-1L, path, n.stat, children != null ? children.size() : 0, this.zks.getZKDatabase().convertLong(acl));
            }
        }
        if (lastChange == null || lastChange.stat == null) {
            throw new KeeperException.NoNodeException(path);
        }
        return lastChange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChangeRecord(ZooKeeperServer.ChangeRecord c) {
        List<ZooKeeperServer.ChangeRecord> list = this.zks.outstandingChanges;
        synchronized (list) {
            this.zks.outstandingChanges.add(c);
            this.zks.outstandingChangesForPath.put(c.path, c);
        }
    }

    static void checkACL(ZooKeeperServer zks, List<ACL> acl, int perm, List<Id> ids) throws KeeperException.NoAuthException {
        if (skipACL) {
            return;
        }
        if (acl == null || acl.size() == 0) {
            return;
        }
        for (Id authId : ids) {
            if (!authId.getScheme().equals("super")) continue;
            return;
        }
        for (ACL a : acl) {
            Id id = a.getId();
            if ((a.getPerms() & perm) == 0) continue;
            if (id.getScheme().equals("world") && id.getId().equals("anyone")) {
                return;
            }
            AuthenticationProvider ap = ProviderRegistry.getProvider(id.getScheme());
            if (ap == null) continue;
            for (Id authId : ids) {
                if (!authId.getScheme().equals(id.getScheme()) || !ap.matches(authId.getId(), id.getId())) continue;
                return;
            }
        }
        throw new KeeperException.NoAuthException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pRequest(Request request) {
        Record txn;
        TxnHeader txnHeader;
        block38: {
            txnHeader = null;
            txn = null;
            try {
                switch (request.type) {
                    case 1: {
                        boolean ephemeralParent;
                        txnHeader = new TxnHeader(request.sessionId, request.cxid, this.zks.getNextZxid(), this.zks.getTime(), 1);
                        this.zks.sessionTracker.checkSession(request.sessionId, request.getOwner());
                        CreateRequest createRequest = new CreateRequest();
                        ZooKeeperServer.byteBuffer2Record(request.request, createRequest);
                        String path = createRequest.getPath();
                        int lastSlash = path.lastIndexOf(47);
                        if (lastSlash == -1 || path.indexOf(0) != -1 || failCreate) {
                            LOG.info("Invalid path " + path + " with session 0x" + Long.toHexString(request.sessionId));
                            throw new KeeperException.BadArgumentsException(path);
                        }
                        if (!this.fixupACL(request.authInfo, createRequest.getAcl())) {
                            throw new KeeperException.InvalidACLException(path);
                        }
                        String parentPath = path.substring(0, lastSlash);
                        ZooKeeperServer.ChangeRecord parentRecord = this.getRecordForPath(parentPath);
                        PrepRequestProcessor.checkACL(this.zks, parentRecord.acl, 4, request.authInfo);
                        int parentCVersion = parentRecord.stat.getCversion();
                        CreateMode createMode = CreateMode.fromFlag(createRequest.getFlags());
                        if (createMode.isSequential()) {
                            path = path + String.format("%010d", parentCVersion);
                        }
                        try {
                            PathUtils.validatePath(path);
                        }
                        catch (IllegalArgumentException ie) {
                            LOG.info("Invalid path " + path + " with session 0x" + Long.toHexString(request.sessionId));
                            throw new KeeperException.BadArgumentsException(path);
                        }
                        try {
                            if (this.getRecordForPath(path) != null) {
                                throw new KeeperException.NodeExistsException(path);
                            }
                        }
                        catch (KeeperException.NoNodeException e) {
                            // empty catch block
                        }
                        boolean bl = ephemeralParent = parentRecord.stat.getEphemeralOwner() != 0L;
                        if (ephemeralParent) {
                            throw new KeeperException.NoChildrenForEphemeralsException(path);
                        }
                        txn = new CreateTxn(path, createRequest.getData(), createRequest.getAcl(), createMode.isEphemeral());
                        StatPersisted s = new StatPersisted();
                        if (createMode.isEphemeral()) {
                            s.setEphemeralOwner(request.sessionId);
                        }
                        parentRecord = parentRecord.duplicate(txnHeader.getZxid());
                        ++parentRecord.childCount;
                        parentRecord.stat.setCversion(parentRecord.stat.getCversion() + 1);
                        this.addChangeRecord(parentRecord);
                        this.addChangeRecord(new ZooKeeperServer.ChangeRecord(txnHeader.getZxid(), path, s, 0, createRequest.getAcl()));
                        break;
                    }
                    case 2: {
                        txnHeader = new TxnHeader(request.sessionId, request.cxid, this.zks.getNextZxid(), this.zks.getTime(), 2);
                        this.zks.sessionTracker.checkSession(request.sessionId, request.getOwner());
                        DeleteRequest deleteRequest = new DeleteRequest();
                        ZooKeeperServer.byteBuffer2Record(request.request, deleteRequest);
                        String path = deleteRequest.getPath();
                        int lastSlash = path.lastIndexOf(47);
                        if (lastSlash == -1 || path.indexOf(0) != -1 || this.zks.getZKDatabase().isSpecialPath(path)) {
                            throw new KeeperException.BadArgumentsException(path);
                        }
                        String parentPath = path.substring(0, lastSlash);
                        ZooKeeperServer.ChangeRecord parentRecord = this.getRecordForPath(parentPath);
                        ZooKeeperServer.ChangeRecord nodeRecord = this.getRecordForPath(path);
                        PrepRequestProcessor.checkACL(this.zks, parentRecord.acl, 8, request.authInfo);
                        int version = deleteRequest.getVersion();
                        if (version != -1 && nodeRecord.stat.getVersion() != version) {
                            throw new KeeperException.BadVersionException(path);
                        }
                        if (nodeRecord.childCount > 0) {
                            throw new KeeperException.NotEmptyException(path);
                        }
                        txn = new DeleteTxn(path);
                        parentRecord = parentRecord.duplicate(txnHeader.getZxid());
                        --parentRecord.childCount;
                        parentRecord.stat.setCversion(parentRecord.stat.getCversion() + 1);
                        this.addChangeRecord(parentRecord);
                        this.addChangeRecord(new ZooKeeperServer.ChangeRecord(txnHeader.getZxid(), path, null, -1, null));
                        break;
                    }
                    case 5: {
                        txnHeader = new TxnHeader(request.sessionId, request.cxid, this.zks.getNextZxid(), this.zks.getTime(), 5);
                        this.zks.sessionTracker.checkSession(request.sessionId, request.getOwner());
                        SetDataRequest setDataRequest = new SetDataRequest();
                        ZooKeeperServer.byteBuffer2Record(request.request, setDataRequest);
                        String path = setDataRequest.getPath();
                        ZooKeeperServer.ChangeRecord nodeRecord = this.getRecordForPath(path);
                        PrepRequestProcessor.checkACL(this.zks, nodeRecord.acl, 2, request.authInfo);
                        int version = setDataRequest.getVersion();
                        int currentVersion = nodeRecord.stat.getVersion();
                        if (version != -1 && version != currentVersion) {
                            throw new KeeperException.BadVersionException(path);
                        }
                        version = currentVersion + 1;
                        txn = new SetDataTxn(path, setDataRequest.getData(), version);
                        nodeRecord = nodeRecord.duplicate(txnHeader.getZxid());
                        nodeRecord.stat.setVersion(version);
                        this.addChangeRecord(nodeRecord);
                        break;
                    }
                    case 7: {
                        txnHeader = new TxnHeader(request.sessionId, request.cxid, this.zks.getNextZxid(), this.zks.getTime(), 7);
                        this.zks.sessionTracker.checkSession(request.sessionId, request.getOwner());
                        SetACLRequest setAclRequest = new SetACLRequest();
                        ZooKeeperServer.byteBuffer2Record(request.request, setAclRequest);
                        String path = setAclRequest.getPath();
                        if (!this.fixupACL(request.authInfo, setAclRequest.getAcl())) {
                            throw new KeeperException.InvalidACLException(path);
                        }
                        ZooKeeperServer.ChangeRecord nodeRecord = this.getRecordForPath(path);
                        PrepRequestProcessor.checkACL(this.zks, nodeRecord.acl, 16, request.authInfo);
                        int version = setAclRequest.getVersion();
                        int currentVersion = nodeRecord.stat.getAversion();
                        if (version != -1 && version != currentVersion) {
                            throw new KeeperException.BadVersionException(path);
                        }
                        version = currentVersion + 1;
                        txn = new SetACLTxn(path, setAclRequest.getAcl(), version);
                        nodeRecord = nodeRecord.duplicate(txnHeader.getZxid());
                        nodeRecord.stat.setAversion(version);
                        this.addChangeRecord(nodeRecord);
                        break;
                    }
                    case -10: {
                        txnHeader = new TxnHeader(request.sessionId, request.cxid, this.zks.getNextZxid(), this.zks.getTime(), -10);
                        request.request.rewind();
                        int to = request.request.getInt();
                        txn = new CreateSessionTxn(to);
                        request.request.rewind();
                        this.zks.sessionTracker.addSession(request.sessionId, to);
                        this.zks.setOwner(request.sessionId, request.getOwner());
                        break;
                    }
                    case -11: {
                        txnHeader = new TxnHeader(request.sessionId, request.cxid, this.zks.getNextZxid(), this.zks.getTime(), -11);
                        HashSet<String> es = this.zks.getZKDatabase().getEphemerals(request.sessionId);
                        List<ZooKeeperServer.ChangeRecord> list = this.zks.outstandingChanges;
                        synchronized (list) {
                            for (ZooKeeperServer.ChangeRecord c : this.zks.outstandingChanges) {
                                if (c.stat == null) {
                                    es.remove(c.path);
                                    continue;
                                }
                                if (c.stat.getEphemeralOwner() != request.sessionId) continue;
                                es.add(c.path);
                            }
                            for (String path2Delete : es) {
                                this.addChangeRecord(new ZooKeeperServer.ChangeRecord(txnHeader.getZxid(), path2Delete, null, 0, null));
                            }
                        }
                        LOG.info("Processed session termination for sessionid: 0x" + Long.toHexString(request.sessionId));
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 11: 
                    case 12: 
                    case 101: {
                        this.zks.sessionTracker.checkSession(request.sessionId, request.getOwner());
                    }
                }
            }
            catch (KeeperException e) {
                if (txnHeader != null) {
                    txnHeader.setType(-1);
                    txn = new ErrorTxn(e.code().intValue());
                }
                LOG.info("Got user-level KeeperException when processing " + request.toString() + " Error Path:" + e.getPath() + " Error:" + e.getMessage());
                request.setException(e);
            }
            catch (Exception e) {
                LOG.error("Failed to process " + request, e);
                StringBuilder sb = new StringBuilder();
                ByteBuffer bb = request.request;
                if (bb != null) {
                    bb.rewind();
                    while (bb.hasRemaining()) {
                        sb.append(Integer.toHexString(bb.get() & 0xFF));
                    }
                } else {
                    sb.append("request buffer is null");
                }
                LOG.error("Dumping request buffer: 0x" + sb.toString());
                if (txnHeader == null) break block38;
                txnHeader.setType(-1);
                txn = new ErrorTxn(KeeperException.Code.MARSHALLINGERROR.intValue());
            }
        }
        request.hdr = txnHeader;
        request.txn = txn;
        request.zxid = this.zks.getZxid();
        this.nextProcessor.processRequest(request);
    }

    private boolean fixupACL(List<Id> authInfo, List<ACL> acl) {
        if (skipACL) {
            return true;
        }
        if (acl == null || acl.size() == 0) {
            return false;
        }
        Iterator<ACL> it = acl.iterator();
        LinkedList<ACL> toAdd = null;
        while (it.hasNext()) {
            ACL a = it.next();
            Id id = a.getId();
            if (id.getScheme().equals("world") && id.getId().equals("anyone")) continue;
            if (id.getScheme().equals("auth")) {
                it.remove();
                if (toAdd == null) {
                    toAdd = new LinkedList<ACL>();
                }
                boolean authIdValid = false;
                for (Id cid : authInfo) {
                    AuthenticationProvider ap = ProviderRegistry.getProvider(cid.getScheme());
                    if (ap == null) {
                        LOG.error("Missing AuthenticationProvider for " + cid.getScheme());
                        continue;
                    }
                    if (!ap.isAuthenticated()) continue;
                    authIdValid = true;
                    toAdd.add(new ACL(a.getPerms(), cid));
                }
                if (authIdValid) continue;
                return false;
            }
            AuthenticationProvider ap = ProviderRegistry.getProvider(id.getScheme());
            if (ap == null) {
                return false;
            }
            if (ap.isValid(id.getId())) continue;
            return false;
        }
        if (toAdd != null) {
            for (ACL a : toAdd) {
                acl.add(a);
            }
        }
        return acl.size() > 0;
    }

    @Override
    public void processRequest(Request request) {
        this.submittedRequests.add(request);
    }

    @Override
    public void shutdown() {
        this.submittedRequests.clear();
        this.submittedRequests.add(Request.requestOfDeath);
        this.nextProcessor.shutdown();
    }

    static {
        if (skipACL) {
            LOG.info("zookeeper.skipACL==\"yes\", ACL checks will be skipped");
        }
        failCreate = false;
    }
}

