/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.File;
import java.util.List;
import junit.framework.TestCase;
import org.apache.zookeeper.server.persistence.FileTxnLog;
import org.apache.zookeeper.server.persistence.Util;
import org.junit.Test;

public class ZooKeeperServerTest
extends TestCase {
    @Test
    public void testSortDataDirAscending() {
        File[] files = new File[]{new File("foo.10027c6de"), new File("foo.10027c6df"), new File("bar.10027c6dd"), new File("foo.10027c6dc"), new File("foo.20027c6dc")};
        File[] orig = (File[])files.clone();
        List<File> filelist = Util.sortDataDir(files, "foo", true);
        ZooKeeperServerTest.assertEquals((Object)orig[2], (Object)filelist.get(0));
        ZooKeeperServerTest.assertEquals((Object)orig[3], (Object)filelist.get(1));
        ZooKeeperServerTest.assertEquals((Object)orig[0], (Object)filelist.get(2));
        ZooKeeperServerTest.assertEquals((Object)orig[1], (Object)filelist.get(3));
        ZooKeeperServerTest.assertEquals((Object)orig[4], (Object)filelist.get(4));
    }

    @Test
    public void testSortDataDirDescending() {
        File[] files = new File[]{new File("foo.10027c6de"), new File("foo.10027c6df"), new File("bar.10027c6dd"), new File("foo.10027c6dc"), new File("foo.20027c6dc")};
        File[] orig = (File[])files.clone();
        List<File> filelist = Util.sortDataDir(files, "foo", false);
        ZooKeeperServerTest.assertEquals((Object)orig[4], (Object)filelist.get(0));
        ZooKeeperServerTest.assertEquals((Object)orig[1], (Object)filelist.get(1));
        ZooKeeperServerTest.assertEquals((Object)orig[0], (Object)filelist.get(2));
        ZooKeeperServerTest.assertEquals((Object)orig[3], (Object)filelist.get(3));
        ZooKeeperServerTest.assertEquals((Object)orig[2], (Object)filelist.get(4));
    }

    @Test
    public void testGetLogFiles() {
        File[] files = new File[]{new File("log.10027c6de"), new File("log.10027c6df"), new File("snapshot.10027c6dd"), new File("log.10027c6dc"), new File("log.20027c6dc")};
        File[] orig = (File[])files.clone();
        File[] filelist = FileTxnLog.getLogFiles(files, Long.parseLong("10027c6de", 16));
        ZooKeeperServerTest.assertEquals((int)3, (int)filelist.length);
        ZooKeeperServerTest.assertEquals((Object)orig[0], (Object)filelist[0]);
        ZooKeeperServerTest.assertEquals((Object)orig[1], (Object)filelist[1]);
        ZooKeeperServerTest.assertEquals((Object)orig[4], (Object)filelist[2]);
    }
}

