/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.server.quorum.QuorumPeerMain;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.QuorumBase;

public class QuorumPeerTestBase
extends TestCase
implements Watcher {
    protected static final Logger LOG = Logger.getLogger(QuorumPeerTestBase.class);

    public void process(WatchedEvent event) {
    }

    public static class MainThread
    extends Thread {
        final File confFile;
        final TestQPMain main;

        public MainThread(int myid, int clientPort, String quorumCfgSection) throws IOException {
            super("QuorumPeer with myid:" + myid + " and clientPort:" + clientPort);
            File tmpDir = ClientBase.createTmpDir();
            this.confFile = new File(tmpDir, "zoo.cfg");
            FileWriter fwriter = new FileWriter(this.confFile);
            fwriter.write("tickTime=2000\n");
            fwriter.write("initLimit=10\n");
            fwriter.write("syncLimit=5\n");
            File dataDir = new File(tmpDir, "data");
            if (!dataDir.mkdir()) {
                throw new IOException("Unable to mkdir " + dataDir);
            }
            String dir = dataDir.toString();
            String osname = System.getProperty("os.name");
            if (osname.toLowerCase().contains("windows")) {
                dir = dir.replace('\\', '/');
            }
            fwriter.write("dataDir=" + dir + "\n");
            fwriter.write("clientPort=" + clientPort + "\n");
            fwriter.write(quorumCfgSection + "\n");
            fwriter.flush();
            fwriter.close();
            File myidFile = new File(dataDir, "myid");
            fwriter = new FileWriter(myidFile);
            fwriter.write(Integer.toString(myid));
            fwriter.flush();
            fwriter.close();
            this.main = new TestQPMain();
        }

        public void run() {
            String[] args = new String[]{this.confFile.toString()};
            try {
                this.main.initializeAndRun(args);
            }
            catch (Exception e) {
                LOG.error("unexpected exception in run", e);
            }
        }

        public void shutdown() {
            this.main.shutdown();
        }
    }

    public static class TestQPMain
    extends QuorumPeerMain {
        public void shutdown() {
            if (this.quorumPeer != null) {
                QuorumBase.shutdown(this.quorumPeer);
            }
        }
    }
}

