/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.JMXEnv;
import org.apache.zookeeper.test.QuorumBase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class AsyncTest
extends TestCase
implements AsyncCallback.StringCallback,
AsyncCallback.VoidCallback,
AsyncCallback.DataCallback {
    private static final Logger LOG = Logger.getLogger(AsyncTest.class);
    private QuorumBase qb = new QuorumBase();
    LinkedList<Integer> results = new LinkedList();

    @Before
    protected void setUp() throws Exception {
        LOG.info("STARTING " + this.getName());
        this.qb.setUp();
    }

    protected void restart() throws Exception {
        JMXEnv.setUp();
        this.qb.startServers();
    }

    @After
    protected void tearDown() throws Exception {
        LOG.info("Test clients shutting down");
        this.qb.tearDown();
        LOG.info("FINISHED " + this.getName());
    }

    private ZooKeeper createClient() throws IOException, InterruptedException {
        return this.createClient(this.qb.hostPort);
    }

    private ZooKeeper createClient(String hp) throws IOException, InterruptedException {
        CountdownWatcher watcher = new CountdownWatcher();
        ZooKeeper zk = new ZooKeeper(hp, ClientBase.CONNECTION_TIMEOUT, watcher);
        if (!watcher.clientConnected.await(ClientBase.CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS)) {
            AsyncTest.fail((String)"Unable to connect to server");
        }
        return zk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsync() throws IOException, InterruptedException, KeeperException {
        ZooKeeper zk = null;
        zk = this.createClient();
        try {
            zk.addAuthInfo("digest", "ben:passwd".getBytes());
            zk.create("/ben", new byte[0], ZooDefs.Ids.READ_ACL_UNSAFE, CreateMode.PERSISTENT, this, this.results);
            zk.create("/ben/2", new byte[0], ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT, this, this.results);
            zk.delete("/ben", -1, this, this.results);
            zk.create("/ben2", new byte[0], ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT, this, this.results);
            zk.getData("/ben2", false, (AsyncCallback.DataCallback)this, this.results);
            LinkedList<Integer> linkedList = this.results;
            synchronized (linkedList) {
                while (this.results.size() < 5) {
                    this.results.wait();
                }
            }
            AsyncTest.assertEquals((int)0, (int)this.results.get(0));
            AsyncTest.assertEquals((Object)KeeperException.Code.NOAUTH, (Object)KeeperException.Code.get(this.results.get(1)));
            AsyncTest.assertEquals((int)0, (int)this.results.get(2));
            AsyncTest.assertEquals((int)0, (int)this.results.get(3));
            AsyncTest.assertEquals((int)0, (int)this.results.get(4));
        }
        finally {
            zk.close();
        }
        zk = this.createClient();
        try {
            zk.addAuthInfo("digest", "ben:passwd2".getBytes());
            try {
                zk.getData("/ben2", false, new Stat());
                AsyncTest.fail((String)"Should have received a permission error");
            }
            catch (KeeperException e) {
                AsyncTest.assertEquals((Object)KeeperException.Code.NOAUTH, (Object)e.code());
            }
        }
        finally {
            zk.close();
        }
        zk = this.createClient();
        try {
            zk.addAuthInfo("digest", "ben:passwd".getBytes());
            zk.getData("/ben2", false, new Stat());
        }
        finally {
            zk.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResult(int rc, String path, Object ctx, String name) {
        Object object = ctx;
        synchronized (object) {
            ((LinkedList)ctx).add(rc);
            ctx.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResult(int rc, String path, Object ctx) {
        Object object = ctx;
        synchronized (object) {
            ((LinkedList)ctx).add(rc);
            ctx.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
        Object object = ctx;
        synchronized (object) {
            ((LinkedList)ctx).add(rc);
            ctx.notifyAll();
        }
    }

    private static class CountdownWatcher
    implements Watcher {
        volatile CountDownLatch clientConnected = new CountDownLatch(1);

        private CountdownWatcher() {
        }

        public void process(WatchedEvent event) {
            if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                this.clientConnected.countDown();
            }
        }
    }
}

