/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import com.sun.management.UnixOperatingSystemMXBean;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.management.MBeanServerConnection;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.NIOServerCnxn;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnLog;
import org.apache.zookeeper.test.JMXEnv;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClientBase
extends TestCase {
    protected static final Logger LOG = Logger.getLogger(ClientBase.class);
    public static int CONNECTION_TIMEOUT = 30000;
    static final File BASETEST = new File(System.getProperty("build.test.dir", "build"));
    protected String hostPort = "127.0.0.1:" + PortAssignment.unique();
    protected int maxCnxns = 0;
    protected NIOServerCnxn.Factory serverFactory = null;
    protected File tmpDir = null;
    private LinkedList<ZooKeeper> allClients;
    private boolean allClientsSetup = false;

    protected TestableZooKeeper createClient() throws IOException, InterruptedException {
        return this.createClient(this.hostPort);
    }

    protected TestableZooKeeper createClient(String hp) throws IOException, InterruptedException {
        CountdownWatcher watcher = new CountdownWatcher();
        return this.createClient(watcher, hp);
    }

    protected TestableZooKeeper createClient(CountdownWatcher watcher, String hp) throws IOException, InterruptedException {
        return this.createClient(watcher, hp, CONNECTION_TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TestableZooKeeper createClient(CountdownWatcher watcher, String hp, int timeout) throws IOException, InterruptedException {
        watcher.reset();
        TestableZooKeeper zk = new TestableZooKeeper(hp, timeout, watcher);
        if (!watcher.clientConnected.await(timeout, TimeUnit.MILLISECONDS)) {
            ClientBase.fail((String)"Unable to connect to server");
        }
        ClientBase clientBase = this;
        synchronized (clientBase) {
            if (!this.allClientsSetup) {
                LOG.error("allClients never setup");
                ClientBase.fail((String)"allClients never setup");
            }
            if (this.allClients != null) {
                this.allClients.add(zk);
            } else {
                zk.close();
            }
        }
        JMXEnv.ensureAll("0x" + Long.toHexString(zk.getSessionId()));
        return zk;
    }

    public static List<HostPort> parseHostPortList(String hplist) {
        ArrayList<HostPort> alist = new ArrayList<HostPort>();
        for (String hp : hplist.split(",")) {
            int port;
            int idx = hp.lastIndexOf(58);
            String host = hp.substring(0, idx);
            try {
                port = Integer.parseInt(hp.substring(idx + 1));
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Problem parsing " + hp + e.toString());
            }
            alist.add(new HostPort(host, port));
        }
        return alist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String send4LetterWord(String host, int port, String cmd) throws IOException {
        LOG.info("connecting to " + host + " " + port);
        Socket sock = new Socket(host, port);
        BufferedReader reader = null;
        try {
            String line;
            OutputStream outstream = sock.getOutputStream();
            outstream.write(cmd.getBytes());
            outstream.flush();
            sock.shutdownOutput();
            reader = new BufferedReader(new InputStreamReader(sock.getInputStream()));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
            String string = sb.toString();
            return string;
        }
        finally {
            sock.close();
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static boolean waitForServerUp(String hp, long timeout) {
        long start = System.currentTimeMillis();
        while (true) {
            try {
                HostPort hpobj = ClientBase.parseHostPortList(hp).get(0);
                String result = ClientBase.send4LetterWord(hpobj.host, hpobj.port, "stat");
                if (result.startsWith("Zookeeper version:")) {
                    return true;
                }
            }
            catch (IOException e) {
                LOG.info("server " + hp + " not up " + e);
            }
            if (System.currentTimeMillis() > start + timeout) break;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {}
        }
        return false;
    }

    public static boolean waitForServerDown(String hp, long timeout) {
        long start = System.currentTimeMillis();
        while (true) {
            try {
                HostPort hpobj = ClientBase.parseHostPortList(hp).get(0);
                ClientBase.send4LetterWord(hpobj.host, hpobj.port, "stat");
            }
            catch (IOException e) {
                return true;
            }
            if (System.currentTimeMillis() > start + timeout) break;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {}
        }
        return false;
    }

    static void verifyThreadTerminated(Thread thread, long millis) throws InterruptedException {
        thread.join(millis);
        if (thread.isAlive()) {
            LOG.error("Thread " + thread.getName() + " : " + Arrays.toString(thread.getStackTrace()));
            ClientBase.assertFalse((String)("thread " + thread.getName() + " still alive after join"), (boolean)true);
        }
    }

    public static File createTmpDir() throws IOException {
        return ClientBase.createTmpDir(BASETEST);
    }

    static File createTmpDir(File parentDir) throws IOException {
        File tmpFile = File.createTempFile("test", ".junit", parentDir);
        File tmpDir = new File(tmpFile + ".dir");
        ClientBase.assertFalse((boolean)tmpDir.exists());
        ClientBase.assertTrue((boolean)tmpDir.mkdirs());
        return tmpDir;
    }

    private static int getPort(String hostPort) {
        String[] split = hostPort.split(":");
        String portstr = split[split.length - 1];
        String[] pc = portstr.split("/");
        if (pc.length > 1) {
            portstr = pc[0];
        }
        return Integer.parseInt(portstr);
    }

    static NIOServerCnxn.Factory createNewServerInstance(File dataDir, NIOServerCnxn.Factory factory, String hostPort, int maxCnxns) throws IOException, InterruptedException {
        ZooKeeperServer zks = new ZooKeeperServer(dataDir, dataDir, 3000);
        int PORT = ClientBase.getPort(hostPort);
        if (factory == null) {
            factory = new NIOServerCnxn.Factory(new InetSocketAddress(PORT), maxCnxns);
        }
        factory.startup(zks);
        ClientBase.assertTrue((String)"waiting for server up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + PORT, CONNECTION_TIMEOUT));
        return factory;
    }

    static void shutdownServerInstance(NIOServerCnxn.Factory factory, String hostPort) {
        if (factory != null) {
            ZKDatabase zkDb = factory.getZooKeeperServer().getZKDatabase();
            factory.shutdown();
            try {
                zkDb.close();
            }
            catch (IOException ie) {
                LOG.warn("Error closing logs ", ie);
            }
            int PORT = ClientBase.getPort(hostPort);
            ClientBase.assertTrue((String)"waiting for server down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + PORT, CONNECTION_TIMEOUT));
        }
    }

    public static void setupTestEnv() {
        System.setProperty("zookeeper.preAllocSize", "100");
        FileTxnLog.setPreallocSize(102400L);
    }

    protected void setUpAll() throws Exception {
        this.allClients = new LinkedList();
        this.allClientsSetup = true;
    }

    protected void setUp() throws Exception {
        LOG.info("STARTING " + this.getName());
        ClientBase.setupTestEnv();
        JMXEnv.setUp();
        this.setUpAll();
        this.tmpDir = ClientBase.createTmpDir(BASETEST);
        this.startServer();
        OperatingSystemMXBean osMbean = ManagementFactory.getOperatingSystemMXBean();
        if (osMbean != null && osMbean instanceof UnixOperatingSystemMXBean) {
            UnixOperatingSystemMXBean unixos = (UnixOperatingSystemMXBean)osMbean;
            LOG.info("Initial fdcount is: " + unixos.getOpenFileDescriptorCount());
        }
        LOG.info("Client test setup finished");
    }

    protected void startServer() throws Exception {
        LOG.info("STARTING server");
        this.serverFactory = ClientBase.createNewServerInstance(this.tmpDir, this.serverFactory, this.hostPort, this.maxCnxns);
        JMXEnv.ensureOnly("InMemoryDataTree", "StandaloneServer_port");
    }

    protected void stopServer() throws Exception {
        LOG.info("STOPPING server");
        ClientBase.shutdownServerInstance(this.serverFactory, this.hostPort);
        this.serverFactory = null;
        JMXEnv.ensureOnly(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDownAll() throws Exception {
        ClientBase clientBase = this;
        synchronized (clientBase) {
            for (ZooKeeper zk : this.allClients) {
                try {
                    if (zk == null) continue;
                    zk.close();
                }
                catch (InterruptedException e) {
                    LOG.warn("ignoring interrupt", e);
                }
            }
            this.allClients = null;
        }
    }

    protected void tearDown() throws Exception {
        LOG.info("tearDown starting");
        OperatingSystemMXBean osMbean = ManagementFactory.getOperatingSystemMXBean();
        if (osMbean != null && osMbean instanceof UnixOperatingSystemMXBean) {
            UnixOperatingSystemMXBean unixos = (UnixOperatingSystemMXBean)osMbean;
            LOG.info("fdcount after test is: " + unixos.getOpenFileDescriptorCount());
        }
        this.tearDownAll();
        this.stopServer();
        if (this.tmpDir != null) {
            ClientBase.assertTrue((String)("delete " + this.tmpDir.toString()), (boolean)ClientBase.recursiveDelete(this.tmpDir));
        }
        this.serverFactory = null;
        JMXEnv.tearDown();
        LOG.info("FINISHED " + this.getName());
    }

    public static MBeanServerConnection jmxConn() throws IOException {
        return JMXEnv.conn();
    }

    public static boolean recursiveDelete(File d) {
        if (d.isDirectory()) {
            File[] children;
            for (File f : children = d.listFiles()) {
                ClientBase.assertTrue((String)("delete " + f.toString()), (boolean)ClientBase.recursiveDelete(f));
            }
        }
        return d.delete();
    }

    private static void logAllStackTraces() {
        StringBuilder sb = new StringBuilder();
        sb.append("Starting logAllStackTraces()\n");
        Map<Thread, StackTraceElement[]> threads = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> e : threads.entrySet()) {
            sb.append("Thread " + e.getKey().getName() + "\n");
            for (StackTraceElement elem : e.getValue()) {
                sb.append("\tat " + elem + "\n");
            }
        }
        sb.append("Ending logAllStackTraces()\n");
        LOG.error(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void verifyRootOfAllServersMatch(String hostPort) throws InterruptedException, KeeperException, IOException {
        String[] parts = hostPort.split(",");
        int[] counts = new int[parts.length];
        int failed = 0;
        for (int j = 0; j < 100; ++j) {
            int[] newcounts = new int[parts.length];
            int i = 0;
            for (String hp : parts) {
                try {
                    TestableZooKeeper zk = this.createClient(hp);
                    try {
                        newcounts[i++] = zk.getChildren("/", false).size();
                    }
                    finally {
                        zk.close();
                    }
                }
                catch (Throwable t) {
                    ++failed;
                    ClientBase.logAllStackTraces();
                }
            }
            if (Arrays.equals(newcounts, counts)) {
                LOG.info("Found match with array:" + Arrays.toString(newcounts));
                counts = newcounts;
                break;
            }
            counts = newcounts;
            Thread.sleep(10000L);
            if (failed > 10) break;
        }
        for (int i = 1; i < parts.length; ++i) {
            ClientBase.assertEquals((String)"node count not consistent", (int)counts[i - 1], (int)counts[i]);
        }
    }

    public static class HostPort {
        String host;
        int port;

        public HostPort(String host, int port) {
            this.host = host;
            this.port = port;
        }
    }

    protected static class CountdownWatcher
    implements Watcher {
        volatile CountDownLatch clientConnected;
        volatile boolean connected;

        public CountdownWatcher() {
            this.reset();
        }

        public synchronized void reset() {
            this.clientConnected = new CountDownLatch(1);
            this.connected = false;
        }

        public synchronized void process(WatchedEvent event) {
            if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                this.connected = true;
                this.notifyAll();
                this.clientConnected.countDown();
            } else {
                this.connected = false;
                this.notifyAll();
            }
        }

        synchronized boolean isConnected() {
            return this.connected;
        }

        synchronized void waitForConnected(long timeout) throws InterruptedException, TimeoutException {
            long expire = System.currentTimeMillis() + timeout;
            long left = timeout;
            while (!this.connected && left > 0L) {
                this.wait(left);
                left = expire - System.currentTimeMillis();
            }
            if (!this.connected) {
                throw new TimeoutException("Did not connect");
            }
        }

        synchronized void waitForDisconnected(long timeout) throws InterruptedException, TimeoutException {
            long expire = System.currentTimeMillis() + timeout;
            long left = timeout;
            while (this.connected && left > 0L) {
                this.wait(left);
                left = expire - System.currentTimeMillis();
            }
            if (this.connected) {
                throw new TimeoutException("Did not disconnect");
            }
        }
    }

    protected class NullWatcher
    implements Watcher {
        protected NullWatcher() {
        }

        public void process(WatchedEvent event) {
        }
    }
}

