/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.NIOServerCnxn;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Test;

public class ClientPortBindTest
extends TestCase
implements Watcher {
    protected static final Logger LOG = Logger.getLogger(ClientPortBindTest.class);
    private volatile CountDownLatch startSignal;

    protected void setUp() throws Exception {
        LOG.info("STARTING " + this.getName());
    }

    protected void tearDown() throws Exception {
        LOG.info("FINISHED " + this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBindByAddress() throws Exception {
        String bindAddress = null;
        Enumeration<NetworkInterface> intfs = NetworkInterface.getNetworkInterfaces();
        while (intfs.hasMoreElements()) {
            Enumeration<InetAddress> addrs;
            NetworkInterface i = intfs.nextElement();
            if (!i.isLoopback() || !(addrs = i.getInetAddresses()).hasMoreElements()) continue;
            bindAddress = addrs.nextElement().getHostAddress();
            bindAddress = bindAddress.split("%")[0];
        }
        if (bindAddress == null) {
            LOG.warn("Unable to determine loop back address, skipping test");
            return;
        }
        int PORT = PortAssignment.unique();
        LOG.info("Using " + bindAddress + " as the bind address");
        String HOSTPORT = bindAddress + ":" + PORT;
        LOG.info("Using " + HOSTPORT + " as the host/port");
        File tmpDir = ClientBase.createTmpDir();
        ClientBase.setupTestEnv();
        ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        NIOServerCnxn.Factory f = new NIOServerCnxn.Factory(new InetSocketAddress(bindAddress, PORT));
        f.startup(zks);
        LOG.info("starting up the the server, waiting");
        ClientPortBindTest.assertTrue((String)"waiting for server up", (boolean)ClientBase.waitForServerUp(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
        this.startSignal = new CountDownLatch(1);
        ZooKeeper zk = new ZooKeeper(HOSTPORT, ClientBase.CONNECTION_TIMEOUT, this);
        try {
            this.startSignal.await(ClientBase.CONNECTION_TIMEOUT, TimeUnit.MILLISECONDS);
            ClientPortBindTest.assertTrue((String)"count == 0", (this.startSignal.getCount() == 0L ? 1 : 0) != 0);
            zk.close();
        }
        finally {
            f.shutdown();
            ClientPortBindTest.assertTrue((String)"waiting for server down", (boolean)ClientBase.waitForServerDown(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
        }
    }

    public void process(WatchedEvent event) {
        LOG.info("Event:" + (Object)((Object)event.getState()) + " " + (Object)((Object)event.getType()) + " " + event.getPath());
        if (event.getState() == Watcher.Event.KeeperState.SyncConnected && this.startSignal != null && this.startSignal.getCount() > 0L) {
            this.startSignal.countDown();
        }
    }
}

