/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.util.EnumSet;
import junit.framework.TestCase;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.junit.Test;

public class CreateModeTest
extends TestCase {
    @Test
    public void testBasicCreateMode() {
        CreateMode cm = CreateMode.PERSISTENT;
        CreateModeTest.assertEquals((int)cm.toFlag(), (int)0);
        CreateModeTest.assertFalse((boolean)cm.isEphemeral());
        CreateModeTest.assertFalse((boolean)cm.isSequential());
        cm = CreateMode.EPHEMERAL;
        CreateModeTest.assertEquals((int)cm.toFlag(), (int)1);
        CreateModeTest.assertTrue((boolean)cm.isEphemeral());
        CreateModeTest.assertFalse((boolean)cm.isSequential());
        cm = CreateMode.PERSISTENT_SEQUENTIAL;
        CreateModeTest.assertEquals((int)cm.toFlag(), (int)2);
        CreateModeTest.assertFalse((boolean)cm.isEphemeral());
        CreateModeTest.assertTrue((boolean)cm.isSequential());
        cm = CreateMode.EPHEMERAL_SEQUENTIAL;
        CreateModeTest.assertEquals((int)cm.toFlag(), (int)3);
        CreateModeTest.assertTrue((boolean)cm.isEphemeral());
        CreateModeTest.assertTrue((boolean)cm.isSequential());
    }

    @Test
    public void testFlagConversion() throws KeeperException {
        EnumSet<CreateMode> allModes = EnumSet.allOf(CreateMode.class);
        for (CreateMode cm : allModes) {
            CreateModeTest.assertEquals((Object)((Object)cm), (Object)((Object)CreateMode.fromFlag(cm.toFlag())));
        }
    }

    @Test
    public void testInvalidFlagConversion() throws KeeperException {
        CreateMode cm;
        try {
            cm = CreateMode.fromFlag(99);
            CreateModeTest.fail((String)"Shouldn't be able to convert 99 to a CreateMode.");
        }
        catch (KeeperException ke) {
            CreateModeTest.assertEquals((Object)KeeperException.Code.BADARGUMENTS, (Object)ke.code());
        }
        try {
            cm = CreateMode.fromFlag(-1);
            CreateModeTest.fail((String)"Shouldn't be able to convert -1 to a CreateMode.");
        }
        catch (KeeperException ke) {
            CreateModeTest.assertEquals((Object)KeeperException.Code.BADARGUMENTS, (Object)ke.code());
        }
    }
}

