/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.DataTree;
import org.junit.Test;

public class DataTreeTest
extends TestCase {
    protected static final Logger LOG = Logger.getLogger(DataTreeTest.class);
    private DataTree dt;

    public void setUp() throws Exception {
        LOG.info("STARTING " + this.getName());
        this.dt = new DataTree();
    }

    public void tearDown() throws Exception {
        this.dt = null;
        LOG.info("FINISHED " + this.getName());
    }

    @Test
    public void testRootWatchTriggered() throws Exception {
        class MyWatcher
        implements Watcher {
            boolean fired = false;

            MyWatcher() {
            }

            public void process(WatchedEvent event) {
                if (event.getPath().equals("/")) {
                    this.fired = true;
                }
            }
        }
        MyWatcher watcher = new MyWatcher();
        this.dt.getChildren("/", new Stat(), watcher);
        this.dt.createNode("/xyz", new byte[0], null, 0L, 1L, 1L);
        DataTreeTest.assertFalse((String)"Root node watch not triggered", (!watcher.fired ? 1 : 0) != 0);
    }
}

