/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.server.quorum.FastLeaderElection;
import org.apache.zookeeper.server.quorum.QuorumCnxManager;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.Vote;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Test;

public class FLELostMessageTest
extends TestCase {
    protected static final Logger LOG = Logger.getLogger(FLELostMessageTest.class);
    int count;
    HashMap<Long, QuorumPeer.QuorumServer> peers;
    File[] tmpdir;
    int[] port;
    QuorumCnxManager cnxManager;

    public void setUp() throws Exception {
        this.count = 3;
        this.peers = new HashMap(this.count);
        this.tmpdir = new File[this.count];
        this.port = new int[this.count];
        LOG.info("SetUp " + this.getName());
    }

    public void tearDown() throws Exception {
        this.cnxManager.halt();
        LOG.info("FINISHED " + this.getName());
    }

    @Test
    public void testLostMessage() throws Exception {
        FastLeaderElection[] le = new FastLeaderElection[this.count];
        LOG.info("TestLE: " + this.getName() + ", " + this.count);
        for (int i = 0; i < this.count; ++i) {
            int clientport = PortAssignment.unique();
            this.peers.put(Long.valueOf(i), new QuorumPeer.QuorumServer(i, new InetSocketAddress(clientport), new InetSocketAddress(PortAssignment.unique())));
            this.tmpdir[i] = ClientBase.createTmpDir();
            this.port[i] = clientport;
        }
        QuorumPeer peer = new QuorumPeer(this.peers, this.tmpdir[1], this.tmpdir[1], this.port[1], 3, 1L, 2, 2, 2);
        peer.startLeaderElection();
        LEThread thread = new LEThread(peer, 1);
        thread.start();
        this.mockServer();
        thread.join(5000L);
        if (thread.isAlive()) {
            FLELostMessageTest.fail((String)"Threads didn't join");
        }
    }

    ByteBuffer createMsg(int state, long leader, long zxid, long epoch) {
        byte[] requestBytes = new byte[28];
        ByteBuffer requestBuffer = ByteBuffer.wrap(requestBytes);
        requestBuffer.clear();
        requestBuffer.putInt(state);
        requestBuffer.putLong(leader);
        requestBuffer.putLong(zxid);
        requestBuffer.putLong(epoch);
        return requestBuffer;
    }

    void mockServer() throws InterruptedException, IOException {
        QuorumPeer peer = new QuorumPeer(this.peers, this.tmpdir[0], this.tmpdir[0], this.port[0], 3, 0L, 2, 2, 2);
        this.cnxManager = new QuorumCnxManager(peer);
        QuorumCnxManager.Listener listener = this.cnxManager.listener;
        if (listener != null) {
            listener.start();
        } else {
            LOG.error("Null listener when initializing cnx manager");
        }
        this.cnxManager.toSend(new Long(1L), this.createMsg(QuorumPeer.ServerState.LOOKING.ordinal(), 0L, 0L, 1L));
        this.cnxManager.recvQueue.take();
        this.cnxManager.toSend(new Long(1L), this.createMsg(QuorumPeer.ServerState.FOLLOWING.ordinal(), 1L, 0L, 1L));
    }

    class LEThread
    extends Thread {
        int i;
        QuorumPeer peer;

        LEThread(QuorumPeer peer, int i) {
            this.i = i;
            this.peer = peer;
            LOG.info("Constructor: " + this.getName());
        }

        public void run() {
            boolean flag = true;
            try {
                Vote v = null;
                this.peer.setPeerState(QuorumPeer.ServerState.LOOKING);
                LOG.info("Going to call leader election: " + this.i);
                v = this.peer.getElectionAlg().lookForLeader();
                if (v == null) {
                    Assert.fail((String)("Thread " + this.i + " got a null vote"));
                }
                this.peer.setCurrentVote(v);
                LOG.info("Finished election: " + this.i + ", " + v.id);
                Assert.assertTrue((String)"State is not leading.", (this.peer.getPeerState() == QuorumPeer.ServerState.LEADING ? 1 : 0) != 0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            LOG.info("Joining");
        }
    }
}

