/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.server.quorum.FastLeaderElection;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.Vote;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.QuorumBase;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FLETest
extends TestCase {
    protected static final Logger LOG = Logger.getLogger(FLETest.class);
    private LEThread leThread;
    int count;
    HashMap<Long, QuorumPeer.QuorumServer> peers;
    ArrayList<LEThread> threads;
    HashMap<Integer, HashSet<TestVote>> voteMap;
    File[] tmpdir;
    int[] port;
    int successCount;
    Object finalObj;
    volatile Vote[] votes;
    volatile boolean leaderDies;
    volatile long leader = -1L;
    Random rand = new Random();

    int countVotes(HashSet<TestVote> hs, long id) {
        int counter = 0;
        for (TestVote v : hs) {
            if (v.leader != id) continue;
            ++counter;
        }
        return counter;
    }

    public void setUp() throws Exception {
        this.count = 7;
        this.peers = new HashMap(this.count);
        this.threads = new ArrayList(this.count);
        this.voteMap = new HashMap();
        this.votes = new Vote[this.count];
        this.tmpdir = new File[this.count];
        this.port = new int[this.count];
        this.successCount = 0;
        this.finalObj = new Object();
        LOG.info("SetUp " + this.getName());
    }

    public void tearDown() throws Exception {
        for (int i = 0; i < this.threads.size(); ++i) {
            this.leThread = this.threads.get(i);
            QuorumBase.shutdown(this.leThread.peer);
        }
        LOG.info("FINISHED " + this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLE() throws Exception {
        Object peer;
        int i;
        FastLeaderElection[] le = new FastLeaderElection[this.count];
        boolean allowOneBadLeader = this.leaderDies = true;
        LOG.info("TestLE: " + this.getName() + ", " + this.count);
        for (i = 0; i < this.count; ++i) {
            this.peers.put(Long.valueOf(i), new QuorumPeer.QuorumServer(i, new InetSocketAddress(PortAssignment.unique()), new InetSocketAddress(PortAssignment.unique())));
            this.tmpdir[i] = ClientBase.createTmpDir();
            this.port[i] = PortAssignment.unique();
        }
        for (i = 0; i < le.length; ++i) {
            peer = new QuorumPeer(this.peers, this.tmpdir[i], this.tmpdir[i], this.port[i], 3, (long)i, 2, 2, 2);
            ((QuorumPeer)peer).startLeaderElection();
            LEThread thread = new LEThread((QuorumPeer)peer, i);
            thread.start();
            this.threads.add(thread);
        }
        LOG.info("Started threads " + this.getName());
        peer = this.finalObj;
        synchronized (peer) {
            for (int waitCounter = 0; this.successCount <= this.count / 2 && waitCounter < 50; ++waitCounter) {
                this.finalObj.wait(2000L);
            }
        }
        for (int i2 = 0; i2 < this.threads.size(); ++i2) {
            if (!this.threads.get(i2).isAlive()) continue;
            LOG.info("Threads didn't join: " + i2);
        }
        if (this.successCount <= this.count / 2) {
            FLETest.fail((String)"Fewer than a a majority has joined");
        }
        if (this.threads.get((int)this.leader).isAlive()) {
            FLETest.fail((String)("Leader hasn't joined: " + this.leader));
        }
    }

    class LEThread
    extends Thread {
        int i;
        QuorumPeer peer;

        LEThread(QuorumPeer peer, int i) {
            this.i = i;
            this.peer = peer;
            LOG.info("Constructor: " + this.getName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Vote v = null;
                while (true) {
                    HashSet<TestVote> hs;
                    HashMap<Integer, HashSet<TestVote>> hashMap;
                    Object object;
                    this.peer.setPeerState(QuorumPeer.ServerState.LOOKING);
                    LOG.info("Going to call leader election again.");
                    v = this.peer.getElectionAlg().lookForLeader();
                    if (v == null) {
                        LOG.info("Thread " + this.i + " got a null vote");
                        break;
                    }
                    this.peer.setCurrentVote(v);
                    LOG.info("Finished election: " + this.i + ", " + v.id);
                    FLETest.this.votes[this.i] = v;
                    int lc = (int)((FastLeaderElection)this.peer.getElectionAlg()).getLogicalClock();
                    if (v.id == (long)this.i) {
                        LOG.info("I'm the leader: " + this.i);
                        object = FLETest.this;
                        synchronized (object) {
                            if (FLETest.this.leaderDies) {
                                LOG.info("Leader " + this.i + " dying");
                                FLETest.this.leaderDies = false;
                                ((FastLeaderElection)this.peer.getElectionAlg()).shutdown();
                                FLETest.this.leader = -1L;
                                LOG.info("Leader " + this.i + " dead");
                                ((Object)((Object)FLETest.this)).notifyAll();
                                break;
                            }
                            hashMap = FLETest.this.voteMap;
                            synchronized (hashMap) {
                                if (FLETest.this.voteMap.get(lc) == null) {
                                    FLETest.this.voteMap.put(lc, new HashSet());
                                }
                                hs = FLETest.this.voteMap.get(lc);
                                hs.add(new TestVote(this.i, v.id));
                                if (FLETest.this.countVotes(hs, v.id) > FLETest.this.count / 2) {
                                    FLETest.this.leader = this.i;
                                    LOG.info("Got majority: " + this.i);
                                } else {
                                    FLETest.this.voteMap.wait(3000L);
                                    LOG.info("Notified or expired: " + this.i);
                                    hs = FLETest.this.voteMap.get(lc);
                                    if (FLETest.this.countVotes(hs, v.id) > FLETest.this.count / 2) {
                                        FLETest.this.leader = this.i;
                                        LOG.info("Got majority: " + this.i);
                                    }
                                }
                            }
                            ((Object)((Object)FLETest.this)).notifyAll();
                            if (FLETest.this.leader == (long)this.i) {
                                hashMap = FLETest.this.finalObj;
                                synchronized (hashMap) {
                                    ++FLETest.this.successCount;
                                    if (FLETest.this.successCount > FLETest.this.count / 2) {
                                        FLETest.this.finalObj.notify();
                                    }
                                }
                            }
                        }
                    }
                    LOG.info("Logical clock " + ((FastLeaderElection)this.peer.getElectionAlg()).getLogicalClock());
                    object = FLETest.this.voteMap;
                    synchronized (object) {
                        LOG.info("Voting on " + FLETest.this.votes[this.i].id + ", round " + ((FastLeaderElection)this.peer.getElectionAlg()).getLogicalClock());
                        if (FLETest.this.voteMap.get(lc) == null) {
                            FLETest.this.voteMap.put(lc, new HashSet());
                        }
                        HashSet<TestVote> hs2 = FLETest.this.voteMap.get(lc);
                        hs2.add(new TestVote(this.i, FLETest.this.votes[this.i].id));
                        if (FLETest.this.countVotes(hs2, FLETest.this.votes[this.i].id) > FLETest.this.count / 2) {
                            LOG.info("Logical clock: " + lc + ", " + FLETest.this.votes[this.i].id);
                            FLETest.this.voteMap.notify();
                        }
                    }
                    object = FLETest.this;
                    synchronized (object) {
                        if (FLETest.this.leader != FLETest.this.votes[this.i].id) {
                            ((Object)((Object)FLETest.this)).wait(3000L);
                        }
                        LOG.info("The leader: " + FLETest.this.leader + " and my vote " + FLETest.this.votes[this.i].id);
                        hashMap = FLETest.this.voteMap;
                        synchronized (hashMap) {
                            if (FLETest.this.leader == FLETest.this.votes[this.i].id) {
                                hs = FLETest.this.finalObj;
                                synchronized (hs) {
                                    ++FLETest.this.successCount;
                                    if (FLETest.this.successCount > FLETest.this.count / 2) {
                                        FLETest.this.finalObj.notify();
                                    }
                                }
                            }
                            hs = FLETest.this.voteMap.get(lc);
                            TestVote toRemove = null;
                            for (TestVote tv : hs) {
                                if (v.id != (long)this.i) continue;
                                toRemove = tv;
                                break;
                            }
                            hs.remove(toRemove);
                        }
                    }
                    Thread.sleep(FLETest.this.rand.nextInt(500));
                    this.peer.setCurrentVote(new Vote(this.peer.getId(), 0L));
                }
                LOG.debug("Thread " + this.i + " votes " + v);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    static class TestVote {
        long leader;

        TestVote(int id, long leader) {
            this.leader = leader;
        }
    }
}

