/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.server.quorum.FastLeaderElection;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.Vote;
import org.apache.zookeeper.server.quorum.flexible.QuorumHierarchical;
import org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.HierarchicalQuorumTest;
import org.apache.zookeeper.test.QuorumBase;
import org.junit.Before;
import org.junit.Test;

public class FLEZeroWeightTest
extends TestCase {
    private static final Logger LOG = Logger.getLogger(HierarchicalQuorumTest.class);
    Properties qp;
    int count;
    HashMap<Long, QuorumPeer.QuorumServer> peers;
    ArrayList<LEThread> threads;
    File[] tmpdir;
    int[] port;
    Object finalObj;
    volatile Vote[] votes;
    volatile boolean leaderDies;
    volatile long leader = -1L;
    Random rand = new Random();

    @Before
    protected void setUp() throws Exception {
        this.count = 9;
        this.peers = new HashMap(this.count);
        this.threads = new ArrayList(this.count);
        this.votes = new Vote[this.count];
        this.tmpdir = new File[this.count];
        this.port = new int[this.count];
        this.finalObj = new Object();
        String config = "group.1=0:1:2\ngroup.2=3:4:5\ngroup.3=6:7:8\nweight.0=1\nweight.1=1\nweight.2=1\nweight.3=0\nweight.4=0\nweight.5=0\nweight.6=0\nweight.7=0\nweight.8=0";
        ByteArrayInputStream is = new ByteArrayInputStream(config.getBytes());
        this.qp = new Properties();
        this.qp.load(is);
        LOG.info("SetUp " + this.getName());
    }

    protected void tearDown() throws Exception {
        for (int i = 0; i < this.threads.size(); ++i) {
            LEThread leThread = this.threads.get(i);
            QuorumBase.shutdown(leThread.peer);
        }
        LOG.info("FINISHED " + this.getName());
    }

    @Test
    public void testZeroWeightQuorum() throws Exception {
        int i;
        FastLeaderElection[] le = new FastLeaderElection[this.count];
        LOG.info("TestZeroWeightQuorum: " + this.getName() + ", " + this.count);
        for (i = 0; i < this.count; ++i) {
            this.peers.put(Long.valueOf(i), new QuorumPeer.QuorumServer(i, new InetSocketAddress(PortAssignment.unique()), new InetSocketAddress(PortAssignment.unique())));
            this.tmpdir[i] = ClientBase.createTmpDir();
            this.port[i] = PortAssignment.unique();
        }
        for (i = 0; i < le.length; ++i) {
            QuorumHierarchical hq = new QuorumHierarchical(this.qp);
            QuorumPeer peer = new QuorumPeer(this.peers, this.tmpdir[i], this.tmpdir[i], this.port[i], 3, (long)i, 2, 2, 2, (QuorumVerifier)hq);
            peer.startLeaderElection();
            LEThread thread = new LEThread(peer, i);
            thread.start();
            this.threads.add(thread);
        }
        LOG.info("Started threads " + this.getName());
        for (i = 0; i < this.threads.size(); ++i) {
            this.threads.get(i).join(15000L);
            if (this.threads.get(i).isAlive()) {
                FLEZeroWeightTest.fail((String)"Threads didn't join");
                continue;
            }
            if (!this.threads.get((int)i).fail) continue;
            FLEZeroWeightTest.fail((String)"Elected zero-weight server");
        }
    }

    class LEThread
    extends Thread {
        int i;
        QuorumPeer peer;
        boolean fail;

        LEThread(QuorumPeer peer, int i) {
            this.i = i;
            this.peer = peer;
            LOG.info("Constructor: " + this.getName());
        }

        public void run() {
            try {
                Vote v = null;
                this.fail = false;
                do {
                    this.peer.setPeerState(QuorumPeer.ServerState.LOOKING);
                    LOG.info("Going to call leader election.");
                    v = this.peer.getElectionAlg().lookForLeader();
                    if (v == null) {
                        LOG.info("Thread " + this.i + " got a null vote");
                        return;
                    }
                    this.peer.setCurrentVote(v);
                    LOG.info("Finished election: " + this.i + ", " + v.id);
                    FLEZeroWeightTest.this.votes[this.i] = v;
                    if (this.peer.getPeerState() != QuorumPeer.ServerState.LEADING || this.peer.getId() <= 2L) continue;
                    this.fail = true;
                } while (this.peer.getPeerState() != QuorumPeer.ServerState.FOLLOWING && this.peer.getPeerState() != QuorumPeer.ServerState.LEADING);
                LOG.debug("Thread " + this.i + " votes " + v);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

