/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.ClientTest;
import org.apache.zookeeper.test.DisconnectableZooKeeper;
import org.apache.zookeeper.test.QuorumBase;
import org.apache.zookeeper.test.QuorumUtil;
import org.junit.Test;

public class FollowerResyncConcurrencyTest
extends QuorumBase {
    volatile int counter = 0;
    volatile int errors = 0;
    private static final Logger LOG = Logger.getLogger(FollowerResyncConcurrencyTest.class);
    public static final long CONNECTION_TIMEOUT = ClientTest.CONNECTION_TIMEOUT;

    @Test
    public void testResyncBySnapThenDiffAfterFollowerCrashes() throws IOException, InterruptedException, KeeperException, Throwable {
        final Semaphore sem = new Semaphore(0);
        QuorumUtil qu = new QuorumUtil(1);
        qu.startAll();
        ClientBase.CountdownWatcher watcher1 = new ClientBase.CountdownWatcher();
        ClientBase.CountdownWatcher watcher2 = new ClientBase.CountdownWatcher();
        ClientBase.CountdownWatcher watcher3 = new ClientBase.CountdownWatcher();
        int index = 1;
        while (qu.getPeer((int)index).peer.leader == null) {
            ++index;
        }
        Leader leader = qu.getPeer((int)index).peer.leader;
        FollowerResyncConcurrencyTest.assertNotNull((Object)leader);
        index = index == 1 ? 2 : 1;
        qu.shutdown(index);
        final DisconnectableZooKeeper zk3 = new DisconnectableZooKeeper("127.0.0.1:" + qu.getPeer((int)3).peer.getClientPort(), 1000, watcher3);
        watcher3.waitForConnected(CONNECTION_TIMEOUT);
        zk3.create("/mybar", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
        qu.restart(index);
        DisconnectableZooKeeper zk = new DisconnectableZooKeeper("127.0.0.1:" + qu.getPeer((int)index).peer.getClientPort(), 1000, watcher1);
        DisconnectableZooKeeper zk2 = new DisconnectableZooKeeper("127.0.0.1:" + qu.getPeer((int)index).peer.getClientPort(), 1000, watcher2);
        watcher1.waitForConnected(CONNECTION_TIMEOUT);
        watcher2.waitForConnected(CONNECTION_TIMEOUT);
        zk.create("/first", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Thread t = new Thread(new Runnable(){

            public void run() {
                for (int i = 0; i < 1000; ++i) {
                    zk3.create("/mytestfoo", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL, new AsyncCallback.StringCallback(){

                        public void processResult(int rc, String path, Object ctx, String name) {
                            ++FollowerResyncConcurrencyTest.this.counter;
                            if (rc != 0) {
                                ++FollowerResyncConcurrencyTest.this.errors;
                            }
                            if (FollowerResyncConcurrencyTest.this.counter == 14200) {
                                sem.release();
                            }
                        }
                    }, null);
                    if (i % 10 != 0) continue;
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        for (int i = 0; i < 13000; ++i) {
            zk3.create("/mybar", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL, new AsyncCallback.StringCallback(){

                public void processResult(int rc, String path, Object ctx, String name) {
                    ++FollowerResyncConcurrencyTest.this.counter;
                    if (rc != 0) {
                        ++FollowerResyncConcurrencyTest.this.errors;
                    }
                    if (FollowerResyncConcurrencyTest.this.counter == 14200) {
                        sem.release();
                    }
                }
            }, null);
            if (i == 5000) {
                qu.shutdown(index);
                LOG.info("Shutting down s1");
            }
            if (i == 12000) {
                qu.restart(index);
                Thread.sleep(300L);
                qu.shutdown(index);
                t.start();
                Thread.sleep(300L);
                qu.restart(index);
                LOG.info("Setting up server: " + index);
            }
            if (i % 1000 == 0) {
                Thread.sleep(1000L);
            }
            if (i % 50 != 0) continue;
            zk2.create("/newbaz", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL, new AsyncCallback.StringCallback(){

                public void processResult(int rc, String path, Object ctx, String name) {
                    ++FollowerResyncConcurrencyTest.this.counter;
                    if (rc != 0) {
                        ++FollowerResyncConcurrencyTest.this.errors;
                    }
                    if (FollowerResyncConcurrencyTest.this.counter == 14200) {
                        sem.release();
                    }
                }
            }, null);
        }
        if (!sem.tryAcquire(20000L, TimeUnit.MILLISECONDS)) {
            LOG.warn("Did not aquire semaphore fast enough");
        }
        t.join(10000L);
        Thread.sleep(1000L);
        this.verifyState(qu, index, leader);
    }

    @Test
    public void testResyncByDiffAfterFollowerCrashes() throws IOException, InterruptedException, KeeperException, Throwable {
        final Semaphore sem = new Semaphore(0);
        QuorumUtil qu = new QuorumUtil(1);
        qu.startAll();
        ClientBase.CountdownWatcher watcher1 = new ClientBase.CountdownWatcher();
        ClientBase.CountdownWatcher watcher2 = new ClientBase.CountdownWatcher();
        ClientBase.CountdownWatcher watcher3 = new ClientBase.CountdownWatcher();
        int index = 1;
        while (qu.getPeer((int)index).peer.leader == null) {
            ++index;
        }
        Leader leader = qu.getPeer((int)index).peer.leader;
        FollowerResyncConcurrencyTest.assertNotNull((Object)leader);
        index = index == 1 ? 2 : 1;
        DisconnectableZooKeeper zk = new DisconnectableZooKeeper("127.0.0.1:" + qu.getPeer((int)index).peer.getClientPort(), 1000, watcher1);
        DisconnectableZooKeeper zk2 = new DisconnectableZooKeeper("127.0.0.1:" + qu.getPeer((int)index).peer.getClientPort(), 1000, watcher2);
        final DisconnectableZooKeeper zk3 = new DisconnectableZooKeeper("127.0.0.1:" + qu.getPeer((int)3).peer.getClientPort(), 1000, watcher3);
        watcher1.waitForConnected(CONNECTION_TIMEOUT);
        watcher2.waitForConnected(CONNECTION_TIMEOUT);
        watcher3.waitForConnected(CONNECTION_TIMEOUT);
        zk.create("/first", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk2.create("/mybar", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
        final AtomicBoolean runNow = new AtomicBoolean(false);
        Thread t = new Thread(new Runnable(){

            public void run() {
                int inSyncCounter = 0;
                while (inSyncCounter < 400) {
                    if (runNow.get()) {
                        zk3.create("/mytestfoo", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL, new AsyncCallback.StringCallback(){

                            public void processResult(int rc, String path, Object ctx, String name) {
                                ++FollowerResyncConcurrencyTest.this.counter;
                                if (rc != 0) {
                                    ++FollowerResyncConcurrencyTest.this.errors;
                                }
                                if (FollowerResyncConcurrencyTest.this.counter > 7300) {
                                    sem.release();
                                }
                            }
                        }, null);
                        try {
                            Thread.sleep(10L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++inSyncCounter;
                        continue;
                    }
                    Thread.yield();
                }
            }
        });
        t.start();
        for (int i = 0; i < 5000; ++i) {
            zk2.create("/mybar", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL, new AsyncCallback.StringCallback(){

                public void processResult(int rc, String path, Object ctx, String name) {
                    ++FollowerResyncConcurrencyTest.this.counter;
                    if (rc != 0) {
                        ++FollowerResyncConcurrencyTest.this.errors;
                    }
                    if (FollowerResyncConcurrencyTest.this.counter > 7300) {
                        sem.release();
                    }
                }
            }, null);
            if (i == 1000) {
                qu.shutdown(index);
                Thread.sleep(1100L);
                LOG.info("Shutting down s1");
            }
            if (i == 1100 || i == 1150 || i == 1200) {
                Thread.sleep(1000L);
            }
            if (i == 1200) {
                qu.startThenShutdown(index);
                runNow.set(true);
                qu.restart(index);
                LOG.info("Setting up server: " + index);
            }
            if (i >= 1000 && i % 2 == 0) {
                zk3.create("/newbaz", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL, new AsyncCallback.StringCallback(){

                    public void processResult(int rc, String path, Object ctx, String name) {
                        ++FollowerResyncConcurrencyTest.this.counter;
                        if (rc != 0) {
                            ++FollowerResyncConcurrencyTest.this.errors;
                        }
                        if (FollowerResyncConcurrencyTest.this.counter > 7300) {
                            sem.release();
                        }
                    }
                }, null);
            }
            if (i != 1050 && i != 1100 && i != 1150) continue;
            Thread.sleep(1000L);
        }
        if (!sem.tryAcquire(15000L, TimeUnit.MILLISECONDS)) {
            LOG.warn("Did not aquire semaphore fast enough");
        }
        t.join(10000L);
        Thread.sleep(1000L);
        this.verifyState(qu, index, leader);
    }

    private void verifyState(QuorumUtil qu, int index, Leader leader) {
        FollowerResyncConcurrencyTest.assertTrue((String)"Not following", (qu.getPeer((int)index).peer.follower != null ? 1 : 0) != 0);
        long epochF = qu.getPeer((int)index).peer.getActiveServer().getZxid() >> 32;
        long epochL = leader.getEpoch() >> 32;
        FollowerResyncConcurrencyTest.assertTrue((String)("Zxid: " + qu.getPeer((int)index).peer.getActiveServer().getZKDatabase().getDataTreeLastProcessedZxid() + "Current epoch: " + epochF), (epochF == epochL ? 1 : 0) != 0);
        int leaderIndex = index == 1 ? 2 : 1;
        Collection<Long> sessionsRestarted = qu.getPeer((int)index).peer.getActiveServer().getZKDatabase().getSessions();
        Collection<Long> sessionsNotRestarted = qu.getPeer((int)leaderIndex).peer.getActiveServer().getZKDatabase().getSessions();
        for (Long l : sessionsRestarted) {
            FollowerResyncConcurrencyTest.assertTrue((String)("Should have same set of sessions in both servers, did not expect: " + l), (boolean)sessionsNotRestarted.contains(l));
        }
        FollowerResyncConcurrencyTest.assertEquals((String)"Should have same number of sessions", (int)sessionsNotRestarted.size(), (int)sessionsRestarted.size());
        ZKDatabase restarted = qu.getPeer((int)index).peer.getActiveServer().getZKDatabase();
        ZKDatabase clean = qu.getPeer((int)3).peer.getActiveServer().getZKDatabase();
        ZKDatabase lead = qu.getPeer((int)leaderIndex).peer.getActiveServer().getZKDatabase();
        for (Long l : sessionsRestarted) {
            FollowerResyncConcurrencyTest.assertTrue((String)("Should have same set of sessions in both servers, did not expect: " + l), (boolean)sessionsNotRestarted.contains(l));
            HashSet<String> ephemerals = restarted.getEphemerals(l);
            HashSet<String> cleanEphemerals = clean.getEphemerals(l);
            for (String o : cleanEphemerals) {
                if (ephemerals.contains(o)) continue;
                LOG.info("Restarted follower doesn't contain ephemeral " + o);
            }
            HashSet<String> leadEphemerals = lead.getEphemerals(l);
            for (String o : leadEphemerals) {
                if (cleanEphemerals.contains(o)) continue;
                LOG.info("Follower doesn't contain ephemeral from leader " + o);
            }
            FollowerResyncConcurrencyTest.assertEquals((String)"Should have same number of ephemerals in both followers", (int)ephemerals.size(), (int)cleanEphemerals.size());
            FollowerResyncConcurrencyTest.assertEquals((String)"Leader should equal follower", (int)lead.getEphemerals(l).size(), (int)cleanEphemerals.size());
        }
    }
}

