/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Test;

public class FourLetterWordsTest
extends ClientBase {
    protected static final Logger LOG = Logger.getLogger(FourLetterWordsTest.class);

    @Test
    public void testFourLetterWords() throws Exception {
        this.verify("ruok", "imok");
        this.verify("envi", "java.version");
        this.verify("conf", "clientPort");
        this.verify("stat", "Outstanding");
        this.verify("srvr", "Outstanding");
        this.verify("cons", "queued");
        this.verify("dump", "Session");
        this.verify("wchs", "watches");
        this.verify("wchp", "");
        this.verify("wchc", "");
        this.verify("srst", "reset");
        this.verify("crst", "reset");
        this.verify("stat", "Outstanding");
        this.verify("srvr", "Outstanding");
        this.verify("cons", "queued");
        TestableZooKeeper zk = this.createClient();
        String sid = "0x" + Long.toHexString(zk.getSessionId());
        this.verify("stat", "queued");
        this.verify("srvr", "Outstanding");
        this.verify("cons", sid);
        this.verify("dump", sid);
        zk.getData("/", true, null);
        this.verify("stat", "queued");
        this.verify("srvr", "Outstanding");
        this.verify("cons", sid);
        this.verify("dump", sid);
        this.verify("wchs", "watching 1");
        this.verify("wchp", sid);
        this.verify("wchc", sid);
        zk.close();
        this.verify("ruok", "imok");
        this.verify("envi", "java.version");
        this.verify("conf", "clientPort");
        this.verify("stat", "Outstanding");
        this.verify("srvr", "Outstanding");
        this.verify("cons", "queued");
        this.verify("dump", "Session");
        this.verify("wchs", "watch");
        this.verify("wchp", "");
        this.verify("wchc", "");
        this.verify("srst", "reset");
        this.verify("crst", "reset");
        this.verify("stat", "Outstanding");
        this.verify("srvr", "Outstanding");
        this.verify("cons", "queued");
    }

    private void verify(String cmd, String expected) throws IOException {
        ClientBase.HostPort hpobj = FourLetterWordsTest.parseHostPortList(this.hostPort).get(0);
        String resp = FourLetterWordsTest.send4LetterWord(hpobj.host, hpobj.port, cmd);
        LOG.info("cmd " + cmd + " expected " + expected + " got " + resp);
        FourLetterWordsTest.assertTrue((boolean)resp.contains(expected));
    }
}

