/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Test;

public class GetChildren2Test
extends ClientBase {
    private ZooKeeper zk;

    protected void setUp() throws Exception {
        super.setUp();
        this.zk = this.createClient();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.zk.close();
    }

    @Test
    public void testChild() throws IOException, KeeperException, InterruptedException {
        String name = "/foo";
        this.zk.create(name, name.getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        String childname = name + "/bar";
        this.zk.create(childname, childname.getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        Stat stat = new Stat();
        List<String> s = this.zk.getChildren(name, false, stat);
        GetChildren2Test.assertEquals((long)stat.getCzxid(), (long)stat.getMzxid());
        GetChildren2Test.assertEquals((long)(stat.getCzxid() + 1L), (long)stat.getPzxid());
        GetChildren2Test.assertEquals((long)stat.getCtime(), (long)stat.getMtime());
        GetChildren2Test.assertEquals((int)1, (int)stat.getCversion());
        GetChildren2Test.assertEquals((int)0, (int)stat.getVersion());
        GetChildren2Test.assertEquals((int)0, (int)stat.getAversion());
        GetChildren2Test.assertEquals((long)0L, (long)stat.getEphemeralOwner());
        GetChildren2Test.assertEquals((int)name.length(), (int)stat.getDataLength());
        GetChildren2Test.assertEquals((int)1, (int)stat.getNumChildren());
        GetChildren2Test.assertEquals((int)s.size(), (int)stat.getNumChildren());
        s = this.zk.getChildren(childname, false, stat);
        GetChildren2Test.assertEquals((long)stat.getCzxid(), (long)stat.getMzxid());
        GetChildren2Test.assertEquals((long)stat.getCzxid(), (long)stat.getPzxid());
        GetChildren2Test.assertEquals((long)stat.getCtime(), (long)stat.getMtime());
        GetChildren2Test.assertEquals((int)0, (int)stat.getCversion());
        GetChildren2Test.assertEquals((int)0, (int)stat.getVersion());
        GetChildren2Test.assertEquals((int)0, (int)stat.getAversion());
        GetChildren2Test.assertEquals((long)this.zk.getSessionId(), (long)stat.getEphemeralOwner());
        GetChildren2Test.assertEquals((int)childname.length(), (int)stat.getDataLength());
        GetChildren2Test.assertEquals((int)0, (int)stat.getNumChildren());
        GetChildren2Test.assertEquals((int)s.size(), (int)stat.getNumChildren());
    }

    @Test
    public void testChildren() throws IOException, KeeperException, InterruptedException {
        String childname;
        int i;
        String name = "/foo";
        this.zk.create(name, name.getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        ArrayList<String> children = new ArrayList<String>();
        ArrayList<String> children_s = new ArrayList<String>();
        for (i = 0; i < 10; ++i) {
            childname = name + "/bar" + i;
            String childname_s = "bar" + i;
            children.add(childname);
            children_s.add(childname_s);
        }
        for (i = 0; i < children.size(); ++i) {
            childname = (String)children.get(i);
            this.zk.create(childname, childname.getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
            Stat stat = new Stat();
            List<String> s = this.zk.getChildren(name, false, stat);
            GetChildren2Test.assertEquals((long)stat.getCzxid(), (long)stat.getMzxid());
            GetChildren2Test.assertEquals((long)(stat.getCzxid() + (long)i + 1L), (long)stat.getPzxid());
            GetChildren2Test.assertEquals((long)stat.getCtime(), (long)stat.getMtime());
            GetChildren2Test.assertEquals((int)(i + 1), (int)stat.getCversion());
            GetChildren2Test.assertEquals((int)0, (int)stat.getVersion());
            GetChildren2Test.assertEquals((int)0, (int)stat.getAversion());
            GetChildren2Test.assertEquals((long)0L, (long)stat.getEphemeralOwner());
            GetChildren2Test.assertEquals((int)name.length(), (int)stat.getDataLength());
            GetChildren2Test.assertEquals((int)(i + 1), (int)stat.getNumChildren());
            GetChildren2Test.assertEquals((int)s.size(), (int)stat.getNumChildren());
        }
        List<String> p = this.zk.getChildren(name, false, null);
        ArrayList<String> c_a = children_s;
        List<String> c_b = p;
        Collections.sort(c_a);
        Collections.sort(c_b);
        GetChildren2Test.assertEquals((int)c_a.size(), (int)10);
        GetChildren2Test.assertEquals(c_a, c_b);
    }
}

