/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.server.NIOServerCnxn;
import org.apache.zookeeper.server.quorum.Election;
import org.apache.zookeeper.server.quorum.LeaderElection;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.Vote;
import org.apache.zookeeper.server.quorum.flexible.QuorumMaj;
import org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.FLELostMessageTest;
import org.junit.Test;

public class LENonTerminateTest
extends TestCase {
    protected static final Logger LOG = Logger.getLogger(FLELostMessageTest.class);
    int count;
    HashMap<Long, QuorumPeer.QuorumServer> peers;
    File[] tmpdir;
    int[] port;
    static final CountDownLatch latch = new CountDownLatch(2);
    static final CountDownLatch mockLatch = new CountDownLatch(1);

    public void setUp() throws Exception {
        this.count = 3;
        this.peers = new HashMap(this.count);
        this.tmpdir = new File[this.count];
        this.port = new int[this.count];
        LOG.info("SetUp " + this.getName());
    }

    public void tearDown() throws Exception {
        LOG.info("FINISHED " + this.getName());
    }

    @Test
    public void testNonTermination() throws Exception {
        LOG.info("TestNonTermination: " + this.getName() + ", " + this.count);
        for (int i = 0; i < this.count; ++i) {
            int clientport = PortAssignment.unique();
            this.peers.put(Long.valueOf(i), new QuorumPeer.QuorumServer(i, new InetSocketAddress("127.0.0.1", clientport), new InetSocketAddress("127.0.0.1", PortAssignment.unique())));
            this.tmpdir[i] = ClientBase.createTmpDir();
            this.port[i] = clientport;
        }
        MockQuorumPeer peer1 = new MockQuorumPeer(this.peers, this.tmpdir[0], this.tmpdir[0], this.port[0], 0, 0L, 2, 2, 2);
        peer1.startLeaderElection();
        LEThread thread1 = new LEThread(peer1, 0);
        MockQuorumPeer peer2 = new MockQuorumPeer(this.peers, this.tmpdir[1], this.tmpdir[1], this.port[1], 0, 1L, 2, 2, 2);
        peer2.startLeaderElection();
        LEThread thread2 = new LEThread(peer2, 1);
        Thread thread3 = new Thread(){

            public void run() {
                try {
                    LENonTerminateTest.this.mockServer();
                }
                catch (Exception e) {
                    LOG.error(e);
                    Assert.fail((String)("Exception when running mocked server " + e));
                }
            }
        };
        thread3.start();
        LENonTerminateTest.assertTrue((String)"mockServer did not start in 5s", (boolean)mockLatch.await(5000L, TimeUnit.MILLISECONDS));
        thread1.start();
        thread2.start();
        thread1.join(15000L);
        thread2.join(15000L);
        thread3.join(15000L);
        if (thread1.isAlive() || thread2.isAlive() || thread3.isAlive()) {
            LENonTerminateTest.fail((String)"Threads didn't join");
        }
    }

    void mockServer() throws InterruptedException, IOException {
        byte[] b = new byte[36];
        ByteBuffer responseBuffer = ByteBuffer.wrap(b);
        DatagramPacket packet = new DatagramPacket(b, b.length);
        QuorumPeer.QuorumServer server = this.peers.get(2L);
        DatagramSocket udpSocket = new DatagramSocket(server.addr.getPort());
        LOG.info("In MockServer");
        mockLatch.countDown();
        Vote current = new Vote(2L, 1L);
        for (int i = 0; i < 2; ++i) {
            udpSocket.receive(packet);
            responseBuffer.rewind();
            LOG.info("Received " + responseBuffer.getInt() + " " + responseBuffer.getLong() + " " + responseBuffer.getLong());
            LOG.info("From " + packet.getSocketAddress());
            responseBuffer.clear();
            responseBuffer.getInt();
            responseBuffer.putLong(2L);
            responseBuffer.putLong(current.id);
            responseBuffer.putLong(current.zxid);
            packet.setData(b);
            udpSocket.send(packet);
        }
    }

    class LEThread
    extends Thread {
        int i;
        QuorumPeer peer;

        LEThread(QuorumPeer peer, int i) {
            this.i = i;
            this.peer = peer;
            LOG.info("Constructor: " + this.getName());
        }

        public void run() {
            try {
                Vote v = null;
                this.peer.setPeerState(QuorumPeer.ServerState.LOOKING);
                LOG.info("Going to call leader election: " + this.i);
                v = this.peer.getElectionAlg().lookForLeader();
                if (v == null) {
                    Assert.fail((String)("Thread " + this.i + " got a null vote"));
                }
                this.peer.setCurrentVote(v);
                LOG.info("Finished election: " + this.i + ", " + v.id);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            LOG.info("Joining");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MockQuorumPeer
    extends QuorumPeer {
        public MockQuorumPeer(Map<Long, QuorumPeer.QuorumServer> quorumPeers, File snapDir, File logDir, int clientPort, int electionAlg, long myid, int tickTime, int initLimit, int syncLimit) throws IOException {
            super(quorumPeers, snapDir, logDir, electionAlg, myid, tickTime, initLimit, syncLimit, new NIOServerCnxn.Factory(new InetSocketAddress(clientPort)), (QuorumVerifier)new QuorumMaj(MockQuorumPeer.countParticipants(quorumPeers)));
        }

        @Override
        protected Election createElectionAlgorithm(int electionAlgorithm) {
            LOG.info("Returning mocked leader election");
            return new MockLeaderElection(this);
        }
    }

    public class MockLeaderElection
    extends LeaderElection {
        public MockLeaderElection(QuorumPeer self) {
            super(self);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Vote lookForLeader() throws InterruptedException {
            this.self.setCurrentVote(new Vote(this.self.getId(), this.self.getLastLoggedZxid()));
            byte[] requestBytes = new byte[4];
            ByteBuffer requestBuffer = ByteBuffer.wrap(requestBytes);
            byte[] responseBytes = new byte[28];
            ByteBuffer responseBuffer = ByteBuffer.wrap(responseBytes);
            DatagramSocket s = null;
            try {
                s = new DatagramSocket();
                s.setSoTimeout(200);
            }
            catch (SocketException e1) {
                LOG.error("Socket exception when creating socket for leader election", e1);
                System.exit(4);
            }
            DatagramPacket requestPacket = new DatagramPacket(requestBytes, requestBytes.length);
            DatagramPacket responsePacket = new DatagramPacket(responseBytes, responseBytes.length);
            HashMap<InetSocketAddress, Vote> votes = new HashMap<InetSocketAddress, Vote>(this.self.getVotingView().size());
            int xid = epochGen.nextInt();
            while (this.self.isRunning()) {
                votes.clear();
                requestBuffer.clear();
                requestBuffer.putInt(xid);
                requestPacket.setLength(4);
                HashSet<Long> heardFrom = new HashSet<Long>();
                for (QuorumPeer.QuorumServer server : this.self.getVotingView().values()) {
                    LOG.info("Server address: " + server.addr);
                    try {
                        requestPacket.setSocketAddress(server.addr);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException("Unable to set socket address on packet, msg:" + e.getMessage() + " with addr:" + server.addr, e);
                    }
                    try {
                        s.send(requestPacket);
                        responsePacket.setLength(responseBytes.length);
                        s.receive(responsePacket);
                        if (responsePacket.getLength() != responseBytes.length) {
                            LOG.error("Got a short response: " + responsePacket.getLength());
                            continue;
                        }
                        responseBuffer.clear();
                        int recvedXid = responseBuffer.getInt();
                        if (recvedXid != xid) {
                            LOG.error("Got bad xid: expected " + xid + " got " + recvedXid);
                            continue;
                        }
                        long peerId = responseBuffer.getLong();
                        heardFrom.add(peerId);
                        Vote vote = new Vote(responseBuffer.getLong(), responseBuffer.getLong());
                        InetSocketAddress addr = (InetSocketAddress)responsePacket.getSocketAddress();
                        votes.put(addr, vote);
                    }
                    catch (IOException e) {
                        LOG.warn("Ignoring exception while looking for leader", e);
                    }
                }
                LeaderElection.ElectionResult result = this.countVotes(votes, heardFrom);
                LOG.info("Waiting for first round of voting to complete");
                latch.countDown();
                Assert.assertTrue((String)"Thread timed out waiting for latch", (boolean)latch.await(10000L, TimeUnit.MILLISECONDS));
                if (votes.size() == 0) {
                    this.self.setCurrentVote(new Vote(this.self.getId(), this.self.getLastLoggedZxid()));
                } else if (result.winner.id >= 0L) {
                    this.self.setCurrentVote(result.vote);
                    if (result.winningCount > this.self.getVotingView().size() / 2) {
                        this.self.setCurrentVote(result.winner);
                        s.close();
                        Vote current = this.self.getCurrentVote();
                        LOG.info("Found leader: my type is: " + (Object)((Object)this.self.getLearnerType()));
                        if (this.self.getLearnerType() == QuorumPeer.LearnerType.OBSERVER) {
                            if (current.id != this.self.getId()) {
                                this.self.setPeerState(QuorumPeer.ServerState.OBSERVING);
                                Thread.sleep(100L);
                                return current;
                            }
                            LOG.error("OBSERVER elected as leader!");
                            Thread.sleep(100L);
                        } else {
                            this.self.setPeerState(current.id == this.self.getId() ? QuorumPeer.ServerState.LEADING : QuorumPeer.ServerState.FOLLOWING);
                            if (this.self.getPeerState() == QuorumPeer.ServerState.FOLLOWING) {
                                Thread.sleep(100L);
                            }
                            return current;
                        }
                    }
                }
                Thread.sleep(1000L);
            }
            return null;
        }
    }
}

