/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.server.quorum.LeaderElection;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.Vote;
import org.apache.zookeeper.test.ClientBase;

public class LETest
extends TestCase {
    private static final Logger LOG = Logger.getLogger(LETest.class);
    volatile Vote[] votes;
    volatile boolean leaderDies;
    volatile long leader = -1L;
    Random rand = new Random();

    public void testLE() throws Exception {
        int i;
        int count = 30;
        HashMap<Long, QuorumPeer.QuorumServer> peers = new HashMap<Long, QuorumPeer.QuorumServer>(count);
        ArrayList<LEThread> threads = new ArrayList<LEThread>(count);
        File[] tmpdir = new File[count];
        int[] port = new int[count];
        this.votes = new Vote[count];
        for (int i2 = 0; i2 < count; ++i2) {
            peers.put(Long.valueOf(i2), new QuorumPeer.QuorumServer(i2, new InetSocketAddress("127.0.0.1", PortAssignment.unique())));
            tmpdir[i2] = ClientBase.createTmpDir();
            port[i2] = PortAssignment.unique();
        }
        LeaderElection[] le = new LeaderElection[count];
        boolean allowOneBadLeader = this.leaderDies = true;
        for (i = 0; i < le.length; ++i) {
            QuorumPeer peer = new QuorumPeer(peers, tmpdir[i], tmpdir[i], port[i], 0, (long)i, 2, 2, 2);
            peer.startLeaderElection();
            le[i] = new LeaderElection(peer);
            LEThread thread = new LEThread(le[i], peer, i);
            thread.start();
            threads.add(thread);
        }
        for (i = 0; i < threads.size(); ++i) {
            ((LEThread)threads.get(i)).join(15000L);
            if (!((LEThread)threads.get(i)).isAlive()) continue;
            LETest.fail((String)"Threads didn't join");
        }
        long id = this.votes[0].id;
        for (int i3 = 1; i3 < this.votes.length; ++i3) {
            if (this.votes[i3] == null) {
                LETest.fail((String)("Thread " + i3 + " had a null vote"));
            }
            if (this.votes[i3].id == id) continue;
            if (allowOneBadLeader && this.votes[i3].id == (long)i3) {
                allowOneBadLeader = false;
                continue;
            }
            LETest.fail((String)("Thread " + i3 + " got " + this.votes[i3].id + " expected " + id));
        }
    }

    class LEThread
    extends Thread {
        LeaderElection le;
        int i;
        QuorumPeer peer;

        LEThread(LeaderElection le, QuorumPeer peer, int i) {
            this.le = le;
            this.i = i;
            this.peer = peer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Vote v = null;
                while (true) {
                    LETest lETest;
                    LETest.this.votes[this.i] = v = this.le.lookForLeader();
                    if (v.id == (long)this.i) {
                        lETest = LETest.this;
                        synchronized (lETest) {
                            if (LETest.this.leaderDies) {
                                LETest.this.leaderDies = false;
                                this.peer.stopLeaderElection();
                                LOG.info("Leader " + this.i + " dying");
                                LETest.this.leader = -2L;
                            } else {
                                LETest.this.leader = this.i;
                            }
                            ((Object)((Object)LETest.this)).notifyAll();
                            break;
                        }
                    }
                    lETest = LETest.this;
                    synchronized (lETest) {
                        if (LETest.this.leader == -1L) {
                            ((Object)((Object)LETest.this)).wait();
                        }
                        if (LETest.this.leader == v.id) {
                            break;
                        }
                    }
                    Thread.sleep(LETest.this.rand.nextInt(1000));
                    this.peer.setCurrentVote(new Vote(this.peer.getId(), 0L));
                }
                LOG.info("Thread " + this.i + " votes " + v);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

