/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.util.concurrent.CountDownLatch;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Test;

public class ObserverTest
extends QuorumPeerTestBase
implements Watcher {
    protected static final Logger LOG = Logger.getLogger(ObserverTest.class);
    CountDownLatch latch;
    ZooKeeper zk;
    WatchedEvent lastEvent = null;

    @Test
    public void testObserver() throws Exception {
        ClientBase.setupTestEnv();
        this.latch = new CountDownLatch(2);
        int PORT_QP1 = PortAssignment.unique();
        int PORT_QP2 = PortAssignment.unique();
        int PORT_OBS = PortAssignment.unique();
        int PORT_QP_LE1 = PortAssignment.unique();
        int PORT_QP_LE2 = PortAssignment.unique();
        int PORT_OBS_LE = PortAssignment.unique();
        int CLIENT_PORT_QP1 = PortAssignment.unique();
        int CLIENT_PORT_QP2 = PortAssignment.unique();
        int CLIENT_PORT_OBS = PortAssignment.unique();
        String quorumCfgSection = "electionAlg=3\nserver.1=127.0.0.1:" + PORT_QP1 + ":" + PORT_QP_LE1 + "\nserver.2=127.0.0.1:" + PORT_QP2 + ":" + PORT_QP_LE2 + "\nserver.3=127.0.0.1:" + PORT_OBS + ":" + PORT_OBS_LE + ":observer";
        String obsCfgSection = quorumCfgSection + "\npeerType=observer";
        QuorumPeerTestBase.MainThread q1 = new QuorumPeerTestBase.MainThread(1, CLIENT_PORT_QP1, quorumCfgSection);
        QuorumPeerTestBase.MainThread q2 = new QuorumPeerTestBase.MainThread(2, CLIENT_PORT_QP2, quorumCfgSection);
        QuorumPeerTestBase.MainThread q3 = new QuorumPeerTestBase.MainThread(3, CLIENT_PORT_OBS, obsCfgSection);
        q1.start();
        q2.start();
        q3.start();
        ObserverTest.assertTrue((String)"waiting for server 1 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
        ObserverTest.assertTrue((String)"waiting for server 2 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT));
        ObserverTest.assertTrue((String)"waiting for server 3 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_OBS, ClientBase.CONNECTION_TIMEOUT));
        this.zk = new ZooKeeper("127.0.0.1:" + CLIENT_PORT_OBS, ClientBase.CONNECTION_TIMEOUT, this);
        this.zk.create("/obstest", "test".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        ObserverTest.assertEquals((String)new String(this.zk.getData("/obstest", null, null)), (String)"test");
        this.zk.sync("/", null, null);
        this.zk.setData("/obstest", "test2".getBytes(), -1);
        this.zk.getChildren("/", false);
        ObserverTest.assertEquals((Object)((Object)this.zk.getState()), (Object)((Object)ZooKeeper.States.CONNECTED));
        q2.shutdown();
        ObserverTest.assertTrue((String)"Waiting for server 2 to shut down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT));
        this.latch.await();
        ObserverTest.assertNotSame((String)"Client is still connected to non-quorate cluster", (Object)((Object)Watcher.Event.KeeperState.SyncConnected), (Object)((Object)this.lastEvent.getState()));
        try {
            ObserverTest.assertFalse((String)"Shouldn't get a response when cluster not quorate!", (boolean)new String(this.zk.getData("/obstest", null, null)).equals("test"));
        }
        catch (KeeperException.ConnectionLossException c) {
            LOG.info("Connection loss exception caught - ensemble not quorate (this is expected)");
        }
        this.latch = new CountDownLatch(1);
        q2 = new QuorumPeerTestBase.MainThread(2, CLIENT_PORT_QP2, quorumCfgSection);
        q2.start();
        LOG.info("Waiting for server 2 to come up");
        ObserverTest.assertTrue((String)"waiting for server 2 being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT));
        this.latch.await();
        ObserverTest.assertTrue((String)("Client didn't reconnect to quorate ensemble (state was" + (Object)((Object)this.lastEvent.getState()) + ")"), (Watcher.Event.KeeperState.SyncConnected == this.lastEvent.getState() || Watcher.Event.KeeperState.Expired == this.lastEvent.getState() ? 1 : 0) != 0);
        q1.shutdown();
        q2.shutdown();
        q3.shutdown();
        this.zk.close();
        ObserverTest.assertTrue((String)"Waiting for server 1 to shut down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT));
        ObserverTest.assertTrue((String)"Waiting for server 2 to shut down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT));
        ObserverTest.assertTrue((String)"Waiting for server 3 to shut down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + CLIENT_PORT_OBS, ClientBase.CONNECTION_TIMEOUT));
    }

    public void process(WatchedEvent event) {
        this.lastEvent = event;
        this.latch.countDown();
        LOG.info("Latch got event :: " + event);
    }

    @Test
    public void testObserverOnly() throws Exception {
        ClientBase.setupTestEnv();
        int CLIENT_PORT_QP1 = PortAssignment.unique();
        String quorumCfgSection = "server.1=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":observer\npeerType=observer\n";
        QuorumPeerTestBase.MainThread q1 = new QuorumPeerTestBase.MainThread(1, CLIENT_PORT_QP1, quorumCfgSection);
        q1.start();
        q1.join(ClientBase.CONNECTION_TIMEOUT);
        Assert.assertFalse((boolean)q1.isAlive());
    }

    @Test
    public void testObserverWithStandlone() throws Exception {
        ClientBase.setupTestEnv();
        int CLIENT_PORT_QP1 = PortAssignment.unique();
        String quorumCfgSection = "server.1=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":observer\n" + "server.2=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + "\npeerType=observer\n";
        QuorumPeerTestBase.MainThread q1 = new QuorumPeerTestBase.MainThread(1, CLIENT_PORT_QP1, quorumCfgSection);
        q1.start();
        q1.join(ClientBase.CONNECTION_TIMEOUT);
        Assert.assertFalse((boolean)q1.isAlive());
    }
}

