/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import com.sun.management.UnixOperatingSystemMXBean;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.LinkedHashSet;
import org.apache.log4j.Logger;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.server.quorum.Election;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.JMXEnv;
import org.junit.After;

public class QuorumBase
extends ClientBase {
    private static final Logger LOG = Logger.getLogger(QuorumBase.class);
    File s1dir;
    File s2dir;
    File s3dir;
    File s4dir;
    File s5dir;
    QuorumPeer s1;
    QuorumPeer s2;
    QuorumPeer s3;
    QuorumPeer s4;
    QuorumPeer s5;
    private int port1;
    private int port2;
    private int port3;
    private int port4;
    private int port5;
    private int portLE1;
    private int portLE2;
    private int portLE3;
    private int portLE4;
    private int portLE5;
    HashMap<Long, QuorumPeer.QuorumServer> peers = null;

    protected void setUp() throws Exception {
        this.setUp(false);
    }

    protected void setUp(boolean withObservers) throws Exception {
        LOG.info("STARTING " + this.getName());
        QuorumBase.setupTestEnv();
        JMXEnv.setUp();
        this.setUpAll();
        this.port1 = PortAssignment.unique();
        this.port2 = PortAssignment.unique();
        this.port3 = PortAssignment.unique();
        this.port4 = PortAssignment.unique();
        this.port5 = PortAssignment.unique();
        this.portLE1 = PortAssignment.unique();
        this.portLE2 = PortAssignment.unique();
        this.portLE3 = PortAssignment.unique();
        this.portLE4 = PortAssignment.unique();
        this.portLE5 = PortAssignment.unique();
        this.hostPort = "127.0.0.1:" + this.port1 + ",127.0.0.1:" + this.port2 + ",127.0.0.1:" + this.port3 + ",127.0.0.1:" + this.port4 + ",127.0.0.1:" + this.port5;
        LOG.info("Ports are: " + this.hostPort);
        this.s1dir = ClientBase.createTmpDir();
        this.s2dir = ClientBase.createTmpDir();
        this.s3dir = ClientBase.createTmpDir();
        this.s4dir = ClientBase.createTmpDir();
        this.s5dir = ClientBase.createTmpDir();
        this.startServers(withObservers);
        OperatingSystemMXBean osMbean = ManagementFactory.getOperatingSystemMXBean();
        if (osMbean != null && osMbean instanceof UnixOperatingSystemMXBean) {
            UnixOperatingSystemMXBean unixos = (UnixOperatingSystemMXBean)osMbean;
            LOG.info("Initial fdcount is: " + unixos.getOpenFileDescriptorCount());
        }
        LOG.info("Setup finished");
    }

    void startServers() throws Exception {
        this.startServers(false);
    }

    void startServers(boolean withObservers) throws Exception {
        int i;
        int tickTime = 2000;
        int initLimit = 3;
        int syncLimit = 3;
        HashMap<Long, QuorumPeer.QuorumServer> peers = new HashMap<Long, QuorumPeer.QuorumServer>();
        peers.put(1L, new QuorumPeer.QuorumServer(1L, new InetSocketAddress("127.0.0.1", this.port1 + 1000), new InetSocketAddress("127.0.0.1", this.portLE1 + 1000), QuorumPeer.LearnerType.PARTICIPANT));
        peers.put(2L, new QuorumPeer.QuorumServer(2L, new InetSocketAddress("127.0.0.1", this.port2 + 1000), new InetSocketAddress("127.0.0.1", this.portLE2 + 1000), QuorumPeer.LearnerType.PARTICIPANT));
        peers.put(3L, new QuorumPeer.QuorumServer(3L, new InetSocketAddress("127.0.0.1", this.port3 + 1000), new InetSocketAddress("127.0.0.1", this.portLE3 + 1000), QuorumPeer.LearnerType.PARTICIPANT));
        peers.put(4L, new QuorumPeer.QuorumServer(4L, new InetSocketAddress("127.0.0.1", this.port4 + 1000), new InetSocketAddress("127.0.0.1", this.portLE4 + 1000), QuorumPeer.LearnerType.PARTICIPANT));
        peers.put(5L, new QuorumPeer.QuorumServer(5L, new InetSocketAddress("127.0.0.1", this.port5 + 1000), new InetSocketAddress("127.0.0.1", this.portLE5 + 1000), QuorumPeer.LearnerType.PARTICIPANT));
        if (withObservers) {
            ((QuorumPeer.QuorumServer)peers.get((Object)Long.valueOf((long)4L))).type = QuorumPeer.LearnerType.OBSERVER;
            ((QuorumPeer.QuorumServer)peers.get((Object)Long.valueOf((long)5L))).type = QuorumPeer.LearnerType.OBSERVER;
        }
        LOG.info("creating QuorumPeer 1 port " + this.port1);
        this.s1 = new QuorumPeer(peers, this.s1dir, this.s1dir, this.port1, 3, 1L, tickTime, initLimit, syncLimit);
        QuorumBase.assertEquals((int)this.port1, (int)this.s1.getClientPort());
        LOG.info("creating QuorumPeer 2 port " + this.port2);
        this.s2 = new QuorumPeer(peers, this.s2dir, this.s2dir, this.port2, 3, 2L, tickTime, initLimit, syncLimit);
        QuorumBase.assertEquals((int)this.port2, (int)this.s2.getClientPort());
        LOG.info("creating QuorumPeer 3 port " + this.port3);
        this.s3 = new QuorumPeer(peers, this.s3dir, this.s3dir, this.port3, 3, 3L, tickTime, initLimit, syncLimit);
        QuorumBase.assertEquals((int)this.port3, (int)this.s3.getClientPort());
        LOG.info("creating QuorumPeer 4 port " + this.port4);
        this.s4 = new QuorumPeer(peers, this.s4dir, this.s4dir, this.port4, 3, 4L, tickTime, initLimit, syncLimit);
        QuorumBase.assertEquals((int)this.port4, (int)this.s4.getClientPort());
        LOG.info("creating QuorumPeer 5 port " + this.port5);
        this.s5 = new QuorumPeer(peers, this.s5dir, this.s5dir, this.port5, 3, 5L, tickTime, initLimit, syncLimit);
        QuorumBase.assertEquals((int)this.port5, (int)this.s5.getClientPort());
        if (withObservers) {
            this.s4.setLearnerType(QuorumPeer.LearnerType.OBSERVER);
            this.s5.setLearnerType(QuorumPeer.LearnerType.OBSERVER);
        }
        LOG.info("QuorumPeer 1 voting view: " + this.s1.getVotingView());
        LOG.info("QuorumPeer 2 voting view: " + this.s2.getVotingView());
        LOG.info("QuorumPeer 3 voting view: " + this.s3.getVotingView());
        LOG.info("QuorumPeer 4 voting view: " + this.s4.getVotingView());
        LOG.info("QuorumPeer 5 voting view: " + this.s5.getVotingView());
        LOG.info("start QuorumPeer 1");
        this.s1.start();
        LOG.info("start QuorumPeer 2");
        this.s2.start();
        LOG.info("start QuorumPeer 3");
        this.s3.start();
        LOG.info("start QuorumPeer 4");
        this.s4.start();
        LOG.info("start QuorumPeer 5");
        this.s5.start();
        LOG.info("started QuorumPeer 5");
        LOG.info("Checking ports " + this.hostPort);
        for (String hp : this.hostPort.split(",")) {
            QuorumBase.assertTrue((String)"waiting for server up", (boolean)ClientBase.waitForServerUp(hp, CONNECTION_TIMEOUT));
            LOG.info(hp + " is accepting client connections");
        }
        JMXEnv.dump();
        LinkedHashSet<String> ensureNames = new LinkedHashSet<String>();
        for (i = 1; i <= 5; ++i) {
            ensureNames.add("InMemoryDataTree");
        }
        for (i = 1; i <= 5; ++i) {
            ensureNames.add("name0=ReplicatedServer_id" + i + ",name1=replica." + i + ",name2=");
        }
        for (i = 1; i <= 5; ++i) {
            for (int j = 1; j <= 5; ++j) {
                ensureNames.add("name0=ReplicatedServer_id" + i + ",name1=replica." + j);
            }
        }
        for (i = 1; i <= 5; ++i) {
            ensureNames.add("name0=ReplicatedServer_id" + i);
        }
        JMXEnv.ensureAll(ensureNames.toArray(new String[ensureNames.size()]));
    }

    public void setupServers() throws IOException {
        this.setupServer(1);
        this.setupServer(2);
        this.setupServer(3);
        this.setupServer(4);
        this.setupServer(5);
    }

    public void setupServer(int i) throws IOException {
        int tickTime = 2000;
        int initLimit = 3;
        int syncLimit = 3;
        if (this.peers == null) {
            this.peers = new HashMap();
            this.peers.put(1L, new QuorumPeer.QuorumServer(1L, new InetSocketAddress("127.0.0.1", this.port1 + 1000), new InetSocketAddress("127.0.0.1", this.portLE1 + 1000), QuorumPeer.LearnerType.PARTICIPANT));
            this.peers.put(2L, new QuorumPeer.QuorumServer(2L, new InetSocketAddress("127.0.0.1", this.port2 + 1000), new InetSocketAddress("127.0.0.1", this.portLE2 + 1000), QuorumPeer.LearnerType.PARTICIPANT));
            this.peers.put(3L, new QuorumPeer.QuorumServer(3L, new InetSocketAddress("127.0.0.1", this.port3 + 1000), new InetSocketAddress("127.0.0.1", this.portLE3 + 1000), QuorumPeer.LearnerType.PARTICIPANT));
            this.peers.put(4L, new QuorumPeer.QuorumServer(4L, new InetSocketAddress("127.0.0.1", this.port4 + 1000), new InetSocketAddress("127.0.0.1", this.portLE4 + 1000), QuorumPeer.LearnerType.PARTICIPANT));
            this.peers.put(5L, new QuorumPeer.QuorumServer(5L, new InetSocketAddress("127.0.0.1", this.port5 + 1000), new InetSocketAddress("127.0.0.1", this.portLE5 + 1000), QuorumPeer.LearnerType.PARTICIPANT));
        }
        switch (i) {
            case 1: {
                LOG.info("creating QuorumPeer 1 port " + this.port1);
                this.s1 = new QuorumPeer(this.peers, this.s1dir, this.s1dir, this.port1, 3, 1L, tickTime, initLimit, syncLimit);
                QuorumBase.assertEquals((int)this.port1, (int)this.s1.getClientPort());
                break;
            }
            case 2: {
                LOG.info("creating QuorumPeer 2 port " + this.port2);
                this.s2 = new QuorumPeer(this.peers, this.s2dir, this.s2dir, this.port2, 3, 2L, tickTime, initLimit, syncLimit);
                QuorumBase.assertEquals((int)this.port2, (int)this.s2.getClientPort());
                break;
            }
            case 3: {
                LOG.info("creating QuorumPeer 3 port " + this.port3);
                this.s3 = new QuorumPeer(this.peers, this.s3dir, this.s3dir, this.port3, 3, 3L, tickTime, initLimit, syncLimit);
                QuorumBase.assertEquals((int)this.port3, (int)this.s3.getClientPort());
                break;
            }
            case 4: {
                LOG.info("creating QuorumPeer 4 port " + this.port4);
                this.s4 = new QuorumPeer(this.peers, this.s4dir, this.s4dir, this.port4, 3, 4L, tickTime, initLimit, syncLimit);
                QuorumBase.assertEquals((int)this.port4, (int)this.s4.getClientPort());
                break;
            }
            case 5: {
                LOG.info("creating QuorumPeer 5 port " + this.port5);
                this.s5 = new QuorumPeer(this.peers, this.s5dir, this.s5dir, this.port5, 3, 5L, tickTime, initLimit, syncLimit);
                QuorumBase.assertEquals((int)this.port5, (int)this.s5.getClientPort());
            }
        }
    }

    @After
    protected void tearDown() throws Exception {
        LOG.info("TearDown started");
        OperatingSystemMXBean osMbean = ManagementFactory.getOperatingSystemMXBean();
        if (osMbean != null && osMbean instanceof UnixOperatingSystemMXBean) {
            UnixOperatingSystemMXBean unixos = (UnixOperatingSystemMXBean)osMbean;
            LOG.info("fdcount after test is: " + unixos.getOpenFileDescriptorCount());
        }
        this.shutdownServers();
        for (String hp : this.hostPort.split(",")) {
            QuorumBase.assertTrue((String)"waiting for server down", (boolean)ClientBase.waitForServerDown(hp, ClientBase.CONNECTION_TIMEOUT));
            LOG.info(hp + " is no longer accepting client connections");
        }
        JMXEnv.tearDown();
        LOG.info("FINISHED " + this.getName());
    }

    public void shutdownServers() {
        QuorumBase.shutdown(this.s1);
        QuorumBase.shutdown(this.s2);
        QuorumBase.shutdown(this.s3);
        QuorumBase.shutdown(this.s4);
        QuorumBase.shutdown(this.s5);
    }

    public static void shutdown(QuorumPeer qp) {
        try {
            LOG.info("Shutting down quorum peer " + qp.getName());
            qp.shutdown();
            Election e = qp.getElectionAlg();
            if (e != null) {
                LOG.info("Shutting down leader election " + qp.getName());
                e.shutdown();
            } else {
                LOG.info("No election available to shutdown " + qp.getName());
            }
            LOG.info("Waiting for " + qp.getName() + " to exit thread");
            qp.join(30000L);
            if (qp.isAlive()) {
                QuorumBase.fail((String)("QP failed to shutdown in 30 seconds: " + qp.getName()));
            }
        }
        catch (InterruptedException e) {
            LOG.debug("QP interrupted: " + qp.getName(), e);
        }
    }

    protected TestableZooKeeper createClient() throws IOException, InterruptedException {
        return this.createClient(this.hostPort);
    }

    protected TestableZooKeeper createClient(String hp) throws IOException, InterruptedException {
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        return this.createClient(watcher, hp);
    }
}

