/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.StatsTrack;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeperMain;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.test.QuorumBase;

public class QuorumQuotaTest
extends QuorumBase {
    private static final Logger LOG = Logger.getLogger(QuorumQuotaTest.class);

    protected void setUp() throws Exception {
        super.setUp();
        LOG.info("STARTING " + ((Object)((Object)this)).getClass().getName());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        LOG.info("STOPPING " + ((Object)((Object)this)).getClass().getName());
    }

    public void testQuotaWithQuorum() throws Exception {
        TestableZooKeeper zk = this.createClient();
        zk.setData("/", "some".getBytes(), -1);
        zk.create("/a", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        int i = 0;
        for (i = 0; i < 300; ++i) {
            zk.create("/a/" + i, "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        ZooKeeperMain.createQuota(zk, "/a", 1000L, 5000);
        String statPath = "/zookeeper/quota/a/zookeeper_stats";
        byte[] data = zk.getData(statPath, false, new Stat());
        StatsTrack st = new StatsTrack(new String(data));
        QuorumQuotaTest.assertTrue((String)"bytes are set", (st.getBytes() == 1204L ? 1 : 0) != 0);
        QuorumQuotaTest.assertTrue((String)"num count is set", (st.getCount() == 301 ? 1 : 0) != 0);
        for (i = 300; i < 600; ++i) {
            zk.create("/a/" + i, "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        data = zk.getData(statPath, false, new Stat());
        st = new StatsTrack(new String(data));
        QuorumQuotaTest.assertTrue((String)"bytes are set", (st.getBytes() == 2404L ? 1 : 0) != 0);
        QuorumQuotaTest.assertTrue((String)"num count is set", (st.getCount() == 601 ? 1 : 0) != 0);
    }
}

