/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.net.InetSocketAddress;
import junit.framework.TestCase;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.server.NIOServerCnxn;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.QuorumBase;
import org.apache.zookeeper.test.QuorumTest;
import org.junit.Test;

public class RepeatStartupTest
extends TestCase {
    @Test
    public void testFail() throws Exception {
        QuorumBase qb = new QuorumBase();
        qb.setUp();
        System.out.println("Comment: the servers are at " + qb.hostPort);
        TestableZooKeeper zk = qb.createClient();
        zk.create("/test", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.close();
        QuorumBase.shutdown(qb.s1);
        QuorumBase.shutdown(qb.s2);
        QuorumBase.shutdown(qb.s3);
        QuorumBase.shutdown(qb.s4);
        QuorumBase.shutdown(qb.s5);
        String hp = qb.hostPort.split(",")[0];
        ZooKeeperServer zks = new ZooKeeperServer(qb.s1.getTxnFactory().getSnapDir(), qb.s1.getTxnFactory().getDataDir(), 3000);
        int PORT = Integer.parseInt(hp.split(":")[1]);
        NIOServerCnxn.Factory factory = new NIOServerCnxn.Factory(new InetSocketAddress(PORT));
        factory.startup(zks);
        System.out.println("Comment: starting factory");
        RepeatStartupTest.assertTrue((String)"waiting for server up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + PORT, QuorumTest.CONNECTION_TIMEOUT));
        factory.shutdown();
        RepeatStartupTest.assertTrue((String)"waiting for server down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + PORT, QuorumTest.CONNECTION_TIMEOUT));
        System.out.println("Comment: shutting down standalone");
    }
}

