/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.NIOServerCnxn;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.DisconnectableZooKeeper;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionTest
extends TestCase
implements Watcher {
    protected static final Logger LOG = Logger.getLogger(SessionTest.class);
    private static final String HOSTPORT = "127.0.0.1:" + PortAssignment.unique();
    private NIOServerCnxn.Factory serverFactory;
    private CountDownLatch startSignal;
    File tmpDir;
    private final int TICK_TIME = 3000;

    protected void setUp() throws Exception {
        LOG.info("STARTING " + this.getName());
        if (this.tmpDir == null) {
            this.tmpDir = ClientBase.createTmpDir();
        }
        ClientBase.setupTestEnv();
        ZooKeeperServer zs = new ZooKeeperServer(this.tmpDir, this.tmpDir, 3000);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        this.serverFactory = new NIOServerCnxn.Factory(new InetSocketAddress(PORT));
        this.serverFactory.startup(zs);
        SessionTest.assertTrue((String)"waiting for server up", (boolean)ClientBase.waitForServerUp(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
    }

    protected void tearDown() throws Exception {
        this.serverFactory.shutdown();
        SessionTest.assertTrue((String)"waiting for server down", (boolean)ClientBase.waitForServerDown(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
        LOG.info("FINISHED " + this.getName());
    }

    private DisconnectableZooKeeper createClient() throws IOException, InterruptedException {
        CountdownWatcher watcher = new CountdownWatcher();
        return this.createClient(ClientBase.CONNECTION_TIMEOUT, watcher);
    }

    private DisconnectableZooKeeper createClient(int timeout) throws IOException, InterruptedException {
        CountdownWatcher watcher = new CountdownWatcher();
        return this.createClient(timeout, watcher);
    }

    private DisconnectableZooKeeper createClient(int timeout, CountdownWatcher watcher) throws IOException, InterruptedException {
        DisconnectableZooKeeper zk = new DisconnectableZooKeeper(HOSTPORT, timeout, watcher);
        if (!watcher.clientConnected.await(timeout, TimeUnit.MILLISECONDS)) {
            SessionTest.fail((String)"Unable to connect to server");
        }
        return zk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSession() throws IOException, InterruptedException, KeeperException {
        DisconnectableZooKeeper zk = this.createClient();
        zk.create("/e", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        LOG.info("zk with session id 0x" + Long.toHexString(zk.getSessionId()) + " was destroyed!");
        zk.disconnect();
        Stat stat = new Stat();
        this.startSignal = new CountDownLatch(1);
        zk = new DisconnectableZooKeeper(HOSTPORT, ClientBase.CONNECTION_TIMEOUT, this, zk.getSessionId(), zk.getSessionPasswd());
        this.startSignal.await();
        LOG.info("zk with session id 0x" + Long.toHexString(zk.getSessionId()) + " was created!");
        zk.getData("/e", false, stat);
        LOG.info("After get data /e");
        zk.close();
        zk = this.createClient();
        SessionTest.assertEquals(null, (Object)zk.exists("/e", false));
        LOG.info("before close zk with session id 0x" + Long.toHexString(zk.getSessionId()) + "!");
        zk.close();
        try {
            zk.getData("/e", false, stat);
            Assert.fail((String)"Should have received a SessionExpiredException");
        }
        catch (KeeperException.SessionExpiredException e) {
            // empty catch block
        }
        AsyncCallback.DataCallback cb = new AsyncCallback.DataCallback(){
            String status = "not done";

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processResult(int rc, String p, Object c, byte[] b, Stat s) {
                1 var6_6 = this;
                synchronized (var6_6) {
                    this.status = KeeperException.Code.get(rc).toString();
                    this.notify();
                }
            }

            public String toString() {
                return this.status;
            }
        };
        zk.getData("/e", false, cb, null);
        AsyncCallback.DataCallback dataCallback = cb;
        synchronized (dataCallback) {
            if (cb.toString().equals("not done")) {
                cb.wait(1000L);
            }
        }
        Assert.assertEquals((Object)KeeperException.Code.SESSIONEXPIRED.toString(), (Object)cb.toString());
    }

    private List<Thread> findThreads(String name) {
        int threadCount = Thread.activeCount();
        Thread[] threads = new Thread[threadCount * 2];
        threadCount = Thread.enumerate(threads);
        ArrayList<Thread> list = new ArrayList<Thread>();
        for (int i = 0; i < threadCount; ++i) {
            if (threads[i].getName().indexOf(name) == -1) continue;
            list.add(threads[i]);
        }
        return list;
    }

    @Test
    public void testSessionTimeout() throws Exception {
        int TIMEOUT = 5000;
        List<Thread> etBefore = this.findThreads("EventThread");
        List<Thread> stBefore = this.findThreads("SendThread");
        DisconnectableZooKeeper zk = this.createClient(5000);
        zk.create("/stest", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        List<Thread> etAfter = this.findThreads("EventThread");
        List<Thread> stAfter = this.findThreads("SendThread");
        Thread eventThread = null;
        Thread sendThread = null;
        for (Thread t : etAfter) {
            if (etBefore.contains(t)) continue;
            eventThread = t;
            break;
        }
        for (Thread t : stAfter) {
            if (stBefore.contains(t)) continue;
            sendThread = t;
            break;
        }
        sendThread.suspend();
        Thread.sleep(10000L);
        sendThread.resume();
        eventThread.join(5000L);
        SessionTest.assertFalse((String)"EventThread is still running", (boolean)eventThread.isAlive());
        zk = this.createClient(5000);
        zk.create("/stest", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        this.tearDown();
        zk.close();
        zk.disconnect();
        this.setUp();
        zk = this.createClient(5000);
        SessionTest.assertTrue((zk.exists("/stest", false) != null ? 1 : 0) != 0);
        Thread.sleep(10000L);
        SessionTest.assertTrue((zk.exists("/stest", false) == null ? 1 : 0) != 0);
        zk.close();
    }

    @Test
    public void testSessionMove() throws IOException, InterruptedException, KeeperException {
        String[] hostPorts = HOSTPORT.split(",");
        DisconnectableZooKeeper zk = new DisconnectableZooKeeper(hostPorts[0], ClientBase.CONNECTION_TIMEOUT, this);
        zk.create("/sessionMoveTest", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        for (int i = 0; i < hostPorts.length * 2; ++i) {
            DisconnectableZooKeeper zknew = new DisconnectableZooKeeper(hostPorts[(i + 1) % hostPorts.length], ClientBase.CONNECTION_TIMEOUT, this, zk.getSessionId(), zk.getSessionPasswd());
            zknew.setData("/", new byte[1], -1);
            try {
                zk.setData("/", new byte[1], -1);
                SessionTest.fail((String)"Should have lost the connection");
            }
            catch (KeeperException.ConnectionLossException e) {
                // empty catch block
            }
            zk = zknew;
        }
        zk.close();
    }

    @Test
    public void testSessionStateNoDupStateReporting() throws IOException, InterruptedException, KeeperException {
        int TIMEOUT = 3000;
        DupWatcher watcher = new DupWatcher();
        DisconnectableZooKeeper zk = this.createClient(3000, watcher);
        this.serverFactory.shutdown();
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        SessionTest.assertEquals((int)2, (int)watcher.states.size());
        zk.close();
    }

    @Test
    public void testSessionTimeoutAccess() throws Exception {
        DisconnectableZooKeeper zk = this.createClient(12000);
        SessionTest.assertEquals((int)12000, (int)zk.getSessionTimeout());
        LOG.info(zk.toString());
        zk.close();
        LOG.info(zk.toString());
        zk = this.createClient(3000);
        SessionTest.assertEquals((int)6000, (int)zk.getSessionTimeout());
        LOG.info(zk.toString());
        zk.close();
        LOG.info(zk.toString());
        zk = this.createClient(90000);
        SessionTest.assertEquals((int)60000, (int)zk.getSessionTimeout());
        LOG.info(zk.toString());
        zk.close();
        LOG.info(zk.toString());
    }

    @Override
    public void process(WatchedEvent event) {
        LOG.info("Event:" + (Object)((Object)event.getState()) + " " + (Object)((Object)event.getType()) + " " + event.getPath());
        if (event.getState() == Watcher.Event.KeeperState.SyncConnected && this.startSignal != null && this.startSignal.getCount() > 0L) {
            this.startSignal.countDown();
        }
    }

    @Test
    public void testMinMaxSessionTimeout() throws Exception {
        int MINSESS = 20000;
        int MAXSESS = 240000;
        ZooKeeperServer zs = this.serverFactory.getZooKeeperServer();
        zs.setMinSessionTimeout(20000);
        zs.setMaxSessionTimeout(240000);
        int timeout = 120000;
        DisconnectableZooKeeper zk = this.createClient(timeout);
        SessionTest.assertEquals((int)timeout, (int)zk.getSessionTimeout());
        LOG.info(zk.toString());
        zk.close();
        LOG.info(zk.toString());
        zk = this.createClient(10000);
        SessionTest.assertEquals((int)20000, (int)zk.getSessionTimeout());
        LOG.info(zk.toString());
        zk.close();
        LOG.info(zk.toString());
        zk = this.createClient(480000);
        SessionTest.assertEquals((int)240000, (int)zk.getSessionTimeout());
        LOG.info(zk.toString());
        zk.close();
        LOG.info(zk.toString());
    }

    private class DupWatcher
    extends CountdownWatcher {
        public LinkedList<WatchedEvent> states;

        private DupWatcher() {
            this.states = new LinkedList();
        }

        public void process(WatchedEvent event) {
            super.process(event);
            if (event.getType() == Watcher.Event.EventType.None) {
                this.states.add(event);
            }
        }
    }

    private static class CountdownWatcher
    implements Watcher {
        volatile CountDownLatch clientConnected = new CountDownLatch(1);

        private CountdownWatcher() {
        }

        public void process(WatchedEvent event) {
            if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                this.clientConnected.countDown();
            }
        }
    }
}

