/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.NIOServerCnxn;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.upgrade.UpgradeMain;
import org.apache.zookeeper.test.ClientBase;

public class UpgradeTest
extends TestCase
implements Watcher {
    private static final Logger LOG = Logger.getLogger(UpgradeTest.class);
    private static String HOSTPORT = "127.0.0.1:" + PortAssignment.unique();
    private static final File testData = new File(System.getProperty("test.data.dir", "build/test/data"));
    private CountDownLatch startSignal;

    protected void setUp() throws Exception {
        LOG.info("STARTING " + this.getName());
    }

    protected void tearDown() throws Exception {
        LOG.info("FINISHED " + this.getName());
    }

    public void testUpgrade() throws Exception {
        File upgradeDir = new File(testData, "upgrade");
        UpgradeMain upgrade = new UpgradeMain(upgradeDir, upgradeDir);
        upgrade.runUpgrade();
        ZooKeeperServer zks = new ZooKeeperServer(upgradeDir, upgradeDir, 3000);
        SyncRequestProcessor.setSnapCount(1000);
        int PORT = Integer.parseInt(HOSTPORT.split(":")[1]);
        NIOServerCnxn.Factory f = new NIOServerCnxn.Factory(new InetSocketAddress(PORT));
        f.startup(zks);
        LOG.info("starting up the zookeeper server .. waiting");
        UpgradeTest.assertTrue((String)"waiting for server being up", (boolean)ClientBase.waitForServerUp(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
        ZooKeeper zk = new ZooKeeper(HOSTPORT, ClientBase.CONNECTION_TIMEOUT, this);
        Stat stat = zk.exists("/", false);
        List<String> children = zk.getChildren("/", false);
        Collections.sort(children);
        for (int i = 0; i < 10; ++i) {
            UpgradeTest.assertTrue((String)"data tree sanity check", (boolean)("test-" + i).equals(children.get(i)));
        }
        zk.create("/upgrade", "upgrade".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        if (zk.exists("/upgrade", false) == null) {
            UpgradeTest.assertTrue((boolean)false);
        }
        zk.close();
        f.shutdown();
        UpgradeTest.assertTrue((String)"waiting for server down", (boolean)ClientBase.waitForServerDown(HOSTPORT, ClientBase.CONNECTION_TIMEOUT));
    }

    public void process(WatchedEvent event) {
        LOG.info("Event:" + (Object)((Object)event.getState()) + " " + (Object)((Object)event.getType()) + " " + event.getPath());
        if (event.getState() == Watcher.Event.KeeperState.SyncConnected && this.startSignal != null && this.startSignal.getCount() > 0L) {
            this.startSignal.countDown();
        }
    }
}

