/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.util.EnumSet;
import junit.framework.TestCase;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.proto.WatcherEvent;
import org.junit.Test;

public class WatchedEventTest
extends TestCase {
    @Test
    public void testCreatingWatchedEvent() {
        EnumSet<Watcher.Event.EventType> allTypes = EnumSet.allOf(Watcher.Event.EventType.class);
        EnumSet<Watcher.Event.KeeperState> allStates = EnumSet.allOf(Watcher.Event.KeeperState.class);
        for (Watcher.Event.EventType et : allTypes) {
            for (Watcher.Event.KeeperState ks : allStates) {
                WatchedEvent we = new WatchedEvent(et, ks, "blah");
                WatchedEventTest.assertEquals((Object)((Object)et), (Object)((Object)we.getType()));
                WatchedEventTest.assertEquals((Object)((Object)ks), (Object)((Object)we.getState()));
                WatchedEventTest.assertEquals((String)"blah", (String)we.getPath());
            }
        }
    }

    @Test
    public void testCreatingWatchedEventFromWrapper() {
        EnumSet<Watcher.Event.EventType> allTypes = EnumSet.allOf(Watcher.Event.EventType.class);
        EnumSet<Watcher.Event.KeeperState> allStates = EnumSet.allOf(Watcher.Event.KeeperState.class);
        for (Watcher.Event.EventType et : allTypes) {
            for (Watcher.Event.KeeperState ks : allStates) {
                WatcherEvent wep = new WatcherEvent(et.getIntValue(), ks.getIntValue(), "blah");
                WatchedEvent we = new WatchedEvent(wep);
                WatchedEventTest.assertEquals((Object)((Object)et), (Object)((Object)we.getType()));
                WatchedEventTest.assertEquals((Object)((Object)ks), (Object)((Object)we.getState()));
                WatchedEventTest.assertEquals((String)"blah", (String)we.getPath());
            }
        }
    }

    @Test
    public void testCreatingWatchedEventFromInvalidWrapper() {
        try {
            WatcherEvent wep = new WatcherEvent(-2342, -252352, "foo");
            WatchedEvent we = new WatchedEvent(wep);
            WatchedEventTest.fail((String)"Was able to create WatchedEvent from bad wrapper");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testConvertingToEventWrapper() {
        WatchedEvent we = new WatchedEvent(Watcher.Event.EventType.NodeCreated, Watcher.Event.KeeperState.Expired, "blah");
        WatcherEvent wew = we.getWrapper();
        WatchedEventTest.assertEquals((int)Watcher.Event.EventType.NodeCreated.getIntValue(), (int)wew.getType());
        WatchedEventTest.assertEquals((int)Watcher.Event.KeeperState.Expired.getIntValue(), (int)wew.getState());
        WatchedEventTest.assertEquals((String)"blah", (String)wew.getPath());
    }
}

