/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.ClientCnxn;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Test;

public class WatcherTest
extends ClientBase {
    protected static final Logger LOG = Logger.getLogger(WatcherTest.class);
    static final int COUNT = 100;
    boolean hasSeenDelete = true;
    final int TIMEOUT = 5000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWatcherCorrectness() throws IOException, InterruptedException, KeeperException {
        ZooKeeper zk = null;
        try {
            String name;
            int i;
            MyWatcher watcher = new MyWatcher();
            zk = this.createClient(watcher, this.hostPort);
            AsyncCallback.StatCallback scb = new AsyncCallback.StatCallback(){

                public void processResult(int rc, String path, Object ctx, Stat stat) {
                }
            };
            AsyncCallback.VoidCallback vcb = new AsyncCallback.VoidCallback(){

                public void processResult(int rc, String path, Object ctx) {
                }
            };
            String[] names = new String[10];
            for (i = 0; i < names.length; ++i) {
                names[i] = name = zk.create("/tc-", "initialvalue".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
                Stat stat = new Stat();
                zk.getData(name, watcher, stat);
                zk.setData(name, "new".getBytes(), stat.getVersion(), scb, null);
                stat = zk.exists(name, watcher);
                zk.delete(name, stat.getVersion(), vcb, null);
            }
            for (i = 0; i < names.length; ++i) {
                name = names[i];
                WatchedEvent event = watcher.events.poll(10L, TimeUnit.SECONDS);
                WatcherTest.assertEquals((String)name, (String)event.getPath());
                WatcherTest.assertEquals((Object)((Object)Watcher.Event.EventType.NodeDataChanged), (Object)((Object)event.getType()));
                WatcherTest.assertEquals((Object)((Object)Watcher.Event.KeeperState.SyncConnected), (Object)((Object)event.getState()));
                event = watcher.events.poll(10L, TimeUnit.SECONDS);
                WatcherTest.assertEquals((String)name, (String)event.getPath());
                WatcherTest.assertEquals((Object)((Object)Watcher.Event.EventType.NodeDeleted), (Object)((Object)event.getType()));
                WatcherTest.assertEquals((Object)((Object)Watcher.Event.KeeperState.SyncConnected), (Object)((Object)event.getState()));
            }
        }
        finally {
            if (zk != null) {
                zk.close();
            }
        }
    }

    @Test
    public void testWatchAutoResetWithPending() throws Exception {
        int i;
        MyWatcher[] watches = new MyWatcher[100];
        MyStatCallback[] cbs = new MyStatCallback[100];
        MyWatcher watcher = new MyWatcher();
        int[] count = new int[1];
        TestableZooKeeper zk = this.createClient(watcher, this.hostPort, 6000);
        TestableZooKeeper zk2 = this.createClient(watcher, this.hostPort, 5000);
        zk2.create("/test", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        for (i = 0; i < 50; ++i) {
            watches[i] = new MyWatcher();
            cbs[i] = new MyStatCallback();
            zk.exists("/test", watches[i], (AsyncCallback.StatCallback)cbs[i], (Object)count);
        }
        zk.exists("/test", false);
        zk.pauseCnxn(3000L);
        Thread.sleep(50L);
        zk2.close();
        this.stopServer();
        watches[0].waitForDisconnected(60000L);
        for (i = 50; i < 100; ++i) {
            watches[i] = new MyWatcher();
            cbs[i] = new MyStatCallback();
            zk.exists("/test", watches[i], (AsyncCallback.StatCallback)cbs[i], (Object)count);
        }
        this.startServer();
        watches[49].waitForConnected(60000L);
        WatcherTest.assertEquals(null, (Object)zk.exists("/test", false));
        Thread.sleep(10L);
        for (i = 0; i < 50; ++i) {
            WatcherTest.assertEquals((String)("For " + i), (int)1, (int)watches[i].events.size());
        }
        for (i = 50; i < 100; ++i) {
            if (cbs[i].rc == 0) {
                WatcherTest.assertEquals((String)("For " + i), (int)1, (int)watches[i].events.size());
                continue;
            }
            WatcherTest.assertEquals((String)("For " + i), (int)0, (int)watches[i].events.size());
        }
        WatcherTest.assertEquals((int)100, (int)count[0]);
        zk.close();
    }

    @Test
    public void testWatcherAutoResetWithGlobal() throws Exception {
        TestableZooKeeper zk = null;
        MyWatcher watcher = new MyWatcher();
        zk = this.createClient(watcher, this.hostPort, 5000);
        this.testWatcherAutoReset(zk, watcher, watcher);
        zk.close();
    }

    @Test
    public void testWatcherAutoResetWithLocal() throws Exception {
        TestableZooKeeper zk = null;
        MyWatcher watcher = new MyWatcher();
        zk = this.createClient(watcher, this.hostPort, 5000);
        this.testWatcherAutoReset(zk, watcher, new MyWatcher());
        zk.close();
    }

    @Test
    public void testWatcherAutoResetDisabledWithGlobal() throws Exception {
        ClientCnxn.setDisableAutoResetWatch(true);
        this.testWatcherAutoResetWithGlobal();
    }

    @Test
    public void testWatcherAutoResetDisabledWithLocal() throws Exception {
        ClientCnxn.setDisableAutoResetWatch(true);
        this.testWatcherAutoResetWithLocal();
    }

    private void testWatcherAutoReset(ZooKeeper zk, MyWatcher globalWatcher, MyWatcher localWatcher) throws Exception {
        WatchedEvent e;
        boolean isGlobal = localWatcher == globalWatcher;
        zk.create("/watchtest", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/watchtest/child", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        if (isGlobal) {
            zk.getChildren("/watchtest", true);
            zk.getData("/watchtest/child", true, new Stat());
            zk.exists("/watchtest/child2", true);
        } else {
            zk.getChildren("/watchtest", localWatcher);
            zk.getData("/watchtest/child", localWatcher, new Stat());
            zk.exists("/watchtest/child2", localWatcher);
        }
        WatcherTest.assertTrue((boolean)localWatcher.events.isEmpty());
        this.stopServer();
        globalWatcher.waitForDisconnected(3000L);
        localWatcher.waitForDisconnected(500L);
        this.startServer();
        globalWatcher.waitForConnected(3000L);
        if (!isGlobal && !ClientCnxn.getDisableAutoResetWatch()) {
            localWatcher.waitForConnected(500L);
        }
        WatcherTest.assertTrue((boolean)localWatcher.events.isEmpty());
        zk.setData("/watchtest/child", new byte[1], -1);
        zk.create("/watchtest/child2", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        if (!ClientCnxn.getDisableAutoResetWatch()) {
            e = localWatcher.events.poll(5000L, TimeUnit.MILLISECONDS);
            WatcherTest.assertEquals((String)e.getPath(), (Object)((Object)Watcher.Event.EventType.NodeDataChanged), (Object)((Object)e.getType()));
            WatcherTest.assertEquals((String)"/watchtest/child", (String)e.getPath());
        }
        if (!ClientCnxn.getDisableAutoResetWatch()) {
            e = localWatcher.events.poll(5000L, TimeUnit.MILLISECONDS);
            WatcherTest.assertEquals((Object)((Object)Watcher.Event.EventType.NodeCreated), (Object)((Object)e.getType()));
            WatcherTest.assertEquals((String)"/watchtest/child2", (String)e.getPath());
        }
        if (!ClientCnxn.getDisableAutoResetWatch()) {
            e = localWatcher.events.poll(5000L, TimeUnit.MILLISECONDS);
            WatcherTest.assertEquals((Object)((Object)Watcher.Event.EventType.NodeChildrenChanged), (Object)((Object)e.getType()));
            WatcherTest.assertEquals((String)"/watchtest", (String)e.getPath());
        }
        WatcherTest.assertTrue((boolean)localWatcher.events.isEmpty());
        this.stopServer();
        globalWatcher.waitForDisconnected(5000L);
        try {
            try {
                localWatcher.waitForDisconnected(500L);
                if (!isGlobal && !ClientCnxn.getDisableAutoResetWatch()) {
                    WatcherTest.fail((String)"Got an event when I shouldn't have");
                }
            }
            catch (TimeoutException toe) {
                if (ClientCnxn.getDisableAutoResetWatch()) {
                    WatcherTest.fail((String)"Didn't get an event when I should have");
                }
            }
        }
        catch (Exception e1) {
            LOG.error("bad", e1);
            throw new RuntimeException(e1);
        }
        this.startServer();
        globalWatcher.waitForConnected(5000L);
        if (isGlobal) {
            zk.getChildren("/watchtest", true);
            zk.getData("/watchtest/child", true, new Stat());
            zk.exists("/watchtest/child2", true);
        } else {
            zk.getChildren("/watchtest", localWatcher);
            zk.getData("/watchtest/child", localWatcher, new Stat());
            zk.exists("/watchtest/child2", localWatcher);
        }
        zk.delete("/watchtest/child2", -1);
        e = localWatcher.events.poll(5000L, TimeUnit.MILLISECONDS);
        WatcherTest.assertEquals((Object)((Object)Watcher.Event.EventType.NodeDeleted), (Object)((Object)e.getType()));
        WatcherTest.assertEquals((String)"/watchtest/child2", (String)e.getPath());
        e = localWatcher.events.poll(5000L, TimeUnit.MILLISECONDS);
        WatcherTest.assertEquals((Object)((Object)Watcher.Event.EventType.NodeChildrenChanged), (Object)((Object)e.getType()));
        WatcherTest.assertEquals((String)"/watchtest", (String)e.getPath());
        WatcherTest.assertTrue((boolean)localWatcher.events.isEmpty());
        this.stopServer();
        globalWatcher.waitForDisconnected(5000L);
        localWatcher.waitForDisconnected(500L);
        this.startServer();
        globalWatcher.waitForConnected(5000L);
        if (!isGlobal && !ClientCnxn.getDisableAutoResetWatch()) {
            localWatcher.waitForConnected(500L);
        }
        zk.delete("/watchtest/child", -1);
        zk.delete("/watchtest", -1);
        if (!ClientCnxn.getDisableAutoResetWatch()) {
            e = localWatcher.events.poll(5000L, TimeUnit.MILLISECONDS);
            WatcherTest.assertEquals((Object)((Object)Watcher.Event.EventType.NodeDeleted), (Object)((Object)e.getType()));
            WatcherTest.assertEquals((String)"/watchtest/child", (String)e.getPath());
        }
        Thread.sleep(1000L);
        WatcherTest.assertTrue((boolean)localWatcher.events.isEmpty());
    }

    private class MyWatcher
    extends ClientBase.CountdownWatcher {
        LinkedBlockingQueue<WatchedEvent> events = new LinkedBlockingQueue();

        private MyWatcher() {
        }

        public void process(WatchedEvent event) {
            super.process(event);
            if (event.getType() != Watcher.Event.EventType.None) {
                try {
                    this.events.put(event);
                }
                catch (InterruptedException e) {
                    LOG.warn("ignoring interrupt during event.put");
                }
            }
        }
    }

    private final class MyStatCallback
    implements AsyncCallback.StatCallback {
        int rc;

        private MyStatCallback() {
        }

        public void processResult(int rc, String path, Object ctx, Stat stat) {
            int[] nArray = (int[])ctx;
            nArray[0] = nArray[0] + 1;
            this.rc = rc;
        }
    }
}

