/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.ClientTest;
import org.apache.zookeeper.test.QuorumBase;
import org.junit.Before;

public class ZkDatabaseCorruptionTest
extends QuorumBase {
    protected static final Logger LOG = Logger.getLogger(ZkDatabaseCorruptionTest.class);
    public static final long CONNECTION_TIMEOUT = ClientTest.CONNECTION_TIMEOUT;
    private final QuorumBase qb = new QuorumBase();

    @Before
    protected void setUp() throws Exception {
        LOG.info("STARTING " + ((Object)((Object)this)).getClass().getName());
        this.qb.setUp();
    }

    protected void tearDown() throws Exception {
        LOG.info("STOPPING " + ((Object)((Object)this)).getClass().getName());
    }

    private void corruptFile(File f) throws IOException {
        RandomAccessFile outFile = new RandomAccessFile(f, "rw");
        outFile.write("fail servers".getBytes());
        outFile.close();
    }

    private void corruptAllSnapshots(File snapDir) throws IOException {
        File[] listFiles;
        for (File f : listFiles = snapDir.listFiles()) {
            if (!f.getName().startsWith("snapshot")) continue;
            this.corruptFile(f);
        }
    }

    public void testCorruption() throws Exception {
        int i;
        ClientBase.waitForServerUp(this.qb.hostPort, 10000L);
        ClientBase.waitForServerUp(this.qb.hostPort, 10000L);
        ZooKeeper zk = new ZooKeeper(this.qb.hostPort, 10000, new Watcher(){

            public void process(WatchedEvent event) {
            }
        });
        SyncRequestProcessor.setSnapCount(100);
        for (int i2 = 0; i2 < 2000; ++i2) {
            zk.create("/0-" + i2, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        zk.close();
        if (this.qb.s5.getPeerState() != QuorumPeer.ServerState.LEADING) {
            throw new Exception("the last server is not the leader");
        }
        QuorumPeer leader = this.qb.s5;
        FileTxnSnapLog snapLog = leader.getTxnFactory();
        File snapDir = snapLog.getSnapDir();
        this.corruptAllSnapshots(snapDir);
        this.qb.shutdownServers();
        this.qb.setupServers();
        this.qb.s1.start();
        this.qb.s2.start();
        this.qb.s3.start();
        this.qb.s4.start();
        try {
            this.qb.s5.start();
            ZkDatabaseCorruptionTest.assertTrue((boolean)false);
        }
        catch (RuntimeException re) {
            LOG.info("Got an error: expected", re);
        }
        String[] list = this.qb.hostPort.split(",");
        for (i = 0; i < 4; ++i) {
            String hp = list[i];
            ZkDatabaseCorruptionTest.assertTrue((String)"waiting for server up", (boolean)ClientBase.waitForServerUp(hp, CONNECTION_TIMEOUT));
            LOG.info(hp + " is accepting client connections");
        }
        zk = this.qb.createClient();
        SyncRequestProcessor.setSnapCount(100);
        for (i = 2000; i < 4000; ++i) {
            zk.create("/0-" + i, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        zk.close();
        QuorumBase.shutdown(this.qb.s1);
        QuorumBase.shutdown(this.qb.s2);
        QuorumBase.shutdown(this.qb.s3);
        QuorumBase.shutdown(this.qb.s4);
    }
}

