/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.StatsTrack;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeperMain;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.test.ClientBase;

public class ZooKeeperQuotaTest
extends ClientBase {
    private static final Logger LOG = Logger.getLogger(ZooKeeperQuotaTest.class);

    protected void setUp() throws Exception {
        super.setUp();
        LOG.info("STARTING " + ((Object)((Object)this)).getClass().getName());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        LOG.info("STOPPING " + ((Object)((Object)this)).getClass().getName());
    }

    public void testQuota() throws IOException, InterruptedException, KeeperException {
        TestableZooKeeper zk = this.createClient();
        String path = "/a/b/v";
        zk.setData("/", "some".getBytes(), -1);
        zk.create("/a", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/b", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/b/v", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/a/b/v/d", "some".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        ZooKeeperMain.createQuota(zk, "/a/b/v", 1000L, 1000);
        String absolutePath = "/zookeeper/quota/a/b/v/zookeeper_limits";
        byte[] data = zk.getData(absolutePath, false, new Stat());
        StatsTrack st = new StatsTrack(new String(data));
        ZooKeeperQuotaTest.assertTrue((String)"bytes are set", (st.getBytes() == 1000L ? 1 : 0) != 0);
        ZooKeeperQuotaTest.assertTrue((String)"num count is set", (st.getCount() == 1000 ? 1 : 0) != 0);
        String statPath = "/zookeeper/quota/a/b/v/zookeeper_stats";
        byte[] qdata = zk.getData(statPath, false, new Stat());
        StatsTrack qst = new StatsTrack(new String(qdata));
        ZooKeeperQuotaTest.assertTrue((String)"bytes are set", (qst.getBytes() == 8L ? 1 : 0) != 0);
        ZooKeeperQuotaTest.assertTrue((String)"cound is set", (qst.getCount() == 2 ? 1 : 0) != 0);
    }
}

