/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test.system;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.test.system.Instance;
import org.apache.zookeeper.test.system.InstanceManager;
import org.apache.zookeeper.test.system.QuorumPeerInstance;
import org.junit.runner.JUnitCore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseSysTest
extends TestCase {
    private static int fakeBasePort = 33222;
    private static String zkHostPort;
    protected String prefix = "/sysTest";
    ZooKeeper zk;
    InstanceManager im;
    int serverCount = defaultServerCount;
    int clientCount = defaultClientCount;
    static int defaultServerCount;
    static int defaultClientCount;
    String serverHostPort;
    String quorumHostPort;
    private static boolean fakeMachines;
    private QuorumPeer[] qps;
    private File[] qpsDirs;
    HashMap<Long, QuorumPeer.QuorumServer> peers;
    static final int tickTime = 2000;
    static final int initLimit = 3;
    static final int syncLimit = 3;
    private Class<? extends Instance> clazz;
    String params;
    private Instance[] fakeBaseClients;

    protected void setUp() throws Exception {
        if (!fakeMachines) {
            String localHost = InetAddress.getLocalHost().getCanonicalHostName();
            this.zk = new ZooKeeper(zkHostPort, 15000, new Watcher(){

                public void process(WatchedEvent e) {
                }
            });
            this.im = new InstanceManager(this.zk, this.prefix);
        }
    }

    protected void tearDown() throws Exception {
        this.im.close();
    }

    public String getHostPort() {
        return this.serverHostPort;
    }

    public int getServerCount() {
        return this.serverCount;
    }

    public int getClientCount() {
        return this.clientCount;
    }

    public void startServers() throws IOException {
        for (int i = 0; i < this.serverCount; ++i) {
            this.startServer(i);
        }
    }

    public void stopServers() throws IOException {
        for (int i = 0; i < this.serverCount; ++i) {
            this.stopServer(i);
        }
    }

    public void startClients() throws IOException {
        for (int i = 0; i < this.clientCount; ++i) {
            this.startClient(i);
        }
    }

    public void stopClients() throws IOException {
        for (int i = 0; i < this.clientCount; ++i) {
            this.stopClient(i);
        }
    }

    public void configureServers(int count) throws Exception {
        this.serverCount = count;
        if (fakeMachines) {
            this.fakeConfigureServers(count);
        } else {
            this.distributedConfigureServers(count);
        }
    }

    private void distributedConfigureServers(int count) throws IOException {
        StringBuilder sbClient = new StringBuilder();
        StringBuilder sbServer = new StringBuilder();
        try {
            for (int i = 0; i < count; ++i) {
                String[] r = QuorumPeerInstance.createServer(this.im, i);
                if (i > 0) {
                    sbClient.append(',');
                    sbServer.append(',');
                }
                sbClient.append(r[0]);
                sbServer.append(r[1]);
            }
            this.serverHostPort = sbClient.toString();
            this.quorumHostPort = sbServer.toString();
        }
        catch (Exception e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.setStackTrace(e.getStackTrace());
            throw ioe;
        }
    }

    private void fakeConfigureServers(int count) throws IOException {
        this.peers = new HashMap();
        this.qps = new QuorumPeer[count];
        this.qpsDirs = new File[count];
        for (int i = 1; i <= count; ++i) {
            this.peers.put(Long.valueOf(i), new QuorumPeer.QuorumServer(i, new InetSocketAddress("127.0.0.1", fakeBasePort + i)));
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            this.qpsDirs[i] = File.createTempFile("sysTest", ".tmp");
            this.qpsDirs[i].delete();
            this.qpsDirs[i].mkdir();
            int port = fakeBasePort + 10 + i;
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append("localhost:");
            sb.append(port);
        }
        this.serverHostPort = sb.toString();
    }

    public void startServer(int index) throws IOException {
        int port = fakeBasePort + 10 + index;
        if (fakeMachines) {
            this.qps[index] = new QuorumPeer(this.peers, this.qpsDirs[index], this.qpsDirs[index], port, 0, (long)(index + 1), 2000, 3, 3);
            this.qps[index].start();
        } else {
            try {
                QuorumPeerInstance.startInstance(this.im, this.quorumHostPort, index);
            }
            catch (Exception e) {
                IOException ioe = new IOException(e.getClass().getName() + ": " + e.getMessage());
                ioe.setStackTrace(e.getStackTrace());
                throw ioe;
            }
        }
    }

    public void stopServer(int index) throws IOException {
        if (fakeMachines) {
            this.qps[index].shutdown();
        } else {
            try {
                QuorumPeerInstance.stopInstance(this.im, index);
            }
            catch (Exception e) {
                IOException ioe = new IOException(e.getMessage());
                ioe.setStackTrace(e.getStackTrace());
                throw ioe;
            }
        }
    }

    public void configureClients(int count, Class<? extends Instance> clazz, String params) throws Exception {
        this.clientCount = count;
        if (fakeMachines) {
            this.fakeConfigureClients(count, clazz, params);
        } else {
            this.distributedConfigureClients(count, clazz, params);
        }
    }

    private void distributedConfigureClients(int count, Class<? extends Instance> clazz, String params) throws IOException {
        this.clazz = clazz;
        this.params = params;
    }

    private void fakeConfigureClients(int count, Class<? extends Instance> clazz, String params) throws IOException, ClassNotFoundException {
        this.fakeBaseClients = new Instance[count];
        for (int i = 0; i < count; ++i) {
            try {
                this.fakeBaseClients[i] = clazz.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                return;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return;
            }
            this.fakeBaseClients[i].configure(i + " " + params);
        }
    }

    public void startClient(int index) throws IOException {
        if (fakeMachines) {
            this.fakeStartClient(index);
        } else {
            this.distributedStartClient(index);
        }
    }

    private void distributedStartClient(int index) throws IOException {
        try {
            this.im.assignInstance("client" + index, this.clazz, index + " " + this.params, 1);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    private void fakeStartClient(int index) {
        this.fakeBaseClients[index].start();
    }

    public void stopClient(int index) throws IOException {
        if (fakeMachines) {
            this.fakeStopClient(index);
        } else {
            this.distributedStopClient(index);
        }
    }

    private void distributedStopClient(int index) throws IOException {
        try {
            this.im.removeInstance("client" + index);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    private void fakeStopClient(int index) {
        this.fakeBaseClients[index].stop();
    }

    public static void main(String[] args) {
        JUnitCore.main((String[])args);
    }

    static {
        try {
            zkHostPort = System.getProperty("sysTest.zkHostPort", InetAddress.getLocalHost().getCanonicalHostName() + ":2181");
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        defaultServerCount = 5;
        defaultClientCount = 7;
        defaultServerCount = Integer.parseInt(System.getProperty("simpleSysTest.defaultServerCount", Integer.toString(defaultServerCount)));
        defaultClientCount = Integer.parseInt(System.getProperty("simpleSysTest.defaultClientCount", Integer.toString(defaultClientCount)));
        fakeMachines = System.getProperty("baseSysTest.fakeMachines", "no").equals("yes");
    }
}

