/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;

public class FatJarMain {
    static HashMap<String, Cmd> cmds = new HashMap();
    static ArrayList<String> order = new ArrayList();

    public static void main(String[] args) throws IOException, ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException {
        String line;
        InputStream is = FatJarMain.class.getResourceAsStream("/mainClasses");
        if (is == null) {
            System.err.println("Couldn't find /mainClasses in classpath.");
            System.exit(3);
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        while ((line = br.readLine()) != null) {
            String[] parts = line.split(":", 3);
            if (parts.length != 3 || parts[0].length() > 0 && parts[0].charAt(0) == '#') continue;
            if (parts[0].length() > 0) {
                cmds.put(parts[0], new Cmd(parts[0], parts[1], parts[2]));
                order.add(parts[0]);
                continue;
            }
            order.add(parts[2]);
        }
        if (args.length == 0) {
            FatJarMain.doHelp();
            return;
        }
        Cmd cmd = cmds.get(args[0]);
        if (cmd == null) {
            FatJarMain.doHelp();
            return;
        }
        Class<?> clazz = Class.forName(cmd.clazz);
        Method main = clazz.getMethod("main", String[].class);
        String[] newArgs = new String[args.length - 1];
        System.arraycopy(args, 1, newArgs, 0, newArgs.length);
        try {
            main.invoke(null, new Object[]{newArgs});
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null) {
                e.getCause().printStackTrace();
            }
            e.printStackTrace();
        }
    }

    private static void doHelp() {
        System.err.println("USAGE: FatJarMain cmd args");
        System.err.println("Available cmds:");
        for (String c : order) {
            Cmd cmd = cmds.get(c);
            if (cmd != null) {
                System.err.println("  " + c + " " + cmd.desc);
                continue;
            }
            System.err.println(c);
        }
        System.exit(2);
    }

    static class Cmd {
        String cmd;
        String clazz;
        String desc;

        Cmd(String cmd, String clazz, String desc) {
            this.cmd = cmd;
            this.clazz = clazz;
            this.desc = desc;
        }
    }
}

